/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.base.store.client.web;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.bizvane.base.common.bean.ErrorInfo;
import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.store.bean.StoreBean;
import com.bizvane.base.store.bean.StoreReqBean;
import com.bizvane.base.store.bean.dto.StoreDTO;
import com.bizvane.base.store.service.inter.IStoreService;
import com.bizvane.base.store.valid.StoreSaveGroup;
import com.bizvane.base.store.valid.StoreUpdateGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/store"})
@Validated
public class StoreController {
    private static final Logger log = LoggerFactory.getLogger(StoreController.class);
    @Autowired
    private IStoreService iStoreService;

    @RequestMapping(value={"/getSysStoreById"}, method={RequestMethod.GET}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    public ResultBean<StoreDTO> getSysStoreById(@RequestParam(value="sysStoreId") @NotNull(message="\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a") Long sysStoreId) {
        log.info("\u6839\u636eid\u67e5\u8be2\u95e8\u5e97\u5165\u53c2:sysStoreId:{}", (Object)sysStoreId);
        ResultBean reuslt = new ResultBean();
        reuslt.setSuccess(Boolean.valueOf(true));
        StoreDTO dto = new StoreDTO();
        StoreBean storeInfo = this.iStoreService.getStoreInfo(sysStoreId);
        BeanUtils.copyProperties((Object)storeInfo, (Object)dto);
        reuslt.setResult((Serializable)dto);
        return reuslt;
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    public ResultBean<StoreDTO> save(@RequestBody @Validated(value={StoreSaveGroup.class}) StoreReqBean storeReqBean) {
        log.info("\u95e8\u5e97\u4fdd\u5b58\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)storeReqBean));
        ResultBean result = new ResultBean();
        StoreDTO store = this.iStoreService.save(storeReqBean.getStoreName(), storeReqBean.getOfflineStoreId(), storeReqBean.getSysCompanyId(), storeReqBean.getSysBrandId(), storeReqBean.getSlaveSysBrandId(), storeReqBean.getDistributorName(), storeReqBean.getStoreType(), storeReqBean.getOfflineStoreCode(), storeReqBean.getSysStoreOnlineCode(), storeReqBean.getStatus(), storeReqBean.getStoreImgs(), storeReqBean.getProvinceName(), storeReqBean.getCityName(), storeReqBean.getAreaName(), storeReqBean.getDetailedAddress(), storeReqBean.getStoreOrcode(), storeReqBean.getIsDisplay(), storeReqBean.getLng(), storeReqBean.getLat(), storeReqBean.getBizArea(), storeReqBean.getShopOwner(), storeReqBean.getStoreSize(), storeReqBean.getDictionaryCode(), storeReqBean.getCreateUserId(), storeReqBean.getCreateUserName(), storeReqBean.getModifiedUserId(), storeReqBean.getModifiedUserName());
        result.setSuccess(Boolean.valueOf(true));
        result.setResult((Serializable)store);
        return result;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    public ResultBean<StoreDTO> update(@RequestBody @Validated(value={StoreUpdateGroup.class}) StoreReqBean storeReqBean) {
        log.info("\u95e8\u5e97\u66f4\u65b0\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)storeReqBean));
        ResultBean result = new ResultBean();
        StoreDTO store = this.iStoreService.update(storeReqBean.getSysStoreId(), storeReqBean.getStoreName(), storeReqBean.getSysBrandId(), storeReqBean.getDistributorName(), storeReqBean.getStoreType(), storeReqBean.getStatus(), storeReqBean.getBizArea(), storeReqBean.getModifiedUserId(), storeReqBean.getModifiedUserName());
        result.setResult((Serializable)store);
        result.setSuccess(Boolean.valueOf(true));
        return result;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    public ResultBean<Integer> delete(@RequestParam(value="sysStoreId") @NotBlank(message="\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a") String sysStoreId) {
        log.info("\u95e8\u5e97\u903b\u8f91\u5220\u9664\u5165\u53c2:{}", (Object)sysStoreId);
        ResultBean result = new ResultBean();
        Integer i = this.iStoreService.deleteById(sysStoreId);
        result.setSuccess(Boolean.valueOf(true));
        result.setResult((Serializable)i);
        return result;
    }

    @RequestMapping(value={"/batchSaveStore/{batchid}"}, method={RequestMethod.POST}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    ResultBean<String> batchSaveStore(@RequestBody List<StoreReqBean> storeList, @PathVariable(value="batchid") String batchid) {
        Assert.checkBetween((int)storeList.size(), (int)1, (int)100);
        log.info("\u4f01\u4e1a:{}\u4e0b\u6279\u91cf\u4fdd\u5b58\u95e8\u5e97\u63a5\u53e3\u5165\u53c2\u6709{}\u6761,batchid:{}", new Object[]{storeList.get(0).getSysCompanyId(), storeList.size(), batchid});
        ResultBean result = new ResultBean();
        Integer i = this.iStoreService.batchSave(storeList);
        List codes = this.iStoreService.getStore(storeList);
        log.info("\u6279\u91cf\u4fdd\u5b58\u4e86{}\u6761,\u67e5\u5230\u7684\u6570\u636e\u662f:{},\u6709{}\u6761", new Object[]{i, codes, codes.size()});
        String reCodes = StringUtils.join((Iterable)codes, (String)",");
        result.setResult((Serializable)((Object)reCodes));
        result.setSuccess(Boolean.valueOf(true));
        return result;
    }

    @RequestMapping(value={"/getStore"}, method={RequestMethod.GET}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    ResultBean<StoreDTO> getStore(@RequestParam(value="sysCompanyId") @NotBlank(message="\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a") String sysCompanyId, @RequestParam(value="sysBrandId") @NotBlank(message="\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a") String sysBrandId, @RequestParam(value="offlineStoreCode") @NotBlank(message="\u7ebf\u4e0b\u95e8\u5e97\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u7ebf\u4e0b\u95e8\u5e97\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a") String offlineStoreCode) {
        log.info("\u83b7\u53d6\u95e8\u5e97\u5165\u53c2:sysCompanyId:{}  sysBrandId:{}  offlineStoreCode:{}", new Object[]{sysCompanyId, sysBrandId, offlineStoreCode});
        ResultBean result = new ResultBean();
        StoreDTO dto = this.iStoreService.getstore(sysCompanyId, sysBrandId, offlineStoreCode);
        result.setResult((Serializable)dto);
        result.setSuccess(Boolean.valueOf(true));
        return result;
    }

    @RequestMapping(value={"/getStoreByCondition"}, method={RequestMethod.GET}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    ResultBean<ArrayList<StoreDTO>> getStoreByCondition(@RequestParam(value="sysCompanyId") @NotBlank(message="\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a") String sysCompanyId, @RequestParam(value="sysBrandId") @NotBlank(message="\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a") String sysBrandId, @RequestParam(value="offlineStoreCode", required=false) String offlineStoreCode, @RequestParam(value="offlineStoreId", required=false) String offlineStoreId) {
        log.info("\u6761\u4ef6\u67e5\u8be2\u95e8\u5e97\u5165\u53c2:sysCompanyId:{}  sysBrandId:{}  offlineStoreCode:{}    offlineStoreId:{}", new Object[]{sysCompanyId, sysBrandId, offlineStoreCode, offlineStoreId});
        ResultBean result = new ResultBean();
        if (StringUtils.isBlank((CharSequence)offlineStoreCode) && StringUtils.isBlank((CharSequence)offlineStoreId)) {
            result.setSuccess(Boolean.valueOf(false));
            result.setErrorInfo(new ErrorInfo("1001", "offlineStoreCode\u548cofflineStoreId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a"));
            return result;
        }
        ArrayList dtos = this.iStoreService.getStore(sysCompanyId, sysBrandId, offlineStoreCode, offlineStoreId);
        result.setResult((Serializable)dtos);
        result.setSuccess(Boolean.valueOf(true));
        return result;
    }
}

