/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.yzw;

import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.yzw.YzwService;
import com.bizvane.connectorservice.entity.yzw.RechargeCardInfoRequestVo;
import com.bizvane.connectorservice.entity.yzw.RechargeCardInfoResponseVo;
import com.bizvane.connectorservice.entity.yzw.RechargeRecordInfoRequestVo;
import com.bizvane.connectorservice.entity.yzw.RechargeRecordInfoResponseVo;
import com.bizvane.connectorservice.interfaces.rpc.YzwConnectorServiceFeign;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class YzwServiceImpl
implements YzwService {
    @Autowired
    private YzwConnectorServiceFeign yzwConnectorServiceFeign;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;

    public ResponseData<List<RechargeCardInfoResponseVo>> getRechargeCards(RechargeCardInfoRequestVo requestVo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        Long brandId = requestVo.getBrandId();
        if (brandId == null) {
            responseData.setMessage("\u54c1\u724c\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        if (modelResponseData != null && modelResponseData.getData() != null) {
            requestVo.setCardNo(((MemberCardLevelModel)modelResponseData.getData()).getCardNo());
        }
        return this.yzwConnectorServiceFeign.getRechargeCards(requestVo);
    }

    public ResponseData<List<RechargeRecordInfoResponseVo>> getRechargeRecordsInfo(RechargeRecordInfoRequestVo requestVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        Long brandId = requestVO.getBrandId();
        if (brandId == null) {
            responseData.setMessage("\u54c1\u724c\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        if (modelResponseData != null && modelResponseData.getData() != null) {
            MemberCardLevelModel memberCardLevelModel = (MemberCardLevelModel)modelResponseData.getData();
            requestVO.setCardNo(memberCardLevelModel.getCardNo());
            requestVO.setPetCard(memberCardLevelModel.getPetCard());
        }
        return this.yzwConnectorServiceFeign.getRechargeRecordsInfo(requestVO);
    }
}

