/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.vg;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletserviceimpl.handler.AppletBizvaneException;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.members.facade.service.api.vg.VGMemberInfoRpcService;
import com.bizvane.members.facade.vo.vg.AllCardResponseVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateService;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VGGetAllMemberInfoServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(VGGetAllMemberInfoServiceImpl.class);
    @Autowired
    private VGMemberInfoRpcService vgMemberInfoRpcService;
    @Autowired
    private RedisTemplateService<String, String> redisTemplateService;
    @Autowired
    private BrandServiceRpc brandServiceRpc;

    public List<AllCardResponseVO> getAllMemberCardByMemberCode(String memberCode) {
        String allCardByGroupMemberCodeStr = (String)this.redisTemplateService.stringGetStringByKey((Object)(memberCode + "_allCardByGroupMemberCode"));
        List allCardByGroupMemberCode = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)allCardByGroupMemberCodeStr)) {
            allCardByGroupMemberCode = JSON.parseArray((String)allCardByGroupMemberCodeStr, AllCardResponseVO.class);
            log.info("VGGetAllMemberInfoServiceImpl#getAllMemberCardByMemberCode#allCardByGroupMemberCodeFromReids:{}", (Object)JSONObject.toJSONString(allCardByGroupMemberCode));
        }
        if (CollectionUtils.isEmpty(allCardByGroupMemberCode)) {
            allCardByGroupMemberCode = (List)this.vgMemberInfoRpcService.getAllCardByGroupMemberCode(memberCode).getData();
            this.redisTemplateService.stringSetValueAndExpireTime((Object)(memberCode + "_allCardByGroupMemberCode"), (Object)JSONObject.toJSONString(allCardByGroupMemberCode), 60000L);
        }
        if (CollectionUtils.isEmpty(allCardByGroupMemberCode)) {
            throw new AppletBizvaneException("\u67e5\u8be2\u7528\u6237\u4ff1\u4e50\u90e8\u4f1a\u5458\u5361\u5931\u8d25");
        }
        return allCardByGroupMemberCode;
    }

    public List<SysBrandPo> getBrandListByCompanyId(Long sysCompanyId) {
        return this.getBrandListByCompanyId(sysCompanyId, null);
    }

    public List<SysBrandPo> getBrandListByCompanyId(Long sysCompanyId, Boolean getAll) {
        ResponseData brandListResponseData = this.brandServiceRpc.getBrandListByCompanyId(sysCompanyId);
        List brandList = (List)brandListResponseData.getData();
        if (brandList == null || brandListResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            log.warn("VGInitServiceImpl#initChildBrandBizvaneSessionId \u67e5\u8be2\u54c1\u724c\u5931\u8d25:{}!", (Object)brandListResponseData.getMessage());
            throw new AppletBizvaneException("\u67e5\u8be2\u54c1\u724c\u5931\u8d25");
        }
        List<SysBrandPo> collect = brandList.stream().filter(sysBrandPo -> sysBrandPo.getParentId() == null).collect(Collectors.toList());
        if (getAll != null && getAll.booleanValue()) {
            log.info("brandListResponseData_getAll:{}", (Object)JSON.toJSONString((Object)brandListResponseData));
            return brandList;
        }
        log.info("brandListResponseData:{}", (Object)JSON.toJSONString((Object)brandListResponseData));
        return collect;
    }
}

