/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.vg;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.ActivityService;
import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletservice.models.vo.vg.VGMbrRegisterRequestVo;
import com.bizvane.appletservice.models.vo.vg.VGRequestHeaderVo;
import com.bizvane.appletserviceimpl.common.ChannelMemberCodeEnum;
import com.bizvane.appletserviceimpl.utils.MD5Util;
import com.bizvane.appletserviceimpl.utils.OptionUtils;
import com.bizvane.core.facade.interfaces.CoreTraceFeign;
import com.bizvane.core.facade.models.po.TracePO;
import com.bizvane.core.facade.models.po.TraceRecordPO;
import com.bizvane.core.facade.models.vo.TraceRecordVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.mktcenterservice.models.bo.MktActivityDetailAndPicture;
import com.bizvane.mktcenterservice.models.vg.VGContentVo;
import com.bizvane.mktcenterservice.models.vo.ProbabilityVO;
import com.bizvane.mktcenterservice.rpc.ActivityEGServiceRpc;
import com.bizvane.mktcenterservice.rpc.ContentServiceRpc;
import com.bizvane.unifiedreg.model.vo.UnifiedRegisterMemberVo;
import com.bizvane.unifiedreg.model.vo.UnifiedRegisterVo;
import com.bizvane.unifiedreg.rpc.MemberChannelRegistrationFeign;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateService;
import com.bizvane.utils.responseinfo.ResponseData;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TestVGLoginServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(TestVGLoginServiceImpl.class);
    @Autowired
    private RedisTemplateService<String, String> redisTemplateService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private CoreTraceFeign coreTraceFeign;
    @Autowired
    private ActivityEGServiceRpc activityEGServiceRpc;
    @Autowired
    private OptionUtils optionUtils;
    @Autowired
    private MemberChannelRegistrationFeign memberChannelRegistrationFeign;
    @Autowired
    private ContentServiceRpc contentServiceRpc;
    @Autowired
    private ActivityService activityService;

    public ResponseData getMbrAndOpenCard(HttpServletRequest request, VGMbrRegisterRequestVo wxMbrRegisteRequestVo) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        String clubBrandId = request.getHeader("clubBrandId");
        if (clubBrandId == null) {
            responseData.setMessage("clubBrandId\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        Long sysBrandId = Long.valueOf(clubBrandId);
        Long sysCompanyId = ((MemberInfoModel)singleMemberModel.getData()).getSysCompanyId();
        String wxUnionId = ((MemberInfoModel)singleMemberModel.getData()).getWxUnionId();
        String channelCode = null;
        AppletBrandMenberBo menberBoRes = new AppletBrandMenberBo();
        log.info("\u5f53\u524d\u54c1\u724c\u4ff1\u4e50\u90e8\u6e20\u9053\u4e3a\u5fae\u4fe1\u6e20\u9053");
        channelCode = ChannelMemberCodeEnum.WX_MINI_MEMBER.getCode();
        String childBizvaneSessionId = MD5Util.md5((String)(bizvaneSessionId + clubBrandId));
        String redisChildMemberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(childBizvaneSessionId + "memberCode"));
        menberBoRes.setSysBrandId(Long.valueOf(sysBrandId));
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{redisChildMemberCode})) {
            menberBoRes.setMemberCode(redisChildMemberCode);
            return this.getMbrInfoByWx(childBizvaneSessionId, menberBoRes, redisChildMemberCode);
        }
        String mktTaskId = wxMbrRegisteRequestVo.getMktTaskId();
        UnifiedRegisterVo unifiedRegisterVo = new UnifiedRegisterVo();
        String uuid = request.getHeader("UUID");
        log.info("UUID\u5f00\u5361={}", (Object)uuid);
        String uuidJONString = null;
        if (StringUtils.isNotBlank((CharSequence)uuid)) {
            uuidJONString = (String)this.redisTemplateService.stringGetStringByKey((Object)uuid);
            log.info("uuidJONString={}", (Object)uuidJONString);
        }
        if (StringUtils.isNotBlank(uuidJONString)) {
            JSONObject JSONobjectUUID = JSONObject.parseObject(uuidJONString);
            String mktActivityId = JSONobjectUUID.getString("mktActivityId");
            ProbabilityVO vo = new ProbabilityVO();
            vo.setMktActivityId(Long.valueOf(mktActivityId));
            ResponseData mktActivityPOWithBLOBs = this.activityEGServiceRpc.getMktActivityPOWithBLOBs(vo);
            Integer activityType = ((MktActivityDetailAndPicture)mktActivityPOWithBLOBs.getData()).getActivityType();
            log.info("activityType={}, mktActivityId={}", (Object)activityType, (Object)mktActivityId);
            unifiedRegisterVo.setActivityId(Long.valueOf(mktActivityId));
            unifiedRegisterVo.setActivityType(activityType);
        }
        String channelUniqueMemberCode = MD5Util.md5((String)(memberCode + sysBrandId));
        String traceId = this.convertTraceId(wxMbrRegisteRequestVo, sysBrandId, sysCompanyId, wxUnionId);
        this.fillTraceInfo(wxMbrRegisteRequestVo, sysBrandId, unifiedRegisterVo, traceId);
        unifiedRegisterVo.setPhone(((MemberInfoModel)singleMemberModel.getData()).getPhone());
        unifiedRegisterVo.setSysBrandId(sysBrandId);
        unifiedRegisterVo.setSysCompanyId(sysCompanyId);
        unifiedRegisterVo.setChannelUniqueMemberCode(channelUniqueMemberCode);
        unifiedRegisterVo.setChannelCode(channelCode);
        unifiedRegisterVo.setMasterMemberCode(memberCode);
        ResponseData unifiedRegisterMemberVoResponseData = null;
        try {
            unifiedRegisterMemberVoResponseData = this.memberChannelRegistrationFeign.unifiedRegister(unifiedRegisterVo);
        }
        catch (Exception e) {
            log.info("\u5f00\u5361\u63a5\u53e3\u8c03\u7528\u5f02\u5e38:{}", (Throwable)e);
            ResponseData responseDataError = (ResponseData)JSON.parseObject((String)e.getMessage().split("content:")[1], ResponseData.class);
            return new ResponseData(100, responseDataError.getMessage());
        }
        log.info("\u5f00\u5361\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)unifiedRegisterMemberVoResponseData));
        if (unifiedRegisterMemberVoResponseData == null || unifiedRegisterMemberVoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            return new ResponseData(100, "\u5fae\u4fe1\u6388\u6743\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u518d\u8bd5");
        }
        UnifiedRegisterMemberVo unifiedRegisterMemberVoResponseDataData = (UnifiedRegisterMemberVo)unifiedRegisterMemberVoResponseData.getData();
        String childMemberCode = unifiedRegisterMemberVoResponseDataData.getMemberCode();
        menberBoRes.setMemberCode(childMemberCode);
        Integer operateType = null;
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(childBizvaneSessionId + "memberCode"), (Object)childMemberCode, 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(childMemberCode + "bizvaneSessionId"), (Object)childBizvaneSessionId, 7776000000L);
        this.activityService.executeActivity(Long.valueOf(sysBrandId), childMemberCode, operateType);
        if (StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getOderMemberCode())) {
            this.activityService.inviteOpenCoder(childMemberCode, wxMbrRegisteRequestVo.getOderMemberCode(), mktTaskId);
        }
        this.insertTraceRecord(wxMbrRegisteRequestVo, menberBoRes);
        VGRequestHeaderVo requestHeader = this.optionUtils.getRequestHeader(unifiedRegisterMemberVoResponseDataData.getMemberCode());
        VGContentVo vgContentVo = new VGContentVo();
        vgContentVo.setMemberCode(unifiedRegisterMemberVoResponseDataData.getMemberCode());
        vgContentVo.setPage(requestHeader.getPage());
        vgContentVo.setSourceid(requestHeader.getSourceid());
        this.contentServiceRpc.openOrBindCard(vgContentVo);
        return this.getMbrInfoByWx(bizvaneSessionId, menberBoRes, childMemberCode);
    }

    private void fillTraceInfo(VGMbrRegisterRequestVo wxMbrRegisteRequestVo, Long sysBrandId, UnifiedRegisterVo unifiedRegisterVo, String traceId) {
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            try {
                ResponseData tracePOResponseData = this.coreTraceFeign.selectByTraceId(Long.valueOf(traceId));
                int code = tracePOResponseData.getCode();
                TracePO data = (TracePO)tracePOResponseData.getData();
                if (SysResponseEnum.SUCCESS.getCode() == code && data != null) {
                    if (data.getBrandId().compareTo(sysBrandId) == 0) {
                        String traceValue = data.getTraceValue();
                        JSONObject obj = JSON.parseObject((String)traceValue);
                        String storeId = obj.getString("storeId");
                        String guideId = obj.getString("guideId");
                        String source_way = obj.getString("source_way");
                        if (StringUtils.isNotEmpty((CharSequence)storeId)) {
                            unifiedRegisterVo.setSysStoreId(Long.valueOf(storeId));
                        }
                        if (StringUtils.isNotEmpty((CharSequence)guideId)) {
                            unifiedRegisterVo.setSysStoreId(Long.valueOf(guideId));
                        }
                        if (StringUtils.isNotEmpty((CharSequence)source_way)) {
                            unifiedRegisterVo.setSourceWay(source_way);
                        }
                        unifiedRegisterVo.setTraceValue(traceValue);
                    } else {
                        log.warn("\u5f53\u524d\u4f20\u5165traceId\u5bf9\u5e94\u54c1\u724c\u548c\u4ff1\u4e50\u90e8\u4e0d\u4e00\u81f4");
                    }
                }
            }
            catch (NumberFormatException e) {
                log.error("\u5165\u4f1a\u65f6\u8f6c\u6362traceId\u5931\u8d25:{}", (Throwable)e);
            }
        }
    }

    private String convertTraceId(VGMbrRegisterRequestVo wxMbrRegisteRequestVo, Long sysBrandId, Long sysCompanyId, String wxUnionId) {
        String traceId = null;
        if (StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getTraceId()) && !"null".equals(wxMbrRegisteRequestVo.getTraceId())) {
            traceId = wxMbrRegisteRequestVo.getTraceId();
        } else {
            TraceRecordVo traceRecordVo = new TraceRecordVo();
            traceRecordVo.setUnionId(wxUnionId);
            traceRecordVo.setSysCompanyId(sysCompanyId);
            traceRecordVo.setBrandId(sysBrandId);
            try {
                ResponseData traceRecordPOResponseData = this.coreTraceFeign.selectTraceRecord(traceRecordVo);
                log.info("selectTraceRecord\u65b9\u6cd5\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)traceRecordPOResponseData));
                if (traceRecordPOResponseData.getData() != null) {
                    traceId = ((TraceRecordPO)traceRecordPOResponseData.getData()).getTraceId().toString();
                }
            }
            catch (Exception e) {
                log.warn("coreTraceFeign.selectTraceRecord error:{}", (Throwable)e);
            }
        }
        return traceId;
    }

    private ResponseData<AppletBrandMenberBo> getMbrInfoByWx(String childBizvaneSessionId, AppletBrandMenberBo menberBoRes, String clubMemberCode) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(clubMemberCode);
        ResponseData model = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        if (model.getData() != null) {
            String phone = ((MemberInfoModel)model.getData()).getPhone();
            this.redisTemplateService.stringSetValueAndExpireTime((Object)("Phone:" + clubMemberCode), (Object)phone, 7776000000L);
        }
        log.info("getUserInfo childMemberCode={}  childBizvaneSessionId={}", (Object)clubMemberCode, (Object)childBizvaneSessionId);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(childBizvaneSessionId + "MemberCode"), (Object)clubMemberCode, 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(clubMemberCode + "BizvaneSessionId"), (Object)childBizvaneSessionId, 7776000000L);
        log.info("memberCode\u6388\u6743\u5df2\u5f00\u5361={}", this.redisTemplateService.stringGetStringByKey((Object)(childBizvaneSessionId + "MemberCode")));
        menberBoRes.setMemberCode(clubMemberCode);
        menberBoRes.setOpenCard(true);
        menberBoRes.setBrandName(((MemberInfoModel)model.getData()).getOfflineBrandCode());
        log.info("openCard={}", (Object)JSON.toJSONString((Object)menberBoRes));
        return new ResponseData((Object)menberBoRes);
    }

    private void insertTraceRecord(VGMbrRegisterRequestVo wxMbrRegisteRequestVo, AppletBrandMenberBo menberBoRes) {
        TraceRecordVo traceRecordVo = new TraceRecordVo();
        traceRecordVo.setOpenId(menberBoRes.getOpenId());
        traceRecordVo.setSysCompanyId(menberBoRes.getSysCompanyId());
        traceRecordVo.setBrandId(menberBoRes.getSysBrandId());
        traceRecordVo.setUnionId(menberBoRes.getUnionId());
        if (StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getTraceId()) && !"null".equals(wxMbrRegisteRequestVo.getTraceId())) {
            traceRecordVo.setTraceId(Long.valueOf(wxMbrRegisteRequestVo.getTraceId()));
            this.coreTraceFeign.saveTraceRecord(traceRecordVo);
        }
        log.info("\u54c1\u724c\u4ff1\u4e50\u90e8\u4f1a\u5458\u5f00\u5361,traceRecord,\u5185\u5bb9:{},appid={}", (Object)JSONObject.toJSONString((Object)traceRecordVo), (Object)menberBoRes.getAppid());
    }
}

