/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.models.bo.AppletBtfBo;
import com.bizvane.appletservice.models.po.AppletVipCartPO;
import com.bizvane.appletservice.models.po.AppletVipCartPOExample;
import com.bizvane.appletserviceimpl.mappers.AppletBrandTemplateRelPOMapper;
import com.bizvane.appletserviceimpl.mappers.AppletVipCartPOMapper;
import com.bizvane.fitmentservice.models.Rpc.MbrCenterPictureRpc;
import com.bizvane.members.facade.models.MembersSysModel;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.mktcenterservice.models.bo.ActivityOrderBO;
import com.bizvane.mktcenterservice.models.bo.MktActivityDetailAndPicture;
import com.bizvane.mktcenterservice.models.bo.MktActivityPrizeRecordBO;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizeRecordPO;
import com.bizvane.mktcenterservice.models.vo.ActivityPrizeBO;
import com.bizvane.mktcenterservice.models.vo.ProbabilityVO;
import com.bizvane.mktcenterservice.rpc.ActivityEGServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityPrizeServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityServiceRpc;
import com.bizvane.utils.redisutils.RedisClient;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataQueryService {
    private static final Logger log = LoggerFactory.getLogger(DataQueryService.class);
    private static long CACHE_TIME = 60L;
    private static long CACHE_TIME_ONE_HOUR_TO_S = 3600L;
    private static long CACHE_TIME_SHORT = 3L;
    private static final String REDIS_KEY_SELECTTEMPLATECODE = "applet:dataquery:selectTemplateCode:";
    private static final String REDIS_KEY_GETMEMBERSHIPCARD = "applet:dataquery:getMembershipCard:";
    private static final String REDIS_KEY_QUERYMEMBERSYS = "applet:dataquery:queryMemberSys:";
    private static final String REDIS_KEY_GETISSHAREIMG = "applet:dataquery:getIsShareImg:";
    private static final String REDIS_KEY_GETMKTACTIVITYEGBO2C = "applet:dataquery:getMktActivityEGBO2C:";
    private static final String REDIS_KEY_SELECTACTIVITYORDERBYID2C = "applet:dataquery:selectActivityOrderById2C:";
    private static final String REDIS_KEY_GETPRIZERECORDLISTRPC = "applet:dataquery:getPrizeRecordListRpc:";
    private static final String REDIS_KEY_GETPRIZERECORDLISTRPC_NEW = "applet:dataquery:getPrizeRecordListRpcNew:";
    private static final String REDIS_KEY_SELECTPRIZELIST = "applet:dataquery:selectPrizeList:";
    private static final String REDIS_KEY_GETEGPRIZERECORDLIST = "applet:dataquery:getEGPrizeRecordList:";
    private static final String REDIS_KEY_SELECTMKTACTIVITYDETAILANDPICTURE = "applet:dataquery:selectMktActivityDetailAndPicture:";
    @Autowired
    private RedisClient redisClient;
    @Autowired
    protected AppletBrandTemplateRelPOMapper appletBrandTemplateRelPoMapper;
    @Autowired
    private AppletVipCartPOMapper appletVipCartPoMapper;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private MbrCenterPictureRpc mbrCenterPictureRpc;
    @Autowired
    private ActivityEGServiceRpc activityEGServiceRpc;
    @Autowired
    private ActivityServiceRpc activityServiceRpc;
    @Autowired
    private ActivityPrizeServiceRpc activityPrizeServiceRpc;

    public AppletBtfBo selectTemplateCode(Long sysBrandId) {
        Object object = this.redisClient.get(REDIS_KEY_SELECTTEMPLATECODE + sysBrandId);
        if (object != null) {
            log.info("DataQueryService_selectTemplateCode_cache");
            return (AppletBtfBo)object;
        }
        AppletBtfBo bo = this.appletBrandTemplateRelPoMapper.selectTemplateCode(sysBrandId);
        this.redisClient.set(REDIS_KEY_SELECTTEMPLATECODE + sysBrandId, (Object)bo, Long.valueOf(CACHE_TIME));
        log.info("DataQueryService_selectTemplateCode_db");
        return bo;
    }

    public List<AppletVipCartPO> getMembershipCard(Long gradeId) {
        Object object = this.redisClient.get(REDIS_KEY_GETMEMBERSHIPCARD + gradeId);
        if (object != null) {
            log.info("DataQueryService_getMembershipCard_cache");
            return (List)object;
        }
        AppletVipCartPOExample appletVipCartPOExample = new AppletVipCartPOExample();
        appletVipCartPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andGradeIdEqualTo(gradeId);
        List list = this.appletVipCartPoMapper.selectByExample(appletVipCartPOExample);
        this.redisClient.set(REDIS_KEY_GETMEMBERSHIPCARD + gradeId, (Object)list, Long.valueOf(CACHE_TIME));
        log.info("DataQueryService_getMembershipCard_db");
        return list;
    }

    public List<AppletVipCartPO> getMembershipCardNew(Long sysBrandId, Long gradeId) {
        Object object = this.redisClient.get(REDIS_KEY_GETMEMBERSHIPCARD + sysBrandId + ":" + gradeId);
        if (object != null) {
            log.info("DataQueryService_getMembershipCardNew_cache");
            return (List)object;
        }
        AppletVipCartPOExample appletVipCartPOExample = new AppletVipCartPOExample();
        appletVipCartPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andGradeIdEqualTo(gradeId).andSysBrandIdEqualTo(sysBrandId);
        List list = this.appletVipCartPoMapper.selectByExample(appletVipCartPOExample);
        this.redisClient.set(REDIS_KEY_GETMEMBERSHIPCARD + sysBrandId + ":" + gradeId, (Object)list, Long.valueOf(CACHE_TIME));
        log.info("DataQueryService_getMembershipCardNew_db");
        return list;
    }

    public MembersSysModel queryMemberSys(Long brandId) {
        Object object = this.redisClient.get(REDIS_KEY_QUERYMEMBERSYS + brandId);
        if (object != null) {
            log.info("DataQueryService_queryMemberSys_cache");
            return (MembersSysModel)object;
        }
        ResponseData queryMemberSys = this.memberLevelApiService.queryMemberSys(brandId);
        if (queryMemberSys.getData() != null) {
            this.redisClient.set(REDIS_KEY_QUERYMEMBERSYS + brandId, queryMemberSys.getData(), Long.valueOf(CACHE_TIME));
            log.info("DataQueryService_queryMemberSys_db");
            return (MembersSysModel)queryMemberSys.getData();
        }
        log.info("DataQueryService_queryMemberSys_notData");
        return null;
    }

    public String getIsShareImg(Long brandId) {
        Object object = this.redisClient.get(REDIS_KEY_GETISSHAREIMG + brandId);
        if (object != null) {
            log.info("DataQueryService_getIsShareImg_cache");
            return (String)object;
        }
        ResponseData shareImg = this.mbrCenterPictureRpc.getIsShareImg(brandId);
        if (shareImg.getData() != null) {
            this.redisClient.set(REDIS_KEY_GETISSHAREIMG + brandId, (Object)shareImg.getData().toString(), Long.valueOf(CACHE_TIME));
            log.info("DataQueryService_getIsShareImg_db");
            return shareImg.getData().toString();
        }
        log.info("DataQueryService_getIsShareImg_notData");
        return null;
    }

    public MktActivityDetailAndPicture getMktActivityEGBO2C(ProbabilityVO vo) {
        Object object = this.redisClient.get(REDIS_KEY_GETMKTACTIVITYEGBO2C + vo.getMktActivityId());
        if (object != null) {
            log.info("DataQueryService_getMktActivityEGBO2C_cache");
            return (MktActivityDetailAndPicture)object;
        }
        MktActivityDetailAndPicture bo = (MktActivityDetailAndPicture)this.activityEGServiceRpc.getMktActivityBO2C(vo).getData();
        if (bo != null) {
            this.redisClient.set(REDIS_KEY_GETMKTACTIVITYEGBO2C + vo.getMktActivityId(), (Object)bo, Long.valueOf(CACHE_TIME));
            log.info("DataQueryService_getMktActivityEGBO2C_db");
            return bo;
        }
        log.info("DataQueryService_getMktActivityEGBO2C_notData");
        return null;
    }

    public ActivityOrderBO selectActivityOrderById2C(String activityCode) {
        Object object = this.redisClient.get(REDIS_KEY_SELECTACTIVITYORDERBYID2C + activityCode);
        if (object != null) {
            log.info("DataQueryService_selectActivityOrderById2C_cache");
            return (ActivityOrderBO)object;
        }
        ActivityOrderBO bo = (ActivityOrderBO)this.activityServiceRpc.selectActivityOrderById2C(activityCode).getData();
        if (bo != null) {
            this.redisClient.set(REDIS_KEY_SELECTACTIVITYORDERBYID2C + activityCode, (Object)bo, Long.valueOf(CACHE_TIME));
            log.info("DataQueryService_selectActivityOrderById2C_db");
            return bo;
        }
        log.info("DataQueryService_selectActivityOrderById2C_notData");
        return null;
    }

    public List<MktActivityPrizeRecordPO> getPrizeRecordListRpc(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        Object object = this.redisClient.get(REDIS_KEY_GETPRIZERECORDLISTRPC + JSON.toJSONString((Object)mktActivityPrizeRecordPO).hashCode());
        if (object != null) {
            log.info("DataQueryService_getPrizeRecordListRpc_cache");
            return (List)object;
        }
        List list = (List)this.activityPrizeServiceRpc.getPrizeRecordListRpc(mktActivityPrizeRecordPO).getData();
        if (list != null) {
            this.redisClient.set(REDIS_KEY_GETPRIZERECORDLISTRPC + JSON.toJSONString((Object)mktActivityPrizeRecordPO).hashCode(), (Object)list, Long.valueOf(CACHE_TIME));
            log.info("DataQueryService_getPrizeRecordListRpc_db");
            return list;
        }
        log.info("DataQueryService_getPrizeRecordListRpc_notData");
        return null;
    }

    public List<MktActivityPrizeRecordBO> getPrizeRecordListRpcNew(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        return (List)this.activityPrizeServiceRpc.getPrizeRecordListRpcNew(mktActivityPrizeRecordPO).getData();
    }

    public ActivityPrizeBO selectPrizeList(String activePriceCode) {
        Object object = this.redisClient.get(REDIS_KEY_SELECTPRIZELIST + activePriceCode);
        if (object != null) {
            log.info("DataQueryService_selectPrizeList_cache");
            return (ActivityPrizeBO)object;
        }
        ActivityPrizeBO bo = (ActivityPrizeBO)this.activityPrizeServiceRpc.selectPrizeList(activePriceCode).getData();
        if (bo != null) {
            this.redisClient.set(REDIS_KEY_SELECTPRIZELIST + activePriceCode, (Object)bo, Long.valueOf(CACHE_TIME_ONE_HOUR_TO_S));
            log.info("DataQueryService_selectPrizeList_db");
            return bo;
        }
        log.info("DataQueryService_selectPrizeList_notData");
        return null;
    }

    public List<MktActivityPrizeRecordPO> getEGPrizeRecordList(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        Object object = this.redisClient.get(REDIS_KEY_GETEGPRIZERECORDLIST + JSON.toJSONString((Object)mktActivityPrizeRecordPO).hashCode());
        if (object != null) {
            log.info("DataQueryService_getEGPrizeRecordList_cache");
            return (List)object;
        }
        List list = (List)this.activityEGServiceRpc.getEGPrizeRecordList(mktActivityPrizeRecordPO).getData();
        if (list != null) {
            this.redisClient.set(REDIS_KEY_GETEGPRIZERECORDLIST + JSON.toJSONString((Object)mktActivityPrizeRecordPO).hashCode(), (Object)list, Long.valueOf(CACHE_TIME_SHORT));
            log.info("DataQueryService_getEGPrizeRecordList_db");
            return list;
        }
        log.info("DataQueryService_getEGPrizeRecordList_notData");
        return new ArrayList<MktActivityPrizeRecordPO>();
    }

    public MktActivityDetailAndPicture selectMktActivityDetailAndPicture(String activePriceCode) {
        Object object = this.redisClient.get(REDIS_KEY_SELECTMKTACTIVITYDETAILANDPICTURE + activePriceCode);
        if (object != null) {
            log.info("DataQueryService_selectMktActivityDetailAndPicture_cache");
            return (MktActivityDetailAndPicture)object;
        }
        ProbabilityVO probabilityVO = new ProbabilityVO();
        probabilityVO.setActivityCode(activePriceCode);
        MktActivityDetailAndPicture mktActivityDetailAndPicture = (MktActivityDetailAndPicture)this.activityEGServiceRpc.getMktActivityPOWithBLOBs(probabilityVO).getData();
        if (mktActivityDetailAndPicture != null) {
            this.redisClient.set(REDIS_KEY_SELECTMKTACTIVITYDETAILANDPICTURE + activePriceCode, (Object)mktActivityDetailAndPicture, Long.valueOf(CACHE_TIME_ONE_HOUR_TO_S));
            log.info("DataQueryService_selectMktActivityDetailAndPicture_db");
            return mktActivityDetailAndPicture;
        }
        log.info("DataQueryService_selectMktActivityDetailAndPicture_notData");
        return null;
    }
}

