/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.common.HttpUtil;
import com.bizvane.appletservice.interfaces.CreateMembersCardService;
import com.bizvane.appletservice.models.bo.ActivateUserFromBO;
import com.bizvane.appletservice.models.bo.CreateMembersCardBO;
import com.bizvane.appletservice.models.bo.GenerateQrCode;
import com.bizvane.appletservice.models.bo.UpdateMemberInfo;
import com.bizvane.appletservice.models.bo.UpdateMembersCardBO;
import com.bizvane.appletservice.models.bo.WxInterfaceActivateBO;
import com.bizvane.appletservice.models.vo.WxResponseMessage;
import com.bizvane.members.facade.service.electcard.MbrBrandLabelRelRpcService;
import com.bizvane.members.facade.vo.MbrCardLabelRefVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.WxParseUrlFeign;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreateMembersCardServiceRpcImpl
implements CreateMembersCardService {
    public static final Logger logger = LoggerFactory.getLogger(CreateMembersCardServiceRpcImpl.class);
    private static final String CREATE_CARD = "https://api.weixin.qq.com/card/create?access_token=";
    private static final String INTERFACE_ACTIVATE = "https://api.weixin.qq.com/card/membercard/activate?access_token=";
    private static final String UPDATE_CARD = "https://api.weixin.qq.com/card/update?access_token=";
    private static final String GENERATE_QR_CODE = "https://api.weixin.qq.com/card/qrcode/create?access_token=";
    private static final String UPDATE_MEMBER_INTEGRAL = "https://api.weixin.qq.com/card/membercard/updateuser?access_token=";
    private static final String CREATE_MEMBER_CARD_URL = "https://api.weixin.qq.com/card/membercard/activate/geturl?access_token=ACCESS_TOKEN";
    private static final String GET_ACTIVATE_TEMPINFO = "https://api.weixin.qq.com/card/membercard/activatetempinfo/get?access_token=TOKEN";
    private static final String SUCCESS = "ok";
    private static final String CARD_TYPE = "MEMBER_CARD";
    private static final String CODE_TYPE = "CODE_TYPE_TEXT ";
    private static final String QR_CARD = "QR_CARD";
    private static final String QUAN_TITY = "DATE_TYPE_PERMANENT";
    private static final String JUMP_ACTIVATE = "https://api.weixin.qq.com/card/membercard/activateuserform/set?access_token=";
    private static final String UPLOAD_IMAGE = "https://api.weixin.qq.com/cgi-bin/media/uploadimg?access_token=";
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private MbrBrandLabelRelRpcService mbrBrandLabelRelRpcService;
    @Autowired
    private WxParseUrlFeign wxParseUrlFeign;

    public ResponseData<String> createMembersCard(CreateMembersCardBO createMembersCardBO) {
        logger.info("======\u5f00\u59cb\u521b\u5efa\u4f1a\u5458\u5361======{}", (Object)createMembersCardBO.toString());
        Long sysBrandid = createMembersCardBO.getSysBrandId();
        String appid = this.getAppidByBrandId(sysBrandid);
        String token = this.obtainToken(appid);
        logger.info("\u8f6c\u6362url======");
        String backUrl = createMembersCardBO.getCard().getMember_card().getBackground_pic_url();
        String logoUrl = createMembersCardBO.getCard().getMember_card().getBase_info().getLogo_url();
        String newBackUrl = (String)this.wxParseUrlFeign.qiNiuUrlToWxUrl(UPLOAD_IMAGE + token, backUrl).getData();
        String newLogoUrl = (String)this.wxParseUrlFeign.qiNiuUrlToWxUrl(UPLOAD_IMAGE + token, logoUrl).getData();
        System.out.println(UPLOAD_IMAGE + token);
        createMembersCardBO.getCard().getMember_card().setBackground_pic_url(newBackUrl);
        createMembersCardBO.getCard().getMember_card().getBase_info().setLogo_url(newLogoUrl);
        logger.info("\u83b7\u53d6token{}", (Object)token);
        createMembersCardBO.setSysBrandId(null);
        try {
            String json = JSONObject.toJSONString((Object)createMembersCardBO);
            logger.info("\u4f1a\u5458\u5361\u53c2\u6570{}", (Object)json);
            String couns = HttpUtil.post((String)(CREATE_CARD + token), (String)json);
            logger.info("\u521b\u5efa\u4f1a\u5458\u5361\u8fd4\u56de\u7ed3\u679c{}", (Object)couns);
            WxResponseMessage result = (WxResponseMessage)JSON.parseObject((String)couns, WxResponseMessage.class);
            if (SUCCESS.equals(result.getErrmsg())) {
                logger.info("\u4f1a\u5458\u5361\u5df2\u521b\u5efa{}", (Object)result.toString());
                logger.info("\u521b\u5efa\u4f1a\u5458\u8868\u5355....");
                ResponseData data = this.regInfoBO(result.getCard_id(), sysBrandid);
                if (0 == data.getCode()) {
                    return this.returnMessage(true, (Object)result.getCard_id());
                }
                return this.returnMessage(true, (Object)"\u5361\u5957\u521b\u5efa\u6210\u529f...\u6ce8\u518c\u4fe1\u606f\u521b\u5efa\u5931\u8d25");
            }
            return this.returnMessage(false, (Object)result.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.returnMessage(false, (Object)e.toString());
        }
    }

    public ResponseData<String> interfaceActivate(WxInterfaceActivateBO wxInterfaceActivateBO) {
        logger.info("\u6fc0\u6d3b\u4f1a\u5458\u5361........");
        logger.info("\u5165\u53c2{}", (Object)wxInterfaceActivateBO.toString());
        String appid = this.getAppidByBrandId(wxInterfaceActivateBO.getSysBrandId());
        String token = this.obtainToken(appid);
        wxInterfaceActivateBO.setSysBrandId(null);
        String json = JSON.toJSONString((Object)wxInterfaceActivateBO);
        logger.info(json);
        logger.info("\u83b7\u53d6token{}", (Object)token);
        try {
            String couns = HttpUtil.post((String)(INTERFACE_ACTIVATE + token), (String)json);
            logger.info("\u6fc0\u6d3b\u4f1a\u5458\u5361\u7ed3\u679c{}", (Object)couns);
            WxResponseMessage result = (WxResponseMessage)JSON.parseObject((String)couns, WxResponseMessage.class);
            if (SUCCESS.equals(result.getErrmsg())) {
                logger.info("\u4f1a\u5458\u5361\u5df2\u6fc0\u6d3b{}", (Object)result.toString());
                return this.returnMessage(true, null);
            }
            logger.error("\u6fc0\u6d3b\u5931\u8d25", (Object)result.toString());
            return this.returnMessage(false, (Object)result.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.returnMessage(false, (Object)e.toString());
        }
    }

    public ResponseData<String> updateMembersCard(UpdateMembersCardBO updateMembersCardBO) {
        String appid = this.getAppidByBrandId(updateMembersCardBO.getSysBrandId());
        String token = this.obtainToken(appid);
        updateMembersCardBO.setSysBrandId(null);
        logger.info("\u8f6c\u6362url======");
        String backUrl = updateMembersCardBO.getMember_card().getBackground_pic_url();
        String logoUrl = updateMembersCardBO.getMember_card().getBase_info().getLogo_url();
        if (backUrl != null) {
            String newBackUrl = (String)this.wxParseUrlFeign.qiNiuUrlToWxUrl(UPLOAD_IMAGE + token, backUrl).getData();
            updateMembersCardBO.getMember_card().setBackground_pic_url(newBackUrl);
        }
        if (logoUrl != null) {
            String newLogoUrl = (String)this.wxParseUrlFeign.qiNiuUrlToWxUrl(UPLOAD_IMAGE + token, logoUrl).getData();
            updateMembersCardBO.getMember_card().getBase_info().setLogo_url(newLogoUrl);
        }
        String json = JSON.toJSONString((Object)updateMembersCardBO);
        logger.info("\u66f4\u65b0\u4f1a\u5458\u5361{}", (Object)json);
        try {
            String couns = HttpUtil.post((String)(UPDATE_CARD + token), (String)json);
            logger.info("\u66f4\u65b0\u4f1a\u5458\u5361\u7ed3\u679c{}", (Object)couns);
            WxResponseMessage result = (WxResponseMessage)JSON.parseObject((String)couns, WxResponseMessage.class);
            if (SUCCESS.equals(result.getErrmsg())) {
                logger.info("\u4f1a\u5458\u5361\u5df2\u66f4\u65b0{}", (Object)result.toString());
                return this.returnMessage(true, null);
            }
            return this.returnMessage(false, (Object)result.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.returnMessage(false, (Object)e.toString());
        }
    }

    public ResponseData<String> generateQrCode(GenerateQrCode generateQrCode) {
        String appid = this.getAppidByBrandId(generateQrCode.getSysBrandId());
        generateQrCode.setAction_name(QR_CARD);
        String token = this.obtainToken(appid);
        generateQrCode.setSysBrandId(null);
        try {
            String couns = HttpUtil.post((String)(GENERATE_QR_CODE + token), (String)JSON.toJSONString((Object)generateQrCode));
            WxResponseMessage result = (WxResponseMessage)JSON.parseObject((String)couns, WxResponseMessage.class);
            if (SUCCESS.equals(result.getErrmsg())) {
                logger.info("\u4e8c\u7ef4\u7801\u5df2\u751f\u6210{}", (Object)result.toString());
                return this.returnMessage(true, (Object)result.getShow_qrcode_url());
            }
            return this.returnMessage(false, (Object)result.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.returnMessage(false, (Object)e.toString());
        }
    }

    public ResponseData<String> updateMemberIntegral(UpdateMemberInfo updateMemberInfo) {
        String appid = this.getAppidByBrandId(updateMemberInfo.getSysBrandId());
        String token = this.obtainToken(appid);
        updateMemberInfo.setSysBrandId(null);
        String json = JSON.toJSONString((Object)updateMemberInfo);
        logger.info("\u66f4\u65b0\u4f1a\u5458\u79ef\u5206{}", (Object)json);
        logger.info("\u83b7\u53d6token{}", (Object)token);
        try {
            String couns = HttpUtil.post((String)(UPDATE_MEMBER_INTEGRAL + token), (String)json);
            logger.info("\u66f4\u65b0\u4f1a\u5458\u79ef\u5206\u7ed3\u679c{}", (Object)couns);
            WxResponseMessage result = (WxResponseMessage)JSON.parseObject((String)couns, WxResponseMessage.class);
            if (SUCCESS.equals(result.getErrmsg())) {
                logger.info("\u79ef\u5206\u5df2\u66f4\u65b0{}", (Object)result.toString());
                return this.returnMessage(true, null);
            }
            return this.returnMessage(false, (Object)result.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.returnMessage(false, (Object)e.toString());
        }
    }

    public ResponseData<String> updateMemberRegInfo(String cardId, Long sysBrandId) {
        return this.regInfoBO(cardId, sysBrandId);
    }

    public ResponseData<String> createMemberCardUrl(Long sysCompanyId, Long sysBrandId, String cardId, String outStr) {
        ResponseData responseData = new ResponseData();
        ResponseData wxPublicPOResponseData = this.wxPublicServiceFeign.getWxPublicInfo(sysCompanyId, sysBrandId, "1", "00");
        if (wxPublicPOResponseData == null || wxPublicPOResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || wxPublicPOResponseData.getData() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        WxPublicPO wxPublicPO = (WxPublicPO)wxPublicPOResponseData.getData();
        String token = this.obtainToken(wxPublicPO.getAppid());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("card_id", cardId);
        paramMap.put("outer_str", outStr);
        String url = null;
        try {
            url = HttpUtil.post((String)CREATE_MEMBER_CARD_URL.replace("ACCESS_TOKEN", token), (String)JacksonUtil.bean2Json(paramMap));
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        responseData.setData((Object)url);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData<List<Map<String, String>>> getActivateTempInfo(String accessToken, String activateTicket) {
        ResponseData responseData = new ResponseData();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("activate_ticket", activateTicket);
        try {
            String result = HttpUtil.post((String)GET_ACTIVATE_TEMPINFO.replace("TOKEN", accessToken), (String)JacksonUtil.bean2Json(paramMap));
            logger.info("result:{}", (Object)result);
            Map resultMap = (Map)JSONObject.parseObject((String)result, Map.class);
            if (Integer.valueOf(0).equals(resultMap.get("errcode"))) {
                responseData.setData(((Map)resultMap.get("info")).get("common_field_list"));
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                return responseData;
            }
        }
        catch (Exception e) {
            logger.info(ExceptionUtils.getStackTrace((Throwable)e));
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        return responseData;
    }

    private ResponseData<String> regInfoBO(String cardId, Long sysBrandId) {
        String appid = this.getAppidByBrandId(sysBrandId);
        String token = this.obtainToken(appid);
        ActivateUserFromBO bo = new ActivateUserFromBO();
        ActivateUserFromBO.RequiredFormBean re = new ActivateUserFromBO.RequiredFormBean();
        ArrayList<String> requiredList = new ArrayList<String>();
        requiredList.add("USER_FORM_INFO_FLAG_NAME");
        requiredList.add("USER_FORM_INFO_FLAG_MOBILE");
        re.setCommon_field_id_list(requiredList);
        bo.setCard_id(cardId);
        bo.setRequired_form(re);
        ResponseData data = this.mbrBrandLabelRelRpcService.queryMbrBrandLabelRel(sysBrandId);
        List list = (List)data.getData();
        if (list != null) {
            ArrayList<String> optionalList = new ArrayList<String>();
            for (MbrCardLabelRefVO opt : list) {
                if (opt.getIsMust() == 1L) {
                    requiredList.add(this.parseCardLabel(opt.getMbrCardLabelPO().getLabelCode()));
                    continue;
                }
                optionalList.add(this.parseCardLabel(opt.getMbrCardLabelPO().getLabelCode()));
            }
            ActivateUserFromBO.OptionalFormBean opt = new ActivateUserFromBO.OptionalFormBean();
            opt.setCommon_field_id_list(optionalList);
            bo.setOptional_form(opt);
        }
        String fromjson = JSONObject.toJSONString((Object)bo);
        logger.info("\u8868\u5355\u5b57\u6bb5\u8bbe\u7f6ejson{}", (Object)fromjson);
        try {
            String r = HttpUtil.post((String)(JUMP_ACTIVATE + token), (String)fromjson);
            JSONObject jb = JSONObject.parseObject((String)r);
            String regResult = jb.getString("errmsg");
            logger.info("\u8868\u5355\u5b57\u6bb5\u8bbe\u7f6e\u7ed3\u679c{}", (Object)r);
            if (SUCCESS.equals(regResult)) {
                return this.returnMessage(true, (Object)cardId);
            }
            return this.returnMessage(false, (Object)"\u66f4\u65b0\u5931\u8d25");
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.returnMessage(false, (Object)e.toString());
        }
    }

    private String obtainToken(String appid) {
        ResponseData accessTokenByAppId = this.wxPublicServiceFeign.getAccessTokenByAppId(appid);
        String token = (String)accessTokenByAppId.getData();
        return token;
    }

    private ResponseData<String> returnMessage(boolean isSuccess, Object data) {
        ResponseData responseData = new ResponseData();
        if (isSuccess) {
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData(data);
        } else {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setData(data);
        }
        return responseData;
    }

    private String getAppidByBrandId(Long brandId) {
        ResponseData data = this.wxPublicServiceFeign.getWxPublicBySysBrandId(brandId);
        WxPublicPO po = (WxPublicPO)data.getData();
        if (po != null) {
            return po.getAppid();
        }
        return null;
    }

    private String parseCardLabel(String label) {
        switch (label) {
            case "L001": {
                return "USER_FORM_INFO_FLAG_LOCATION";
            }
            case "L002": {
                return "USER_FORM_INFO_FLAG_BIRTHDAY";
            }
            case "L003": {
                return "USER_FORM_INFO_FLAG_EMAIL";
            }
            case "L004": {
                return "USER_FORM_INFO_FLAG_SEX";
            }
        }
        return "";
    }
}

