/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.ActivityService;
import com.bizvane.appletservice.interfaces.vg.VGLoginService;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.customized.facade.interfaces.EvaluationQuestionnaireFeign;
import com.bizvane.customized.facade.models.vo.EvaluationSaveTempRequestVO;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.WxChannelInfoModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.service.api.vg.VGMemberInfoRpcService;
import com.bizvane.members.facade.vo.MemberInfoApiModel;
import com.bizvane.members.facade.vo.WxChannelRelationVo;
import com.bizvane.mktcenterservice.models.bo.TaskWXDetailBO;
import com.bizvane.mktcenterservice.models.vo.InviteSuccessVO;
import com.bizvane.mktcenterservice.models.vo.MemberInfoModelVOActivity;
import com.bizvane.mktcenterservice.rpc.ActivityServiceRpc;
import com.bizvane.mktcenterservice.rpc.TaskInviteServiceRpc;
import com.bizvane.mktcenterservice.rpc.TaskServiceForWXRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatenterprise.service.rpc.WxqyInteractHistoryServiceRpc;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ActivityServiceImpl
implements ActivityService {
    @Autowired
    private ActivityServiceRpc activityServiceRpc;
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private TaskInviteServiceRpc taskInviteServiceRpc;
    @Autowired
    private VGMemberInfoRpcService vgMemberInfoRpcService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private WxqyInteractHistoryServiceRpc wxqyInteractHistoryServiceRpc;
    @Autowired
    private TaskServiceForWXRpc taskServiceForWXRpc;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private EvaluationQuestionnaireFeign evaluationQuestionnaireFeign;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Lazy
    @Autowired
    private VGLoginService vgLoginService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    public ResponseData executeActivity(Long brand, String memberCode, Integer operateType) {
        logger.info("open card executeActivity memberCode {}", (Object)memberCode);
        ResponseData responseData = new ResponseData();
        MemberInfoModelVOActivity memberInfoModel = new MemberInfoModelVOActivity();
        ResponseData memberCardLevelModelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        Long levelId = ((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getLevelId();
        logger.info("levelId\u6d3b\u52a8={}", (Object)levelId);
        Long openCardStoreId = (Long)this.wxAppletApiService.getOpenCardStoreId(memberCode).getData();
        Long serviceStoreId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        logger.info("openCardStoreId={} , serviceStoreId={} , operateType={}", new Object[]{openCardStoreId, serviceStoreId, operateType});
        memberInfoModel.setBrandId(brand);
        memberInfoModel.setMemberCode(memberCode);
        memberInfoModel.setLevelId(levelId);
        memberInfoModel.setOpenCardStoreId(openCardStoreId);
        memberInfoModel.setServiceStoreId(serviceStoreId);
        if (operateType == null) {
            responseData.setMessage("\u5f00\u5361\u72b6\u6001\u672a\u8fd4\u56de");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        if (operateType == 2) {
            memberInfoModel.setOfflineCardStatus(Integer.valueOf(1));
        }
        if (operateType == 1) {
            memberInfoModel.setOfflineCardStatus(Integer.valueOf(2));
        }
        logger.info("\u8c03\u7528\u6d3b\u52a8\u5f00\u5361={}", (Object)("time:" + System.currentTimeMillis()));
        ResponseData integerResponseData = this.activityServiceRpc.executeActivity(memberInfoModel);
        logger.info("open card executeActivity result {}", (Object)JSON.toJSONString((Object)integerResponseData));
        int responseDataData = integerResponseData.getCode();
        if (responseDataData != 0) {
            logger.info("\u5f00\u5361\u6d3b\u52a8\u901a\u77e5\u5931\u8d25");
            return responseData;
        }
        logger.info("\u5f00\u5361\u6d3b\u52a8\u901a\u77e5\u6210\u529f");
        return responseData;
    }

    @Async
    public void inviteOpenCoder(String memberCode, String oderMemberCode, String mktTaskId) {
        logger.info("open card inviteOpenCoder memberCode {}, oldMemberCode {}", (Object)memberCode, (Object)oderMemberCode);
        if (StringUtils.isNotBlank((CharSequence)oderMemberCode)) {
            MemberInfoApiModel members = new MemberInfoApiModel();
            members.setMemberCode(memberCode);
            ResponseData memberModel = this.memberInfoApiService.getMemberModel((MemberInfoModel)members);
            logger.info("ActivityServiceImpl#inviteOpenCoder#memberModel:{}", (Object)JSON.toJSONString((Object)memberModel));
            MemberInfoModel memberInfoModel = (MemberInfoModel)memberModel.getData();
            InviteSuccessVO inviteSuccessVO = new InviteSuccessVO();
            inviteSuccessVO.setInviteMemberCode(oderMemberCode);
            inviteSuccessVO.setMemberCode(memberCode);
            ResponseData allCardByGroupMemberCode = this.vgMemberInfoRpcService.getAllCardByGroupMemberCode(memberInfoModel.getGroupMemberCode());
            List data = (List)allCardByGroupMemberCode.getData();
            logger.info("ActivityServiceImpl#inviteOpenCoder#data.size():{}", (Object)data.size());
            if (data.size() != 1) {
                logger.warn("\u9080\u8bf7\u5f00\u5361\u4efb\u52a1\u975e\u65b0\u4f1a\u5458:{}", (Object)memberCode);
                return;
            }
            long aLong = mktTaskId == null || "null".equals(mktTaskId) ? 0L : Long.parseLong(mktTaskId);
            inviteSuccessVO.setMktTaskId(Long.valueOf(aLong));
            inviteSuccessVO.setOpenCardTime(memberInfoModel.getOpenCardTime());
            this.taskInviteServiceRpc.doAwardInvite(inviteSuccessVO);
        } else {
            logger.info("\u975e\u9080\u8bf7\u5f00\u5361");
        }
    }

    @Async
    public ResponseData changeFansToMember(String openId, String appId, String memberCode, Long sysCompanyId, Long sysBrandId) {
        ResponseData responseData = new ResponseData();
        logger.info("changeFansToMember openId {}, appId {}, memberCode {}", new Object[]{openId, appId, memberCode});
        this.wxqyInteractHistoryServiceRpc.changeFansToMember(openId, appId, memberCode, sysCompanyId, sysBrandId);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData executeTaskCallBack(HttpServletRequest request, Long sysCompanyId, Long sysBrandId, String memberCode, Long mktTaskId) {
        logger.info("executeTaskCallBack sysCompanyId:{},sysCompanyId:{},memberCode:{},mktTaskId:{}", new Object[]{sysCompanyId, sysBrandId, memberCode, mktTaskId});
        ResponseData taskWXDetailRes = this.taskServiceForWXRpc.getTaskWXDetail(mktTaskId);
        if (taskWXDetailRes == null || taskWXDetailRes.getData() == null) {
            logger.info("executeTaskCallBack\u4efb\u52a1\u67e5\u8be2\u4e0d\u5b58\u5728, taskWXDetail:{}", (Object)JacksonUtil.bean2Json((Object)taskWXDetailRes));
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u4efb\u52a1\u67e5\u8be2\u4e0d\u5b58\u5728");
        }
        TaskWXDetailBO taskWXDetailBO = (TaskWXDetailBO)taskWXDetailRes.getData();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        memberInfoModel.setBrandId(sysBrandId);
        memberInfoModel.setSysCompanyId(sysCompanyId);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        logger.info("executeTaskCallBack\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f={}", (Object)JacksonUtil.bean2Json((Object)singleMemberModel));
        MemberInfoModel clubMemberInfo = (MemberInfoModel)singleMemberModel.getData();
        if (clubMemberInfo == null || StringUtils.isBlank((CharSequence)clubMemberInfo.getGroupMemberCode())) {
            logger.info("executeTaskCallBack\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u4e0d\u5b58\u5728memberCode={}", (Object)memberCode);
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!sysBrandId.equals(taskWXDetailBO.getSysBrandId()) && clubMemberInfo.getMemberCode().equals(clubMemberInfo.getGroupMemberCode())) {
            logger.info("executeTaskCallBack\u54c1\u724c\u6821\u9a8c\u4e0d\u901a\u8fc7,\u529e\u7406\u81ea\u52a8\u5165\u4f1a \u6ce8\u518c\u54c1\u724c:{},\u4efb\u52a1\u54c1\u724c:{}", (Object)sysBrandId, (Object)taskWXDetailBO.getSysBrandId());
            clubMemberInfo = this.vgLoginService.simpleJoinClub(request, clubMemberInfo, taskWXDetailBO.getSysBrandId());
            logger.info("executeTaskCallBack\u54c1\u724c\u6821\u9a8c\u4e0d\u901a\u8fc7,\u529e\u7406\u81ea\u52a8\u5165\u4f1a\u7ed3\u679c:{}", (Object)JacksonUtil.bean2Json((Object)clubMemberInfo));
            if (clubMemberInfo == null) {
                return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u81ea\u52a8\u5165\u4f1a\u5931\u8d25");
            }
        }
        if (Integer.valueOf(6).equals(taskWXDetailBO.getTaskType())) {
            logger.info("executeTaskCallBack\u56de\u8c03\u95ee\u5377\u8c03\u67e5,\u5b8c\u5584\u5b9e\u540d\u5236,\u5e76\u6267\u884c\u5bf9\u5e94\u4efb\u52a1\u5956\u52b1");
            WxChannelRelationVo wxChannelRelationVo = new WxChannelRelationVo();
            wxChannelRelationVo.setSysCompanyId(clubMemberInfo.getSysCompanyId());
            wxChannelRelationVo.setMemberCode(clubMemberInfo.getGroupMemberCode());
            wxChannelRelationVo.setMiniProgram(Integer.valueOf(2));
            ResponseData wxChannelInfoRelationRes = this.wxChannelInfoApiService.getWxChannelInfoRelation(wxChannelRelationVo);
            if (wxChannelInfoRelationRes == null || wxChannelInfoRelationRes.getData() == null) {
                logger.info("executeTaskCallBack\u56de\u8c03\u95ee\u5377\u8c03\u67e5,\u67e5\u8be2\u5c0f\u7a0b\u5e8f\u6e20\u9053\u4fe1\u606f\u4e0d\u5b58\u5728,memberCode={},groupMemberCode", (Object)memberCode, (Object)memberInfoModel.getGroupMemberCode());
                return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u67e5\u8be2\u5c0f\u7a0b\u5e8f\u6e20\u9053\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            String appletOpenId = ((WxChannelInfoModel)wxChannelInfoRelationRes.getData()).getOpenId();
            logger.info("executeTaskCallBack\u56de\u8c03\u95ee\u5377\u8c03\u67e5, appletOpenId={}", (Object)appletOpenId);
            if (StringUtils.isBlank((CharSequence)appletOpenId)) {
                return new ResponseData(SysResponseEnum.FAILED.getCode(), "appletOpenId\u4e3a\u7a7a");
            }
            EvaluationSaveTempRequestVO evaluationSaveTempRequestVO = new EvaluationSaveTempRequestVO();
            evaluationSaveTempRequestVO.setSysCompanyId(sysCompanyId);
            evaluationSaveTempRequestVO.setSysBrandId(clubMemberInfo.getBrandId());
            evaluationSaveTempRequestVO.setMemberCode(clubMemberInfo.getMemberCode());
            evaluationSaveTempRequestVO.setCardNo(clubMemberInfo.getCardNo());
            evaluationSaveTempRequestVO.setMemberName(clubMemberInfo.getName());
            evaluationSaveTempRequestVO.setMemberPhone(clubMemberInfo.getPhone());
            evaluationSaveTempRequestVO.setAnswerPeopleType(Integer.valueOf(1));
            evaluationSaveTempRequestVO.setAnswersOpenId(appletOpenId);
            evaluationSaveTempRequestVO.setOpenCardCallback(Boolean.valueOf(true));
            evaluationSaveTempRequestVO.setMktTaskId(taskWXDetailBO.getMktTaskId());
            if (clubMemberInfo.getServiceStoreId() != null) {
                ResponseData storeVoResponseData = this.storeServiceRpc.getSysStoreById(clubMemberInfo.getServiceStoreId());
                evaluationSaveTempRequestVO.setStoreName(storeVoResponseData != null & storeVoResponseData.getData() != null ? ((SysStoreVo)storeVoResponseData.getData()).getStoreName() : "");
            } else {
                evaluationSaveTempRequestVO.setStoreName("");
            }
            ResponseData saveQuestionnaireTaskRes = this.evaluationQuestionnaireFeign.openCardCallBackByTask(evaluationSaveTempRequestVO);
            logger.info("executeTaskCallBack saveQuestionnaireTaskRes:{}", (Object)JacksonUtil.bean2Json((Object)saveQuestionnaireTaskRes));
        }
        return new ResponseData();
    }
}

