/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.wechatmall;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.models.vo.vg.IntegralOrderSendVO;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.messagefacade.interfaces.WechatAppletSubscirbeMessageServiceFeign;
import com.bizvane.messagefacade.interfaces.WechatOrderServiceFeign;
import com.bizvane.messagefacade.models.vo.OrderMessageVO;
import com.bizvane.messagefacade.models.vo.vg.SubscribeMessageVO;
import com.bizvane.messagefacade.models.vo.vg.subscribe.IntegralOrderSendMessageVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/IntegralMallOrderPush"}, method={RequestMethod.POST})
public class IntegralMallOrderPushService {
    private static final Logger log = LoggerFactory.getLogger(IntegralMallOrderPushService.class);
    @Autowired
    private WechatOrderServiceFeign wechatOrderServiceFeign;
    @Autowired
    private WechatAppletSubscirbeMessageServiceFeign wechatAppletSubscirbeMessageServiceFeign;
    @Autowired
    private MemberInfoApiService memberInfoApiService;

    @PostMapping
    public ResponseData sendOrderMessage(@RequestBody IntegralOrderSendVO requestVO) {
        log.info("IntegralMallOrderPushService#sendOrderMessage:{}", (Object)JSON.toJSONString((Object)requestVO));
        OrderMessageVO orderMessageVO = new OrderMessageVO();
        BeanUtils.copyProperties((Object)requestVO, (Object)orderMessageVO);
        ResponseData stringResponseData = this.wechatOrderServiceFeign.integralOrderShip(orderMessageVO);
        log.info("\u63a8\u9001\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)stringResponseData));
        this.fillIntegralOrderSendParamAndSend(requestVO);
        return stringResponseData;
    }

    private void fillIntegralOrderSendParamAndSend(IntegralOrderSendVO requestVO) {
        String memberCode = requestVO.getMemberCode();
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            log.info("memberCode is blank");
            return;
        }
        try {
            IntegralOrderSendMessageVO pushMessageRequestVO = new IntegralOrderSendMessageVO();
            BeanUtils.copyProperties((Object)requestVO, (Object)pushMessageRequestVO);
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(memberCode);
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            MemberInfoModel memberModelData = (MemberInfoModel)singleMemberModel.getData();
            pushMessageRequestVO.setFIELD_MEMBER_CODE(memberModelData.getCardNo());
            pushMessageRequestVO.setFIELD_TEXT(requestVO.getFieldText());
            pushMessageRequestVO.setFIELD_INTEGRAL_GOOD_NAME(requestVO.getIntegralGoodName());
            pushMessageRequestVO.setFIELD_INTEGRAL_ORDER_NO(requestVO.getOrderNo());
            pushMessageRequestVO.setFIELD_INTEGRAL_ORDER_NO(requestVO.getOrderNo());
            pushMessageRequestVO.setFIELD_INTEGRAL_LOGISTICS_COMPANY(requestVO.getLogisticsCompanyName());
            pushMessageRequestVO.setFIELD_INTEGRAL_LOGISTICS_NO(requestVO.getLogisticsNo());
            log.info("wechatAppletSubscirbeMessageServiceFeign.integralOrderSendMessage.param:{}", (Object)JSONObject.toJSONString((Object)pushMessageRequestVO));
            SubscribeMessageVO integralOrderSendMessageVOSubscribeMessageVO = new SubscribeMessageVO();
            integralOrderSendMessageVOSubscribeMessageVO.setMessageInfo((Object)pushMessageRequestVO);
            integralOrderSendMessageVOSubscribeMessageVO.setLinkUrl(requestVO.getLinkUrl());
            ResponseData responseData = this.wechatAppletSubscirbeMessageServiceFeign.integralOrderSendMessage(integralOrderSendMessageVOSubscribeMessageVO);
            log.info("wechatAppletSubscirbeMessageServiceFeign.integralOrderSendMessag.result:{}", (Object)JSONObject.toJSONString((Object)responseData));
        }
        catch (Exception e) {
            log.info("fillIntegralOrderSendParamAndSend.error:{}", (Object)ExceptionUtils.getMessage((Throwable)e));
        }
    }
}

