/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.newmkt;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.bizvane.mktcenterservice.models.newmkt.MktReceiveCouponActivityVO;
import com.bizvane.mktcenterservice.models.newmkt.MktReceiveCouponExecuteVO;
import com.bizvane.mktcenterservice.rpc.newmkt.ActivityReceiveCouponRpcService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.util.Collection;
import java.util.List;
import org.apache.catalina.servlet4preview.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/receiveCouponactivity"})
public class ReceiveCouponActivityController {
    @Autowired
    private ActivityReceiveCouponRpcService activityReceiveCouponRpcService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Value(value="#{'${newmkt.receviceCoupon}'.split(',')}")
    private List<Long> receviceCouponCompanyIds;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/getReceiveCouponListByQrCode"}, method={RequestMethod.POST})
    public ResponseData<MktReceiveCouponActivityVO> getReceiveCouponListByQrCode(String taskCode, HttpServletRequest request) {
        logger.info("ReceiveCouponActivityController getReceiveCouponListByQrCode taskCode:{}", (Object)taskCode);
        String sysBrandIdStr = request.getHeader("sysBrandId");
        String sysCompanyIdStr = request.getHeader("sysCompanyId");
        ResponseData responseData = new ResponseData();
        if (StringUtils.isEmpty((CharSequence)sysBrandIdStr) || StringUtils.isEmpty((CharSequence)sysCompanyIdStr)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return responseData;
        }
        if (StringUtils.isEmpty((CharSequence)taskCode)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (StringUtils.isEmpty((CharSequence)bizvaneSessionId)) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isEmpty((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        logger.info("new\u626b\u7801\u9886\u52b5\u5165\u53c2: taskCode:{},sysBrandId:{},sysCompanyId:{},memberCode:{}", new Object[]{taskCode, sysBrandIdStr, sysCompanyIdStr, memberCode});
        responseData = this.activityReceiveCouponRpcService.getReceiveCouponListByQrCode(Long.valueOf(Long.parseLong(sysBrandIdStr)), Long.valueOf(Long.parseLong(sysCompanyIdStr)), taskCode, memberCode);
        return responseData;
    }

    @RequestMapping(value={"/getReceiveCouponList"}, method={RequestMethod.POST})
    public ResponseData<List<MktReceiveCouponActivityVO>> getReceiveCouponList(HttpServletRequest request) {
        logger.info("ReceiveCouponActivityController getReceiveCouponList start!");
        String sysBrandIdStr = request.getHeader("sysBrandId");
        String sysCompanyIdStr = request.getHeader("sysCompanyId");
        ResponseData responseData = new ResponseData();
        if (StringUtils.isEmpty((CharSequence)sysBrandIdStr) || StringUtils.isEmpty((CharSequence)sysCompanyIdStr)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (StringUtils.isEmpty((CharSequence)bizvaneSessionId)) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isEmpty((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        logger.info("new\u626b\u7801\u9886\u52b5\u5165\u53c2: sysBrandId:{},sysCompanyId:{},memberCode:{}", new Object[]{sysBrandIdStr, sysCompanyIdStr, memberCode});
        responseData = this.activityReceiveCouponRpcService.getReceiveCouponList(Long.valueOf(Long.parseLong(sysBrandIdStr)), Long.valueOf(Long.parseLong(sysCompanyIdStr)), memberCode);
        return responseData;
    }

    @RequestMapping(value={"/executeReceiveCoupon"}, method={RequestMethod.POST})
    public ResponseData<Integer> executeReceiveCoupon(MktReceiveCouponExecuteVO vo, HttpServletRequest request) {
        logger.info("ReceiveCouponActivityController executeReceiveCoupon param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        ResponseData responseData = new ResponseData();
        String sysBrandIdStr = request.getHeader("sysBrandId");
        String sysCompanyIdStr = request.getHeader("sysCompanyId");
        if (StringUtils.isEmpty((CharSequence)sysBrandIdStr) || StringUtils.isEmpty((CharSequence)sysCompanyIdStr)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return responseData;
        }
        vo.setSysCompanyId(Long.valueOf(Long.parseLong(sysCompanyIdStr)));
        vo.setSysBrandId(Long.valueOf(Long.parseLong(sysBrandIdStr)));
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (StringUtils.isEmpty((CharSequence)bizvaneSessionId)) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isEmpty((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        vo.setMemberCode(memberCode);
        logger.info("\u626b\u7801\u9886\u53d6\u5165\u53c2={}", (Object)JSON.toJSONString((Object)vo));
        return this.activityReceiveCouponRpcService.executeReceiveCoupon(vo);
    }

    @RequestMapping(value={"judgementReceiveActivity"})
    public ResponseData<Boolean> judgementReceiveActivity(HttpServletRequest request) {
        logger.info("ReceiveCouponActivityController judgementReceiveActivity!");
        ResponseData responseData = new ResponseData();
        responseData.setData((Object)false);
        String sysCompanyIdStr = request.getHeader("sysCompanyId");
        if (CollectionUtils.isNotEmpty((Collection)this.receviceCouponCompanyIds) && this.receviceCouponCompanyIds.contains(Long.parseLong(sysCompanyIdStr))) {
            responseData.setData((Object)true);
        }
        return responseData;
    }
}

