/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.huaiRen;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bizvane.appletservice.interfaces.huaiRen.HuaiRenGetNumService;
import com.bizvane.appletservice.models.vo.HuaiRenIntegralExchangeShowVO;
import com.bizvane.appletservice.models.vo.HuaiRenIntegralExchangeVO;
import com.bizvane.appletservice.models.vo.HuaiRenRequestVO;
import com.bizvane.appletserviceimpl.constant.Constant;
import com.bizvane.appletserviceimpl.vo.HuairenHealthResVo;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.out.huairen.HuaiRenGetHealthRequestVO;
import com.bizvane.connectorservice.entity.out.huairen.HuaiRenGetHealthResponseVO;
import com.bizvane.connectorservice.interfaces.rpc.OutOfConnectServiceFeign;
import com.bizvane.customized.facade.interfaces.AdvertisementSpaceServiceFeign;
import com.bizvane.customized.facade.models.vo.AdvertisementSpaceRequestVO;
import com.bizvane.customized.facade.models.vo.AdvertisementSpaceResponseVO;
import com.bizvane.customized.facade.utils.ResponseUtils;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.HuaiRenDrugServerApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.vo.GetHuaiRenDrugServerRecordListRequestVO;
import com.bizvane.members.facade.vo.UpdateAndInsertHuaiRenDrugServerRecordRequestVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(value="huairen")
@RequestMapping(value={"/huairen"})
@RestController
public class HuaiRenController {
    private static final Logger log = LoggerFactory.getLogger(HuaiRenController.class);
    @Autowired
    HuaiRenGetNumService huaiRenGetNumService;
    @Autowired
    private HuaiRenDrugServerApiService huaiRenDrugServerApiService;
    @Autowired
    private AdvertisementSpaceServiceFeign advertisementSpaceServiceFeign;
    @Autowired
    private OutOfConnectServiceFeign outOfConnectServiceFeign;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    private static final Logger logger = LoggerFactory.getLogger(HuaiRenController.class);

    @PostMapping(value={"/getStoreNum"})
    @ResponseBody
    ResponseData<Integer> getStoreNum(HuaiRenRequestVO requestVO, HttpServletRequest request) {
        logger.info("HuaiRenController getStoreNum param:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        return this.huaiRenGetNumService.getStorageNum(requestVO);
    }

    @PostMapping(value={"/getIntegralExchange"})
    ResponseData<HuaiRenIntegralExchangeShowVO> getIntegralExchange(String memberCode, HttpServletRequest request) {
        logger.info("HuaiRenController getIntegralExchange param:{}", (Object)memberCode);
        String sysCompanyIdStr = request.getHeader("sysCompanyId");
        String sysBrandIdStr = request.getHeader("sysBrandId");
        return this.huaiRenGetNumService.getIntegralExchange(memberCode, sysCompanyIdStr, sysBrandIdStr);
    }

    @PostMapping(value={"/integralExchange"})
    @ResponseBody
    ResponseData integralExchange(@RequestBody HuaiRenIntegralExchangeVO vo, HttpServletRequest request) {
        logger.info("HuaiRenController integralExchange param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.huaiRenGetNumService.integralExchange(vo);
    }

    @PostMapping(value={"/getHuaiRenDrugServerRecord"})
    public ResponseData getHuaiRenDrugServerRecord(@RequestBody GetHuaiRenDrugServerRecordListRequestVO requestVO) {
        logger.info("HuaiRenController#getHuaiRenDrugServerRecord#requestVO:{}", (Object)JSON.toJSONString((Object)requestVO));
        if (StringUtils.isEmpty((Object)requestVO.getMemberCode())) {
            return ResponseUtils.getFailedData((String)"\u4f1a\u5458\u7f16\u53f7\u4e3a\u7a7a");
        }
        return this.huaiRenDrugServerApiService.getDrugServerRecordList(requestVO);
    }

    @PostMapping(value={"/insertDrugServerRecord"})
    public ResponseData insertDrugServerRecord(@RequestBody UpdateAndInsertHuaiRenDrugServerRecordRequestVO requestVO) {
        logger.info("HuaiRenController#insertDrugServerRecord#requestVO:{}", (Object)requestVO);
        return this.huaiRenDrugServerApiService.insertDrugServerRecord(requestVO);
    }

    @GetMapping(value={"/getDrugServerRecordById"})
    public ResponseData getDrugServerRecordById(@RequestParam(value="mbrDrugReserveId") Long mbrDrugReserveId) {
        logger.info("HuaiRenController#getDrugServerRecordById#mbrDrugReserveId:{}", (Object)mbrDrugReserveId);
        return this.huaiRenDrugServerApiService.getDrugServerRecordById(mbrDrugReserveId);
    }

    @PostMapping(value={"/getAdvertisementSpace"})
    public ResponseData<AdvertisementSpaceResponseVO> getAdvertisementSpace(HttpServletRequest request) {
        logger.info("HuaiRenController getAdvertisementSpace start");
        String sysCompanyIdStr = request.getHeader("sysCompanyId");
        String sysBrandIdStr = request.getHeader("sysBrandId");
        logger.info("getAdvertisementSpace sysCompanyIdStr:{},sysBrandIdStr:{}", (Object)sysCompanyIdStr, (Object)sysBrandIdStr);
        AdvertisementSpaceRequestVO vo = new AdvertisementSpaceRequestVO();
        vo.setSysCompanyId(Long.valueOf(Long.parseLong(sysCompanyIdStr)));
        vo.setSysBrandId(Long.valueOf(Long.parseLong(sysBrandIdStr)));
        return this.advertisementSpaceServiceFeign.getAdvertisementSpace(vo);
    }

    @RequestMapping(value={"getHealth"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseData<HuairenHealthResVo> getHealth(@RequestParam(value="pageNum", defaultValue="1") String pageNum, @RequestParam(value="checkType") String checkType, @RequestParam(value="pageSize", defaultValue="10") String pageSize, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isEmpty((Object)checkType)) {
            responseData.setMessage("\u5165\u53c2checkType\u4e0d\u80fd\u4e3a\u7a7a");
            responseData.setCode(100);
            return responseData;
        }
        if (StringUtils.isEmpty((Object)request.getHeader("authorizationSign"))) {
            responseData.setMessage("\u975e\u6cd5\u8bf7\u6c42");
            responseData.setCode(-100);
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("bizvaneSessionId\u6ca1\u6709");
            responseData.setCode(100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel model = (MemberInfoModel)singleMemberModel.getData();
        if (model == null || StringUtils.isEmpty((Object)model.getErpId())) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        HuaiRenGetHealthRequestVO req = new HuaiRenGetHealthRequestVO();
        req.setCheckType(checkType);
        req.setInsiderid(model.getErpId());
        req.setStartRecord(pageNum);
        req.setBrandId(model.getBrandId());
        req.setQueryNum(pageSize);
        HuairenHealthResVo vo = new HuairenHealthResVo();
        try {
            Result health = this.outOfConnectServiceFeign.getHealth(req);
            log.info("\u5065\u5eb7\u6863\u6848\u8fd4\u53c2:{}", (Object)(health == null ? "\u5565\u90fd\u6ca1\u6709\u554a" : JSON.toJSONString((Object)health)));
            if (health.getCode() == null) {
                responseData.setCode(Constant.NEGATIVE_HUNDRED.intValue());
                responseData.setMessage("\u8bf7\u6c42\u8fde\u63a5\u5668\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                return responseData;
            }
            if (Constant.ZERO.equals(health.getCode())) {
                ArrayList list;
                HuaiRenGetHealthResponseVO data = (HuaiRenGetHealthResponseVO)health.getData();
                List list2 = "1".equals(checkType) ? data.getUricAcidContent() : (list = "2".equals(checkType) ? data.getBoolSugarContent() : data.getBloodPressureContent());
                if (CollectionUtils.isEmpty((Collection)list)) {
                    list = new ArrayList();
                }
                vo.setTotalNum(data.getTotalNum());
                vo.setResult(JSON.toJSONString(list));
                responseData.setData((Object)vo);
                responseData.setCode(0);
                responseData.setMessage("success");
            } else {
                responseData.setCode(Constant.NEGATIVE_HUNDRED.intValue());
                responseData.setMessage("\u8bf7\u6c42\u8fde\u63a5\u5668\u670d\u52a1\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            log.error("\u8fde\u63a5\u5668\u5185\u90e8\u670d\u52a1\u5f02\u5e38: msg:{} e:{}", (Object)e.getMessage(), (Object)e);
            responseData.setCode(Constant.NEGATIVE_HUNDRED.intValue());
            responseData.setMessage("\u8fde\u63a5\u5668\u5185\u90e8\u670d\u52a1\u5f02\u5e38");
        }
        return responseData;
    }

    public static void main(String[] args) {
        ResponseData responseData = new ResponseData();
        List list = new ArrayList();
        HuairenHealthResVo vo = new HuairenHealthResVo();
        String checkType = "1";
        String str = "{\"code\":0,\"data\":{\"totalNum\":12,\"uricAcidContent\":[{\"codenoUa\":\"13472435946\",\"detectionResultUa\":\"\u504f\u9ad8\",\"detectionTimeUa\":\"2021-01-06 08:17\",\"idUa\":\"19298618\",\"insideridUa\":\"4895782\",\"offlineUpdateDateUa\":\"2021-01-06 08:17\",\"ua\":\"631 umol/L\",\"uaadjUa\":\"(89-360)\"}]},\"message\":\"\u64cd\u4f5c\u6210\u529f\uff01\",\"tData\":{\"$ref\":\"$.data\"}}";
        Result health = (Result)JSON.parseObject((String)str, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (health.getCode() == null) {
            responseData.setCode(Constant.NEGATIVE_HUNDRED.intValue());
            responseData.setMessage("\u8bf7\u6c42\u8fde\u63a5\u5668\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (Constant.ZERO.equals(health.getCode())) {
            HuaiRenGetHealthResponseVO data = (HuaiRenGetHealthResponseVO)health.getData();
            List list2 = "1".equals(checkType) ? data.getUricAcidContent() : (list = "2".equals(checkType) ? data.getBoolSugarContent() : data.getBloodPressureContent());
            if (CollectionUtils.isEmpty(list)) {
                list = new ArrayList();
            }
            vo.setTotalNum(data.getTotalNum());
            vo.setResult(JSON.toJSONString(list));
            responseData.setData((Object)vo);
            responseData.setCode(0);
            responseData.setMessage("success");
        } else {
            responseData.setCode(Constant.NEGATIVE_HUNDRED.intValue());
            responseData.setMessage("\u8bf7\u6c42\u8fde\u63a5\u5668\u670d\u52a1\u5f02\u5e38");
        }
    }
}

