/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.interfaces.MemberInvitedService;
import com.bizvane.appletservice.models.bo.AppletBrandFunctionBo;
import com.bizvane.appletservice.models.bo.AppletMbrQuestionnaireTemplateBo;
import com.bizvane.appletservice.models.bo.AppletTaskWXBO;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.appletservice.models.vo.vg.VGSubscribeMsgAuthResponseVo;
import com.bizvane.appletservice.models.vo.vg.VgQuestionnaireGetVo;
import com.bizvane.appletserviceimpl.impl.vg.VGCommonService;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.customized.facade.interfaces.EvaluationQuestionnaireFeign;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireOrderDetailPO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireOrderPO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireTemplatePO;
import com.bizvane.customized.facade.models.vo.CusUrMbrQuestionnaireTemplateVO;
import com.bizvane.customized.facade.models.vo.EvaluationSaveTempRequestVO;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.messagefacade.enums.vg.WechatSUbscribeMenuEnum;
import com.bizvane.mktcenterservice.models.bo.TaskAwardBO;
import com.bizvane.mktcenterservice.models.bo.TaskQuestionnairePrepareDoBO;
import com.bizvane.mktcenterservice.models.bo.TaskQuestionnaireRewardBO;
import com.bizvane.mktcenterservice.models.bo.TaskWXBO;
import com.bizvane.mktcenterservice.models.bo.TaskWXDetailBO;
import com.bizvane.mktcenterservice.models.vo.MktTaskMbrDefVO;
import com.bizvane.mktcenterservice.models.vo.TaskForWXVO;
import com.bizvane.mktcenterservice.models.vo.TaskVO;
import com.bizvane.mktcenterservice.rpc.MktTaskMbrDefRpc;
import com.bizvane.mktcenterservice.rpc.TaskQuestionnaireServiceRpc;
import com.bizvane.mktcenterservice.rpc.TaskServiceForWXRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberTask"})
public class MemberTaskController {
    @Autowired
    private TaskServiceForWXRpc taskServiceForWxRpc;
    @Autowired
    private MktTaskMbrDefRpc mktTaskMbrDefRpc;
    @Autowired
    private TaskQuestionnaireServiceRpc taskQuestionnaireServiceRpc;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MemberInvitedService memberInvitedService;
    @Autowired
    private EvaluationQuestionnaireFeign evaluationQuestionnaireFeign;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private LoginService loginService;
    @Autowired
    private VGCommonService vgCommonService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/getMemberTask"}, method={RequestMethod.POST})
    public ResponseData getMemberTask(TaskForWXVO taskForWXvo, HttpServletRequest request) {
        logger.info("\u4f1a\u5458\u4efb\u52a1\u5217\u8868\u5165\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)taskForWXvo));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null || "".equals(memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        taskForWXvo.setGroupMemberCode(memberCode);
        taskForWXvo.setMemberCode(memberCode);
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setGroupMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        if (singleMemberModel.getCode() != SysResponseEnum.SUCCESS.getCode() || singleMemberModel.getData() == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        MemberInfoModel memberInfo = (MemberInfoModel)singleMemberModel.getData();
        ResponseData completeTask = this.taskServiceForWxRpc.getCompleteTaskVg(taskForWXvo);
        if (completeTask == null || completeTask.getData() == null || CollectionUtils.isEmpty((Collection)((PageInfo)completeTask.getData()).getList())) {
            PageInfo wxboPageInfo = new PageInfo();
            responseData.setData((Object)wxboPageInfo);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        ArrayList<AppletTaskWXBO> infos = new ArrayList<AppletTaskWXBO>();
        for (TaskWXBO taskWXbo : ((PageInfo)completeTask.getData()).getList()) {
            ResponseData card;
            AppletTaskWXBO appletTaskWXBo = new AppletTaskWXBO();
            BeanUtils.copyProperties((Object)taskWXbo, (Object)appletTaskWXBo);
            VGSubscribeMsgAuthResponseVo vgSubscribeMsgAuthResponseVo = this.vgCommonService.queryTaskDetailBrandWechatAppletSubscribeDataRedis(taskWXbo.getSysBrandId(), openId, WechatSUbscribeMenuEnum.FIELD_20, taskWXbo.getTaskCode());
            appletTaskWXBo.setVgSubscribeMsgAuthResponseVo(vgSubscribeMsgAuthResponseVo);
            if (taskWXbo.getTaskType() == 1) {
                appletTaskWXBo.setRemaks(Integer.valueOf(0));
                card = this.memberInvitedService.invitedOpenCard(appletTaskWXBo.getTaskType(), appletTaskWXBo.getTaskId(), memberCode, taskForWXvo.getBrandId(), bizvaneSessionId);
                appletTaskWXBo.setAppletBrandFunctionBo((AppletBrandFunctionBo)card.getData());
            }
            if (taskWXbo.getTaskType() == 2) {
                appletTaskWXBo.setRemaks(Integer.valueOf(1));
                card = this.memberInvitedService.invitedOpenCard(appletTaskWXBo.getTaskType(), appletTaskWXBo.getTaskId(), memberCode, taskForWXvo.getBrandId(), bizvaneSessionId);
                appletTaskWXBo.setAppletBrandFunctionBo((AppletBrandFunctionBo)card.getData());
            }
            if (taskWXbo.getTaskType() == 3) {
                appletTaskWXBo.setRemaks(Integer.valueOf(1));
                card = this.memberInvitedService.invitedOpenCard(appletTaskWXBo.getTaskType(), appletTaskWXBo.getTaskId(), memberCode, taskForWXvo.getBrandId(), bizvaneSessionId);
                appletTaskWXBo.setAppletBrandFunctionBo((AppletBrandFunctionBo)card.getData());
            }
            if (taskWXbo.getTaskType() == 4) {
                appletTaskWXBo.setRemaks(Integer.valueOf(1));
                card = this.memberInvitedService.invitedOpenCard(appletTaskWXBo.getTaskType(), appletTaskWXBo.getTaskId(), memberCode, taskForWXvo.getBrandId(), bizvaneSessionId);
                appletTaskWXBo.setAppletBrandFunctionBo((AppletBrandFunctionBo)card.getData());
            }
            if (taskWXbo.getTaskType() == 5) {
                appletTaskWXBo.setRemaks(Integer.valueOf(1));
                appletTaskWXBo.setTaskType(Integer.valueOf(4));
                card = this.memberInvitedService.invitedOpenCard(appletTaskWXBo.getTaskType(), appletTaskWXBo.getTaskId(), memberCode, taskForWXvo.getBrandId(), bizvaneSessionId);
                appletTaskWXBo.setAppletBrandFunctionBo((AppletBrandFunctionBo)card.getData());
            }
            if (taskWXbo.getTaskType() == 6) {
                CusUrMbrQuestionnaireTemplatePO templatePo;
                appletTaskWXBo.setRemaks(Integer.valueOf(1));
                String templateCode = taskWXbo.getTemplateCode();
                appletTaskWXBo.setTemplateCode(templateCode);
                if ("0000000000".equals(templateCode) && StringUtils.isNotEmpty((CharSequence)taskWXbo.getMemberTouristUrl())) {
                    appletTaskWXBo.setQuestionnaireName(taskWXbo.getMemberTouristName());
                    String url = String.format(taskWXbo.getMemberTouristUrl(), StringUtils.isEmpty((CharSequence)memberInfo.getPhone()) ? "" : memberInfo.getPhone() + "" + System.currentTimeMillis(), this.getBrandClub(taskWXbo.getSysBrandId()), taskWXbo.getTaskId(), memberInfo.getCardNo() + System.currentTimeMillis());
                    appletTaskWXBo.setQuestionnaireUrl(url);
                }
                CusUrMbrQuestionnaireTemplateVO templateVO = new CusUrMbrQuestionnaireTemplateVO();
                templateVO.setSysBrandId(taskWXbo.getSysBrandId());
                templateVO.setTemplateCode(templateCode);
                if (taskWXbo.getRewarded() == 1) {
                    templateVO.setMktTaskId(taskWXbo.getTaskId());
                    templateVO.setMemberCode(taskWXbo.getMemberCode());
                    templatePo = (CusUrMbrQuestionnaireOrderPO)this.evaluationQuestionnaireFeign.queryAnswerOrderByTaskId(templateVO).getData();
                    appletTaskWXBo.setTemplateJson(templatePo == null ? "" : templatePo.getTemplateJsonOrder());
                } else {
                    templatePo = (CusUrMbrQuestionnaireTemplatePO)this.evaluationQuestionnaireFeign.queryQuestionTemplate(templateVO).getData();
                    appletTaskWXBo.setTemplateJson(templatePo == null ? "" : templatePo.getTemplateJson());
                }
            }
            if (taskWXbo.getTaskType() == 8) {
                appletTaskWXBo.setRemaks(Integer.valueOf(1));
            }
            infos.add(appletTaskWXBo);
        }
        if (infos != null) {
            Collections.sort(infos, (o1, o2) -> {
                long time0 = o1.getStartTime() == null ? 0L : o1.getStartTime().getTime();
                long time1 = o2.getStartTime() == null ? 0L : o2.getStartTime().getTime();
                long intValue1 = time1 - time0;
                int value = 0;
                if (intValue1 > 0L) {
                    value = 1;
                }
                if (intValue1 < 0L) {
                    value = -1;
                }
                if (intValue1 == 0L) {
                    value = 0;
                }
                logger.info("value====" + value);
                return value;
            });
            ArrayList list = new ArrayList(infos);
            Collections.sort(list, (o1, o2) -> o1.getRemaks() - o2.getRemaks());
            PageInfo wxboPageInfo = new PageInfo();
            this.copyPageInfo((PageInfo)completeTask.getData(), wxboPageInfo);
            wxboPageInfo.setList(list);
            logger.info("\u4f1a\u5458\u4efb\u52a1\u5217\u8868\u51fa\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)wxboPageInfo));
            responseData.setData((Object)wxboPageInfo);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        infos = null;
        PageInfo wxboPageInfo = new PageInfo(infos);
        logger.info("\u4f1a\u5458\u4efb\u52a1\u5217\u8868\u51fa\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)wxboPageInfo));
        responseData.setData((Object)wxboPageInfo);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    private void copyPageInfo(PageInfo<TaskWXBO> sourcePageInfo, PageInfo<AppletTaskWXBO> targePageInfo) {
        targePageInfo.setPageNum(sourcePageInfo.getPageNum());
        targePageInfo.setPageSize(sourcePageInfo.getPageSize());
        targePageInfo.setSize(sourcePageInfo.getSize());
        targePageInfo.setStartRow(sourcePageInfo.getStartRow());
        targePageInfo.setEndRow(sourcePageInfo.getEndRow());
        targePageInfo.setPages(sourcePageInfo.getPages());
        targePageInfo.setPrePage(sourcePageInfo.getPrePage());
        targePageInfo.setNextPage(sourcePageInfo.getNextPage());
        targePageInfo.setIsFirstPage(sourcePageInfo.isIsFirstPage());
        targePageInfo.setIsLastPage(sourcePageInfo.isIsLastPage());
        targePageInfo.setHasPreviousPage(sourcePageInfo.isHasPreviousPage());
        targePageInfo.setHasNextPage(sourcePageInfo.isHasNextPage());
        targePageInfo.setNavigatepageNums(sourcePageInfo.getNavigatepageNums());
        targePageInfo.setNavigateFirstPage(sourcePageInfo.getNavigateFirstPage());
        targePageInfo.setNavigateLastPage(sourcePageInfo.getNavigateLastPage());
        targePageInfo.setTotal(sourcePageInfo.getTotal());
    }

    @RequestMapping(value={"/taskId"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData getTaskWXDetail(Long taskId, HttpServletRequest request) {
        ResponseData taskWXDetailBORes;
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = "";
        if (bizvaneSessionId != null) {
            memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        }
        if ((taskWXDetailBORes = this.taskServiceForWxRpc.getTaskWXDetail(taskId)).getCode() != SysResponseEnum.SUCCESS.getCode()) {
            return new ResponseData(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode(), "\u5f88\u62b1\u6b49\uff0c\u65e0\u6548\u8bf7\u6c42\u6570\u636e");
        }
        TaskWXDetailBO taskWXDetailBO = (TaskWXDetailBO)taskWXDetailBORes.getData();
        if ("0000000000".equals(taskWXDetailBO.getTemplateCode())) {
            if (StringUtils.isNotEmpty((CharSequence)memberCode)) {
                MemberInfoModel memberInfoModel = new MemberInfoModel();
                memberInfoModel.setGroupMemberCode(memberCode);
                ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
                if (singleMemberModel.getCode() != SysResponseEnum.SUCCESS.getCode() || singleMemberModel.getData() == null) {
                    return new ResponseData(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode(), "\u5f88\u62b1\u6b49\uff0c\u65e0\u6548\u8bf7\u6c42\u6570\u636e");
                }
                MemberInfoModel memberInfo = (MemberInfoModel)singleMemberModel.getData();
                String url = String.format(taskWXDetailBO.getMemberTouristUrl(), StringUtils.isEmpty((CharSequence)memberInfo.getPhone()) ? "" : memberInfo.getPhone() + "" + System.currentTimeMillis(), this.getBrandClub(taskWXDetailBO.getSysBrandId()), taskWXDetailBO.getMktTaskId(), memberInfo.getCardNo() + System.currentTimeMillis());
                taskWXDetailBO.setMemberTouristUrl(url);
                VgQuestionnaireGetVo vgQuestionnaireGetVo = new VgQuestionnaireGetVo();
                vgQuestionnaireGetVo.setMktTaskId(taskId);
                ResponseData checkData = this.checkThirdQuestionReturn(vgQuestionnaireGetVo, memberCode);
                if (checkData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
                    return checkData;
                }
            } else {
                String url = String.format(taskWXDetailBO.getMemberTouristUrl(), "11111111111" + System.currentTimeMillis(), this.getBrandClub(taskWXDetailBO.getSysBrandId()), taskWXDetailBO.getMktTaskId(), "JH000000000000" + System.currentTimeMillis());
                taskWXDetailBO.setMemberTouristUrl(url);
            }
        }
        return taskWXDetailBORes;
    }

    @RequestMapping(value={"/getTaskOrderDetail"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData getTaskOrderDetail(Long taskId, HttpServletRequest request) {
        ResponseData taskWXDetailBORes;
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = "";
        if (bizvaneSessionId != null) {
            memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        }
        if ((taskWXDetailBORes = this.taskServiceForWxRpc.getTaskOrderDetail(taskId, memberCode)).getCode() != SysResponseEnum.SUCCESS.getCode()) {
            return new ResponseData(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode(), "\u5f88\u62b1\u6b49\uff0c\u65e0\u6548\u8bf7\u6c42\u6570\u636e");
        }
        return taskWXDetailBORes;
    }

    @PostMapping(value={"/addMemberQuestionnaire"})
    public ResponseData addMemberQuestionnaire(EvaluationSaveTempRequestVO evo, HttpServletRequest request) {
        logger.info("MemberTaskController addMemberQuestionnaire params:{}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)evo));
        MemberResoucreBO loginResourceBO = this.loginService.getLoginResourceBO(request);
        logger.info("MemberTaskController addMemberQuestionnaire \u767b\u5f55\u8005\u4fe1\u606f:{}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)loginResourceBO));
        if (evo.getSysBrandId() == null) {
            return new ResponseData(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode(), "\u5f88\u62b1\u6b49\uff0c\u54c1\u724cid\u672a\u4f20");
        }
        evo.setSysCompanyId(loginResourceBO.getSysCompanyId());
        evo.setAnswersOpenId(loginResourceBO.getOpenId());
        evo.setMemberCode(null);
        if (StringUtils.isNotBlank((CharSequence)loginResourceBO.getMemberCode())) {
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setGroupMemberCode(loginResourceBO.getMemberCode());
            memberInfoModel.setBrandId(evo.getSysBrandId());
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            logger.info("\u4fdd\u5b58\u95ee\u5377 \u67e5\u8be2\u4ff1\u4e50\u90e8\u4f1a\u5458\u4fe1\u606f={}", (Object)JSON.toJSONString((Object)singleMemberModel));
            MemberInfoModel clubMember = (MemberInfoModel)singleMemberModel.getData();
            if (clubMember != null) {
                evo.setMemberCode(clubMember.getMemberCode());
                evo.setCardNo(clubMember.getCardNo());
                evo.setMemberName(clubMember.getName());
                evo.setMemberPhone(clubMember.getPhone());
                if (clubMember.getServiceStoreId() != null) {
                    ResponseData storeVoResponseData = this.storeServiceRpc.getSysStoreById(clubMember.getServiceStoreId());
                    evo.setStoreName(storeVoResponseData != null & storeVoResponseData.getData() != null ? ((SysStoreVo)storeVoResponseData.getData()).getStoreName() : "");
                } else {
                    evo.setStoreName("");
                }
            }
        }
        String questionnaireList = evo.getTemplateJsonOrder();
        List questionList = JSONArray.parseArray((String)questionnaireList, CusUrMbrQuestionnaireOrderDetailPO.class);
        JSONObject questionJson = new JSONObject();
        questionJson.put("templateList", (Object)questionList);
        evo.setTemplateJsonOrder(JSON.toJSONString((Object)questionJson));
        logger.info("\u89e3\u6790\u7684questionList={}", (Object)JSON.toJSONString((Object)questionList));
        evo.setTemplateList(questionList);
        evo.setAnswerPeopleType(Integer.valueOf(StringUtils.isNotBlank((CharSequence)evo.getMemberCode()) ? 1 : 2));
        return this.evaluationQuestionnaireFeign.saveQuestionnaireTask(evo);
    }

    @PostMapping(value={"/getTaskRewardDetail"})
    public ResponseData<TaskQuestionnaireRewardBO> getTaskRewardDetail(Long mktTaskId) {
        logger.info("MemberTaskController getTaskRewardDetail param:{}", (Object)mktTaskId);
        return this.taskQuestionnaireServiceRpc.getTaskRewardDetail(mktTaskId);
    }

    @PostMapping(value={"/getTaskMbrDef"})
    public ResponseData getTaskMbrDef(HttpServletRequest request) {
        String sysCompanyId = request.getHeader("sysCompanyId");
        String brandId = request.getHeader("sysBrandId");
        if (StringUtils.isBlank((CharSequence)sysCompanyId) || StringUtils.isBlank((CharSequence)brandId)) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u83b7\u53d6\u4f1a\u5458\u8bf7\u6c42\u53c2\u6570\u5931\u8d25");
        }
        MktTaskMbrDefVO mktTaskMbrDefVO = new MktTaskMbrDefVO();
        mktTaskMbrDefVO.setSysCompanyId(Long.valueOf(sysCompanyId));
        mktTaskMbrDefVO.setSysBrandId(Long.valueOf(brandId));
        return this.mktTaskMbrDefRpc.getEntityByVo(mktTaskMbrDefVO);
    }

    @RequestMapping(value={"/getQuestionnaireTemplate"}, method={RequestMethod.GET})
    public ResponseData<AppletMbrQuestionnaireTemplateBo> getQuestionnaireTemplate(HttpServletRequest request, VgQuestionnaireGetVo vgQuestionnaireGetVo) {
        MemberResoucreBO loginResourceBO = this.loginService.getLoginResourceBO(request);
        logger.info("getQuestionnaireTemplate method \u767b\u9646\u8005\u4fe1\u606f:{}", (Object)JacksonUtil.bean2Json((Object)loginResourceBO));
        if (vgQuestionnaireGetVo == null) {
            return new ResponseData(-100, "\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        if (StringUtils.isBlank((CharSequence)vgQuestionnaireGetVo.getTemplateCode()) && vgQuestionnaireGetVo.getMktTaskId() == null) {
            return new ResponseData(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode(), "\u5f88\u62b1\u6b49\uff0c\u65e0\u6548\u8bf7\u6c42\u6570\u636e");
        }
        if (vgQuestionnaireGetVo.getMktTaskId() != null) {
            TaskVO taskVO = new TaskVO();
            taskVO.setMktTaskId(vgQuestionnaireGetVo.getMktTaskId());
            ResponseData taskVOResponseData = this.taskQuestionnaireServiceRpc.getTaskByTaskId(taskVO);
            if (taskVOResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || taskVOResponseData.getData() == null) {
                return new ResponseData(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode(), "\u5f88\u62b1\u6b49\uff0c\u65e0\u6548\u8bf7\u6c42\u6570\u636e");
            }
            TaskVO resTask = (TaskVO)taskVOResponseData.getData();
            if ("0000000000".equals(resTask.getTemplateCode()) && StringUtils.isNotEmpty((CharSequence)resTask.getMemberTouristUrl())) {
                if (StringUtils.isNotEmpty((CharSequence)vgQuestionnaireGetVo.getMemberCode()) && !"null".equals(vgQuestionnaireGetVo.getMemberCode()) && !"undefined".equals(vgQuestionnaireGetVo.getMemberCode())) {
                    MemberInfoModel memberInfoModel = new MemberInfoModel();
                    memberInfoModel.setSysCompanyId(Long.valueOf(247L));
                    memberInfoModel.setMemberCode(vgQuestionnaireGetVo.getMemberCode());
                    ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
                    if (singleMemberModel.getCode() != SysResponseEnum.SUCCESS.getCode() || singleMemberModel.getData() == null) {
                        return new ResponseData(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode(), "\u5f88\u62b1\u6b49\uff0c\u65e0\u6548\u8bf7\u6c42\u6570\u636e");
                    }
                    MemberInfoModel memberInfo = (MemberInfoModel)singleMemberModel.getData();
                    memberInfoModel = new MemberInfoModel();
                    memberInfoModel.setSysCompanyId(Long.valueOf(247L));
                    memberInfoModel.setBrandId(resTask.getSysBrandId());
                    memberInfoModel.setCardNo(memberInfo.getCardNo());
                    singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
                    if (singleMemberModel.getCode() != SysResponseEnum.SUCCESS.getCode() || singleMemberModel.getData() == null) {
                        return new ResponseData(-1, "\u5f88\u62b1\u6b49\uff0c\u60a8\u4e0d\u5728\u672c\u6b21\u6d3b\u52a8\u8303\u56f4\u5185\uff0c\u66f4\u591a\u7cbe\u5f69\u6d3b\u52a8\uff0c\u671f\u5f85\u4f60\u7684\u53c2\u4e0e");
                    }
                    memberInfo = (MemberInfoModel)singleMemberModel.getData();
                    AppletMbrQuestionnaireTemplateBo appletMbrQuestionnaireTemplateBo = new AppletMbrQuestionnaireTemplateBo();
                    appletMbrQuestionnaireTemplateBo.setSysBrandId(resTask.getSysBrandId());
                    appletMbrQuestionnaireTemplateBo.setSysCompanyId(resTask.getSysCompanyId());
                    appletMbrQuestionnaireTemplateBo.setRewarded(Integer.valueOf(0));
                    appletMbrQuestionnaireTemplateBo.setTemplateCode(resTask.getTemplateCode());
                    appletMbrQuestionnaireTemplateBo.setTemplateName(resTask.getTemplateName());
                    appletMbrQuestionnaireTemplateBo.setMemberTouristName(resTask.getMemberTouristName());
                    String url = String.format(resTask.getMemberTouristUrl(), StringUtils.isEmpty((CharSequence)memberInfo.getPhone()) ? "" : memberInfo.getPhone() + "" + System.currentTimeMillis(), this.getBrandClub(resTask.getSysBrandId()), resTask.getMktTaskId(), memberInfo.getCardNo() + System.currentTimeMillis());
                    appletMbrQuestionnaireTemplateBo.setMemberTouristUrl(url);
                    ResponseData checkData = this.checkThirdQuestionReturn(vgQuestionnaireGetVo, memberInfo.getMemberCode());
                    if (checkData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
                        return checkData;
                    }
                    return new ResponseData((Object)appletMbrQuestionnaireTemplateBo);
                }
                AppletMbrQuestionnaireTemplateBo appletMbrQuestionnaireTemplateBo = new AppletMbrQuestionnaireTemplateBo();
                appletMbrQuestionnaireTemplateBo.setSysBrandId(resTask.getSysBrandId());
                appletMbrQuestionnaireTemplateBo.setSysCompanyId(resTask.getSysCompanyId());
                appletMbrQuestionnaireTemplateBo.setRewarded(Integer.valueOf(0));
                appletMbrQuestionnaireTemplateBo.setTemplateCode(resTask.getTemplateCode());
                appletMbrQuestionnaireTemplateBo.setTemplateName(resTask.getTemplateName());
                appletMbrQuestionnaireTemplateBo.setMemberTouristName(resTask.getMemberTouristName());
                String url = String.format(resTask.getMemberTouristUrl(), "11111111111" + System.currentTimeMillis(), this.getBrandClub(resTask.getSysBrandId()), resTask.getMktTaskId(), "JH000000000000" + System.currentTimeMillis());
                appletMbrQuestionnaireTemplateBo.setMemberTouristUrl(url);
                return new ResponseData((Object)appletMbrQuestionnaireTemplateBo);
            }
            return this.getAppletMbrTaskQuestionnaireTemplateBoRes(vgQuestionnaireGetVo, loginResourceBO);
        }
        CusUrMbrQuestionnaireTemplateVO templateVO = new CusUrMbrQuestionnaireTemplateVO();
        templateVO.setSysCompanyId(loginResourceBO.getSysCompanyId());
        templateVO.setTemplateCode(vgQuestionnaireGetVo.getTemplateCode());
        CusUrMbrQuestionnaireTemplatePO mbrQuestionnaireTemplatePO = (CusUrMbrQuestionnaireTemplatePO)this.evaluationQuestionnaireFeign.queryQuestionTemplate(templateVO).getData();
        if (mbrQuestionnaireTemplatePO == null) {
            return new ResponseData(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode(), "\u5f88\u62b1\u6b49\uff0c\u67e5\u8be2\u4e0d\u5230\u8be5\u4efb\u52a1\u95ee\u5377\u8c03\u67e5\u5185\u5bb9\uff0c\u66f4\u591a\u7cbe\u5f69\u6d3b\u52a8\uff0c\u671f\u5f85\u4f60\u7684\u53c2\u4e0e");
        }
        AppletMbrQuestionnaireTemplateBo appletMbrQuestionnaireTemplateBo = this.getAppletMbrQuestionnaireTemplateBo(mbrQuestionnaireTemplatePO);
        return new ResponseData((Object)appletMbrQuestionnaireTemplateBo);
    }

    private String getBrandClub(Long brandId) {
        ResponseData sysBrandPoResponseData = this.brandServiceRpc.getBrandByID(brandId);
        if (sysBrandPoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || sysBrandPoResponseData.getData() == null) {
            return "";
        }
        SysBrandPo sysBrandPo = (SysBrandPo)sysBrandPoResponseData.getData();
        return sysBrandPo.getBrandCode();
    }

    private ResponseData<AppletMbrQuestionnaireTemplateBo> getAppletMbrTaskQuestionnaireTemplateBoRes(VgQuestionnaireGetVo vgQuestionnaireGetVo, MemberResoucreBO loginResourceBO) {
        if (Integer.valueOf(1).equals(vgQuestionnaireGetVo.getRewarded()) && vgQuestionnaireGetVo.getSysBrandId() != null) {
            MemberInfoModel memberInfoModelSearch = new MemberInfoModel();
            memberInfoModelSearch.setGroupMemberCode(loginResourceBO.getMemberCode());
            memberInfoModelSearch.setBrandId(vgQuestionnaireGetVo.getSysBrandId());
            ResponseData singleMemberModelRes = this.memberInfoApiService.getSingleMemberModel(memberInfoModelSearch);
            if (singleMemberModelRes.getData() == null) {
                logger.info("\u67e5\u8be2\u4ff1\u4e50\u90e8\u4f1a\u5458\u4fe1\u606f\u4e3a\u7a7a={}", (Object)JacksonUtil.bean2Json((Object)singleMemberModelRes));
                return new ResponseData(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode(), "\u5f88\u62b1\u6b49\uff0c\u4ff1\u4e50\u90e8\u4f1a\u5458\u4e0d\u5b58\u5728");
            }
            MemberInfoModel memberInfoModel = (MemberInfoModel)singleMemberModelRes.getData();
            CusUrMbrQuestionnaireTemplateVO templateVO = new CusUrMbrQuestionnaireTemplateVO();
            templateVO.setSysBrandId(memberInfoModel.getBrandId());
            templateVO.setMemberCode(memberInfoModel.getMemberCode());
            templateVO.setMktTaskId(vgQuestionnaireGetVo.getMktTaskId());
            CusUrMbrQuestionnaireOrderPO mbrQuestionnaireOrderPO = (CusUrMbrQuestionnaireOrderPO)this.evaluationQuestionnaireFeign.queryAnswerOrderByTaskId(templateVO).getData();
            if (mbrQuestionnaireOrderPO == null) {
                return new ResponseData(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode(), "\u5f88\u62b1\u6b49\uff0c\u67e5\u8be2\u4e0d\u5230\u8be5\u4efb\u52a1\u95ee\u5377\u8c03\u67e5\u5185\u5bb9\uff0c\u66f4\u591a\u7cbe\u5f69\u6d3b\u52a8\uff0c\u671f\u5f85\u4f60\u7684\u53c2\u4e0e");
            }
            AppletMbrQuestionnaireTemplateBo appletMbrQuestionnaireTemplateBo = this.getAppletMbrQuestionnaireTemplateBo(mbrQuestionnaireOrderPO);
            return new ResponseData((Object)appletMbrQuestionnaireTemplateBo);
        }
        TaskAwardBO taskAwardBO = new TaskAwardBO();
        taskAwardBO.setSysCompanyId(loginResourceBO.getSysCompanyId());
        taskAwardBO.setPropertyCode(loginResourceBO.getMemberCode());
        taskAwardBO.setMktTaskId(vgQuestionnaireGetVo.getMktTaskId());
        ResponseData taskQuestionnairePrepareDoBORes = this.taskQuestionnaireServiceRpc.prepareDoTaskQuestionnaire(taskAwardBO);
        logger.info("taskQuestionnairePrepareDoBORes:{}", (Object)JacksonUtil.bean2Json((Object)taskQuestionnairePrepareDoBORes));
        if (SysResponseEnum.SUCCESS.getCode() != taskQuestionnairePrepareDoBORes.getCode()) {
            return new ResponseData(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode(), taskQuestionnairePrepareDoBORes.getMessage());
        }
        TaskQuestionnairePrepareDoBO questionnairePrepareDoBO = (TaskQuestionnairePrepareDoBO)taskQuestionnairePrepareDoBORes.getData();
        if (questionnairePrepareDoBO == null) {
            return new ResponseData(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode(), "\u5f88\u62b1\u6b49\uff0c\u67e5\u8be2\u4e0d\u5230\u8be5\u4efb\u52a1\uff0c\u66f4\u591a\u7cbe\u5f69\u6d3b\u52a8\uff0c\u671f\u5f85\u4f60\u7684\u53c2\u4e0e");
        }
        if (StringUtils.isBlank((CharSequence)questionnairePrepareDoBO.getTemplateCode())) {
            return new ResponseData(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode(), "\u5f88\u62b1\u6b49\uff0c\u67e5\u8be2\u4e0d\u5230\u8be5\u4efb\u52a1\u95ee\u5377\u8c03\u67e5\u5185\u5bb9\uff0c\u66f4\u591a\u7cbe\u5f69\u6d3b\u52a8\uff0c\u671f\u5f85\u4f60\u7684\u53c2\u4e0e");
        }
        if (questionnairePrepareDoBO.getAllowNonMbr() != null && questionnairePrepareDoBO.getAllowNonMbr().booleanValue() && StringUtils.isBlank((CharSequence)questionnairePrepareDoBO.getTouristTemplateCode())) {
            return new ResponseData(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode(), "\u5f88\u62b1\u6b49\uff0c\u67e5\u8be2\u4e0d\u5230\u8be5\u4efb\u52a1\u95ee\u5377\u8c03\u67e5\u5185\u5bb9\uff0c\u66f4\u591a\u7cbe\u5f69\u6d3b\u52a8\uff0c\u671f\u5f85\u4f60\u7684\u53c2\u4e0e");
        }
        AppletMbrQuestionnaireTemplateBo appletMbrQuestionnaireTemplateBo = this.getAppletMbrQuestionnaireTemplateBo(questionnairePrepareDoBO);
        CusUrMbrQuestionnaireTemplateVO templateVO = new CusUrMbrQuestionnaireTemplateVO();
        templateVO.setSysBrandId(questionnairePrepareDoBO.getSysBrandId());
        templateVO.setMemberCode(questionnairePrepareDoBO.getMemberCode());
        templateVO.setMktTaskId(questionnairePrepareDoBO.getTaskId());
        if (Integer.valueOf(1).equals(questionnairePrepareDoBO.getRewarded())) {
            CusUrMbrQuestionnaireOrderPO mbrQuestionnaireOrderPO = (CusUrMbrQuestionnaireOrderPO)this.evaluationQuestionnaireFeign.queryAnswerOrderByTaskId(templateVO).getData();
            if (mbrQuestionnaireOrderPO == null) {
                return new ResponseData(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode(), "\u5f88\u62b1\u6b49\uff0c\u67e5\u8be2\u4e0d\u5230\u8be5\u4efb\u52a1\u95ee\u5377\u8c03\u67e5\u5185\u5bb9\uff0c\u66f4\u591a\u7cbe\u5f69\u6d3b\u52a8\uff0c\u671f\u5f85\u4f60\u7684\u53c2\u4e0e");
            }
            appletMbrQuestionnaireTemplateBo.setTemplateCode(mbrQuestionnaireOrderPO.getTemplateCode());
            appletMbrQuestionnaireTemplateBo.setTemplateJson(mbrQuestionnaireOrderPO.getTemplateJsonOrder());
            return new ResponseData((Object)appletMbrQuestionnaireTemplateBo);
        }
        if (StringUtils.isNotBlank((CharSequence)questionnairePrepareDoBO.getMemberCode())) {
            templateVO.setTemplateCode(questionnairePrepareDoBO.getTemplateCode());
        } else {
            if (questionnairePrepareDoBO.getAllowNonMbr() == null || !questionnairePrepareDoBO.getAllowNonMbr().booleanValue()) {
                return new ResponseData((Object)appletMbrQuestionnaireTemplateBo);
            }
            if (questionnairePrepareDoBO.getAllowNonMbr() != null && questionnairePrepareDoBO.getAllowNonMbr().booleanValue()) {
                templateVO.setTemplateCode(questionnairePrepareDoBO.getTouristTemplateCode());
            } else {
                return new ResponseData(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode(), "\u5f88\u62b1\u6b49\uff0c\u60a8\u4e0d\u5728\u672c\u6b21\u6d3b\u52a8\u8303\u56f4\u5185\uff0c\u66f4\u591a\u7cbe\u5f69\u6d3b\u52a8\uff0c\u671f\u5f85\u4f60\u7684\u53c2\u4e0e");
            }
        }
        CusUrMbrQuestionnaireTemplatePO mbrQuestionnaireTemplatePO = (CusUrMbrQuestionnaireTemplatePO)this.evaluationQuestionnaireFeign.queryQuestionTemplate(templateVO).getData();
        if (mbrQuestionnaireTemplatePO == null) {
            return new ResponseData(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode(), "\u5f88\u62b1\u6b49\uff0c\u67e5\u8be2\u4e0d\u5230\u8be5\u4efb\u52a1\u95ee\u5377\u8c03\u67e5\u5185\u5bb9\uff0c\u66f4\u591a\u7cbe\u5f69\u6d3b\u52a8\uff0c\u671f\u5f85\u4f60\u7684\u53c2\u4e0e");
        }
        appletMbrQuestionnaireTemplateBo.setTemplateCode(mbrQuestionnaireTemplatePO.getTemplateCode());
        appletMbrQuestionnaireTemplateBo.setTemplateJson(mbrQuestionnaireTemplatePO.getTemplateJson());
        return new ResponseData((Object)appletMbrQuestionnaireTemplateBo);
    }

    private ResponseData checkThirdQuestionReturn(VgQuestionnaireGetVo vgQuestionnaireGetVo, String memberCode) {
        TaskAwardBO taskAwardBO = new TaskAwardBO();
        taskAwardBO.setSysCompanyId(Long.valueOf(247L));
        taskAwardBO.setPropertyCode(memberCode);
        taskAwardBO.setMktTaskId(vgQuestionnaireGetVo.getMktTaskId());
        ResponseData taskQuestionnairePrepareDoBORes = this.taskQuestionnaireServiceRpc.prepareDoTaskQuestionnaire(taskAwardBO);
        logger.info("taskQuestionnairePrepareDoBORes:{}", (Object)JacksonUtil.bean2Json((Object)taskQuestionnairePrepareDoBORes));
        if (SysResponseEnum.SUCCESS.getCode() != taskQuestionnairePrepareDoBORes.getCode()) {
            return new ResponseData(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode(), taskQuestionnairePrepareDoBORes.getMessage());
        }
        return new ResponseData(SysResponseEnum.SUCCESS.getCode(), "");
    }

    private AppletMbrQuestionnaireTemplateBo getAppletMbrQuestionnaireTemplateBo(CusUrMbrQuestionnaireOrderPO mbrQuestionnaireOrderPO) {
        AppletMbrQuestionnaireTemplateBo appletMbrQuestionnaireTemplateBo = new AppletMbrQuestionnaireTemplateBo();
        appletMbrQuestionnaireTemplateBo.setSysBrandId(mbrQuestionnaireOrderPO.getSysBrandId());
        appletMbrQuestionnaireTemplateBo.setSysCompanyId(mbrQuestionnaireOrderPO.getSysCompanyId());
        appletMbrQuestionnaireTemplateBo.setRewarded(Integer.valueOf(1));
        appletMbrQuestionnaireTemplateBo.setMktTaskId(mbrQuestionnaireOrderPO.getMktTaskId());
        appletMbrQuestionnaireTemplateBo.setMemberCode(mbrQuestionnaireOrderPO.getMemberCode());
        appletMbrQuestionnaireTemplateBo.setTemplateCode(mbrQuestionnaireOrderPO.getTemplateCode());
        appletMbrQuestionnaireTemplateBo.setTemplateName(mbrQuestionnaireOrderPO.getTemplateName());
        appletMbrQuestionnaireTemplateBo.setTemplateJson(mbrQuestionnaireOrderPO.getTemplateJsonOrder());
        return appletMbrQuestionnaireTemplateBo;
    }

    private AppletMbrQuestionnaireTemplateBo getAppletMbrQuestionnaireTemplateBo(TaskQuestionnairePrepareDoBO questionnairePrepareDoBO) {
        AppletMbrQuestionnaireTemplateBo appletMbrQuestionnaireTemplateBo = new AppletMbrQuestionnaireTemplateBo();
        appletMbrQuestionnaireTemplateBo.setSysBrandId(questionnairePrepareDoBO.getSysBrandId());
        appletMbrQuestionnaireTemplateBo.setSysCompanyId(questionnairePrepareDoBO.getSysCompanyId());
        appletMbrQuestionnaireTemplateBo.setRewarded(questionnairePrepareDoBO.getRewarded());
        appletMbrQuestionnaireTemplateBo.setMktTaskId(questionnairePrepareDoBO.getTaskId());
        appletMbrQuestionnaireTemplateBo.setTaskName(questionnairePrepareDoBO.getTaskName());
        appletMbrQuestionnaireTemplateBo.setMemberCode(questionnairePrepareDoBO.getMemberCode());
        appletMbrQuestionnaireTemplateBo.setAllowNonMbr(questionnairePrepareDoBO.getAllowNonMbr());
        return appletMbrQuestionnaireTemplateBo;
    }

    private AppletMbrQuestionnaireTemplateBo getAppletMbrQuestionnaireTemplateBo(CusUrMbrQuestionnaireTemplatePO urMbrQuestionnaireTemplatePO) {
        AppletMbrQuestionnaireTemplateBo appletMbrQuestionnaireTemplateBo = new AppletMbrQuestionnaireTemplateBo();
        appletMbrQuestionnaireTemplateBo.setSysBrandId(urMbrQuestionnaireTemplatePO.getSysBrandId());
        appletMbrQuestionnaireTemplateBo.setSysCompanyId(urMbrQuestionnaireTemplatePO.getSysCompanyId());
        appletMbrQuestionnaireTemplateBo.setRewarded(Integer.valueOf(0));
        appletMbrQuestionnaireTemplateBo.setTemplateCode(urMbrQuestionnaireTemplatePO.getTemplateCode());
        appletMbrQuestionnaireTemplateBo.setTemplateName(urMbrQuestionnaireTemplatePO.getTemplateName());
        appletMbrQuestionnaireTemplateBo.setTemplateJson(urMbrQuestionnaireTemplatePO.getTemplateJson());
        return appletMbrQuestionnaireTemplateBo;
    }
}

