/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.models.bo.AppletRefreshtoInterfaceBo;
import com.bizvane.appletservice.models.bo.AppletSysStoreBo;
import com.bizvane.appletservice.models.po.AppletResourcesPO;
import com.bizvane.appletservice.models.po.AppletResourcesPOExample;
import com.bizvane.appletserviceimpl.controllers.MenberCenterActivityController;
import com.bizvane.appletserviceimpl.impl.vg.VGGetAllMemberInfoServiceImpl;
import com.bizvane.appletserviceimpl.mappers.AppletResourcesPOMapper;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.centerstageservice.models.bo.SysStoreBo;
import com.bizvane.centerstageservice.models.dto.SysBojunQueryDTO;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.po.SysStorePrivilegePo;
import com.bizvane.centerstageservice.models.vo.StaffVo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.centerstageservice.rpc.SysBojunDataServiceRpc;
import com.bizvane.couponfacade.interfaces.CouponQueryServiceFeign;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.members.facade.vo.vg.AllCardResponseVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatenterprise.service.common.PageFormUtil;
import com.github.pagehelper.PageInfo;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberStore"})
public class MemberStoreController {
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private StaffServiceRpc staffServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Resource
    private AppletResourcesPOMapper appletResourcesPOMapper;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private MenberCenterActivityController menberCenterActivityController;
    @Autowired
    private CouponQueryServiceFeign couponQueryServiceFeign;
    @Autowired
    private VGGetAllMemberInfoServiceImpl vgGetAllMemberInfoService;
    @Autowired
    private SysBojunDataServiceRpc sysBojunDataServiceRpc;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    DecimalFormat df = new DecimalFormat("###.#");

    @RequestMapping(value={"/getBrandByIdSysStoreList"}, method={RequestMethod.POST})
    public ResponseData getBrandByIdSysStoreList(SysStoreBo bo, HttpServletRequest request) {
        logger.info("\u95e8\u5e97\u5bfc\u822a\u5165\u53c2={}", (Object)JSON.toJSONString((Object)bo));
        ResponseData responseData = new ResponseData();
        responseData.setMessage("\u95e8\u5e97\u5e97\u67e5\u8be2\u5931\u8d25");
        try {
            String bizvaneSessionId = request.getHeader("bizvaneSessionId");
            if (bizvaneSessionId == null) {
                responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
                return responseData;
            }
            String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
            if (memberCode == null) {
                responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                responseData.setCode(-100);
                return responseData;
            }
            if (ObjectUtils.allNotNull((Object[])new Object[]{bo.getSysBrandId()})) {
                List allMemberCardByMemberCode = this.vgGetAllMemberInfoService.getAllMemberCardByMemberCode(memberCode);
                memberCode = allMemberCardByMemberCode.stream().filter(vo -> vo.getBrandId().equals(bo.getSysBrandId())).findFirst().map(AllCardResponseVO::getMemberCode).orElse(memberCode);
            }
            Long storeId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
            bo.setSysStoreId(storeId);
            if (bo.getSysBrandId() == null) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            if (bo.getPageSize() == null || bo.getPageSize() == 0) {
                bo.setPageSize(Integer.valueOf(20));
            }
            if (bo.getPageNum() == null || bo.getPageNum() == 0) {
                bo.setPageNum(Integer.valueOf(1));
            }
            if (StringUtils.isNotEmpty((CharSequence)bo.getStoreIds())) {
                List storeIdList = Arrays.asList(bo.getStoreIds().split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                bo.setStoreIdList(storeIdList);
            }
            AppletResourcesPOExample appletResourcesPOExample = new AppletResourcesPOExample();
            appletResourcesPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andModularCodeEqualTo("M001").andSysBrandIdEqualTo(bo.getSysBrandId()).andModularTypeEqualTo("2");
            List resourcesPOS = this.appletResourcesPOMapper.selectByExample(appletResourcesPOExample);
            for (AppletResourcesPO appletResourcesPO : resourcesPOS) {
                appletResourcesPO.setModularContent(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletResourcesPO.getModularContent()));
            }
            if (StringUtils.isNotEmpty((CharSequence)bo.getCouponEntityId()) && NumberUtils.isCreatable((String)bo.getCouponEntityId())) {
                long couponId = Long.parseLong(bo.getCouponEntityId());
                ResponseData couponDetail = this.couponQueryServiceFeign.getCouponDetail(Long.valueOf(couponId));
                if (couponDetail.getCode() != 0) {
                    responseData.setData((Object)couponDetail);
                    return responseData;
                }
                CouponDetailResponseVO cVo = (CouponDetailResponseVO)couponDetail.getData();
                if (cVo != null) {
                    ResponseData storeIdsResponse;
                    SysBojunQueryDTO sysBojunQueryDTO;
                    List<String> propIds;
                    String[] split;
                    CouponDefinitionPOWithBLOBs cp = cVo.getCouponDefinitionPOWithBLOBs();
                    if (null != cp.getApplianceStoreType() && cp.getApplianceStoreType() == 2) {
                        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cp.getStoreWhitelist())) {
                            split = cp.getStoreWhitelist().split(",");
                            bo.setStoreWhitelist(Arrays.asList(split));
                        } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cp.getStoreBlacklist())) {
                            split = cp.getStoreBlacklist().split(",");
                            bo.setStoreBlacklist(Arrays.asList(split));
                        }
                    } else if (null != cp.getApplianceStoreType() && cp.getApplianceStoreType() == 3) {
                        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cp.getStoreWhitelist())) {
                            split = cp.getStoreWhitelist().split(",");
                            propIds = Arrays.asList(split);
                            sysBojunQueryDTO = new SysBojunQueryDTO();
                            sysBojunQueryDTO.setPropIdList(propIds);
                            sysBojunQueryDTO.setIsSp1(Boolean.valueOf(true));
                            storeIdsResponse = this.sysBojunDataServiceRpc.findStoreCodeListByPropIds(sysBojunQueryDTO);
                            if (storeIdsResponse.getCode() == SysResponseEnum.SUCCESS.getCode()) {
                                bo.setStoreWhitelist((List)storeIdsResponse.getData());
                            }
                        }
                    } else if (null != cp.getApplianceStoreType() && cp.getApplianceStoreType() == 4 && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cp.getStoreWhitelist())) {
                        split = cp.getStoreWhitelist().split(",");
                        propIds = Arrays.asList(split);
                        sysBojunQueryDTO = new SysBojunQueryDTO();
                        sysBojunQueryDTO.setPropIdList(propIds);
                        sysBojunQueryDTO.setIsSp1(Boolean.valueOf(false));
                        storeIdsResponse = this.sysBojunDataServiceRpc.findStoreCodeListByPropIds(sysBojunQueryDTO);
                        if (storeIdsResponse.getCode() == SysResponseEnum.SUCCESS.getCode()) {
                            bo.setStoreWhitelist((List)storeIdsResponse.getData());
                        }
                    }
                }
            }
            logger.info("\u83b7\u53d6\u95e8\u5e97\u5165\u53c2{}", (Object)JSON.toJSONString((Object)bo));
            ResponseData storeListPage = this.storeServiceRpc.getBrandByIdSysStoreListPage(bo);
            logger.info("storeListPage:{}", JSON.toJSON((Object)storeListPage));
            List storeList = ((PageInfo)storeListPage.getData()).getList();
            if (CollectionUtils.isEmpty((Collection)storeList)) {
                AppletRefreshtoInterfaceBo appletRefreshtoInterfaceBo = new AppletRefreshtoInterfaceBo();
                appletRefreshtoInterfaceBo.setAppletSysStoreBos(new ArrayList());
                appletRefreshtoInterfaceBo.setResourcesPOS(resourcesPOS);
                responseData.setData((Object)appletRefreshtoInterfaceBo);
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            int isShowImgFlag = ((SysStoreBo)storeList.get(0)).getIsShowImg();
            ArrayList<AppletSysStoreBo> AppletSysStoreBos = new ArrayList<AppletSysStoreBo>();
            for (SysStoreBo sysStoreBo : storeList) {
                AppletSysStoreBo appletSysStoreBo = new AppletSysStoreBo();
                String distance = sysStoreBo.getDistance();
                if (distance == null) {
                    sysStoreBo.setDistance(distance);
                } else {
                    Double aDouble = Double.valueOf(distance);
                    if (aDouble == null) {
                        sysStoreBo.setDistance(distance);
                    }
                    double lod = aDouble / 1000.0;
                    String format = this.df.format(lod);
                    sysStoreBo.setDistance(format);
                }
                BeanUtils.copyProperties((Object)sysStoreBo, (Object)appletSysStoreBo);
                if (appletSysStoreBo != null) {
                    AppletSysStoreBos.add(appletSysStoreBo);
                    continue;
                }
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                return responseData;
            }
            AppletRefreshtoInterfaceBo appletRefreshtoInterfaceBo = new AppletRefreshtoInterfaceBo();
            ArrayList<AppletSysStoreBo> sysStoreBos = new ArrayList<AppletSysStoreBo>();
            ArrayList<AppletSysStoreBo> appletSysStoreBos = new ArrayList<AppletSysStoreBo>();
            ArrayList<AppletSysStoreBo> bos = new ArrayList<AppletSysStoreBo>();
            if (AppletSysStoreBos != null) {
                for (AppletSysStoreBo appletSysStoreBo : AppletSysStoreBos) {
                    if (appletSysStoreBo.getDistance() == null && !"1".equals(appletSysStoreBo.getIsExclusive())) {
                        sysStoreBos.add(appletSysStoreBo);
                    }
                    if (appletSysStoreBo.getDistance() != null && !"1".equals(appletSysStoreBo.getIsExclusive())) {
                        appletSysStoreBos.add(appletSysStoreBo);
                    }
                    if (!"1".equals(appletSysStoreBo.getIsExclusive())) continue;
                    bos.add(appletSysStoreBo);
                }
            }
            if (appletSysStoreBos != null) {
                Collections.sort(appletSysStoreBos, new /* Unavailable Anonymous Inner Class!! */);
            }
            ArrayList<AppletSysStoreBo> appletSysStoreBoList = new ArrayList<AppletSysStoreBo>();
            appletSysStoreBoList.addAll(bos);
            appletSysStoreBoList.addAll(appletSysStoreBos);
            appletSysStoreBoList.addAll(sysStoreBos);
            appletRefreshtoInterfaceBo.setAppletSysStoreBos(appletSysStoreBoList);
            appletRefreshtoInterfaceBo.setResourcesPOS(resourcesPOS);
            appletRefreshtoInterfaceBo.setTotal(Long.valueOf(((PageInfo)storeListPage.getData()).getTotal()));
            appletRefreshtoInterfaceBo.setIsShowImg(Integer.valueOf(isShowImgFlag));
            logger.info("\u95e8\u5e97\u5bfc\u822a\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)appletRefreshtoInterfaceBo));
            responseData.setData((Object)appletRefreshtoInterfaceBo);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        }
        catch (Exception e) {
            logger.warn("MemberStoreController#getBrandByIdSysStoreList\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
        }
        return responseData;
    }

    @RequestMapping(value={"/getClubBrandByIdSysStoreList"}, method={RequestMethod.POST})
    public ResponseData getClubBrandByIdSysStoreList(SysStoreBo bo, HttpServletRequest request) {
        logger.info("\u95e8\u5e97\u5bfc\u822a\u5165\u53c2={}", (Object)JSON.toJSONString((Object)bo));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String groupMemberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (groupMemberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            responseData.setCode(-100);
            return responseData;
        }
        if (bo.getSysBrandId() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return responseData;
        }
        List allMemberCardByMemberCode = this.vgGetAllMemberInfoService.getAllMemberCardByMemberCode(groupMemberCode);
        AllCardResponseVO allCardResponseVOClub = allMemberCardByMemberCode.stream().filter(allCardResponseVO -> String.valueOf(allCardResponseVO.getBrandId()).equals(String.valueOf(bo.getSysBrandId()))).findFirst().orElse(null);
        if (allCardResponseVOClub == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u4ff1\u4e50\u90e8\u672a\u5165\u4f1a");
            return responseData;
        }
        String memberCode = allCardResponseVOClub.getMemberCode();
        Long storeId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        bo.setSysStoreId(storeId);
        if (bo.getPageSize() == null || bo.getPageSize() == 0) {
            bo.setPageSize(Integer.valueOf(20));
        }
        if (bo.getPageNum() == null || bo.getPageNum() == 0) {
            bo.setPageNum(Integer.valueOf(1));
        }
        if (StringUtils.isNotEmpty((CharSequence)bo.getStoreIds())) {
            List storeIdList = Arrays.asList(bo.getStoreIds().split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            bo.setStoreIdList(storeIdList);
        }
        AppletResourcesPOExample appletResourcesPOExample = new AppletResourcesPOExample();
        appletResourcesPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andModularCodeEqualTo("M001").andSysBrandIdEqualTo(bo.getSysBrandId()).andModularTypeEqualTo("2");
        List resourcesPOS = this.appletResourcesPOMapper.selectByExample(appletResourcesPOExample);
        for (AppletResourcesPO appletResourcesPO : resourcesPOS) {
            appletResourcesPO.setModularContent(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletResourcesPO.getModularContent()));
        }
        if (StringUtils.isNotEmpty((CharSequence)bo.getCouponEntityId()) && NumberUtils.isCreatable((String)bo.getCouponEntityId())) {
            Object cp;
            long couponId = Long.parseLong(bo.getCouponEntityId());
            ResponseData couponDetail = this.couponQueryServiceFeign.getCouponDetail(Long.valueOf(couponId));
            if (couponDetail.getCode() != 0) {
                responseData.setData((Object)couponDetail);
                return responseData;
            }
            CouponDetailResponseVO cVo = (CouponDetailResponseVO)couponDetail.getData();
            if (cVo != null && null != (cp = cVo.getCouponDefinitionPOWithBLOBs()).getApplianceStoreType() && cp.getApplianceStoreType() == 2) {
                String[] split;
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cp.getStoreWhitelist())) {
                    split = cp.getStoreWhitelist().split(",");
                    bo.setStoreWhitelist(Arrays.asList(split));
                } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cp.getStoreBlacklist())) {
                    split = cp.getStoreBlacklist().split(",");
                    bo.setStoreBlacklist(Arrays.asList(split));
                }
            }
        }
        logger.info("\u83b7\u53d6\u95e8\u5e97\u5165\u53c2{}", (Object)JSON.toJSONString((Object)bo));
        ResponseData storeListPage = this.storeServiceRpc.getBrandByIdSysStoreListPage(bo);
        List storeList = ((PageInfo)storeListPage.getData()).getList();
        if (CollectionUtils.isEmpty((Collection)storeList)) {
            AppletRefreshtoInterfaceBo appletRefreshtoInterfaceBo = new AppletRefreshtoInterfaceBo();
            appletRefreshtoInterfaceBo.setAppletSysStoreBos(new ArrayList());
            appletRefreshtoInterfaceBo.setResourcesPOS(resourcesPOS);
            responseData.setData((Object)appletRefreshtoInterfaceBo);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        int isShowImgFlag = ((SysStoreBo)storeList.get(0)).getIsShowImg();
        ArrayList<AppletSysStoreBo> AppletSysStoreBos = new ArrayList<AppletSysStoreBo>();
        for (SysStoreBo sysStoreBo : storeList) {
            AppletSysStoreBo appletSysStoreBo = new AppletSysStoreBo();
            String distance = sysStoreBo.getDistance();
            if (distance == null) {
                sysStoreBo.setDistance(distance);
            } else {
                Double aDouble = Double.valueOf(distance);
                if (aDouble == null) {
                    sysStoreBo.setDistance(distance);
                }
                double lod = aDouble / 1000.0;
                String format = this.df.format(lod);
                sysStoreBo.setDistance(format);
            }
            BeanUtils.copyProperties((Object)sysStoreBo, (Object)appletSysStoreBo);
            if (appletSysStoreBo != null) {
                AppletSysStoreBos.add(appletSysStoreBo);
                continue;
            }
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        AppletRefreshtoInterfaceBo appletRefreshtoInterfaceBo = new AppletRefreshtoInterfaceBo();
        ArrayList<AppletSysStoreBo> sysStoreBos = new ArrayList<AppletSysStoreBo>();
        ArrayList<AppletSysStoreBo> appletSysStoreBos = new ArrayList<AppletSysStoreBo>();
        ArrayList<AppletSysStoreBo> bos = new ArrayList<AppletSysStoreBo>();
        if (AppletSysStoreBos != null) {
            for (AppletSysStoreBo appletSysStoreBo : AppletSysStoreBos) {
                if (appletSysStoreBo.getDistance() == null && !"1".equals(appletSysStoreBo.getIsExclusive())) {
                    sysStoreBos.add(appletSysStoreBo);
                }
                if (appletSysStoreBo.getDistance() != null && !"1".equals(appletSysStoreBo.getIsExclusive())) {
                    appletSysStoreBos.add(appletSysStoreBo);
                }
                if (!"1".equals(appletSysStoreBo.getIsExclusive())) continue;
                bos.add(appletSysStoreBo);
            }
        }
        if (appletSysStoreBos != null) {
            Collections.sort(appletSysStoreBos, new /* Unavailable Anonymous Inner Class!! */);
        }
        ArrayList<AppletSysStoreBo> appletSysStoreBoList = new ArrayList<AppletSysStoreBo>();
        appletSysStoreBoList.addAll(bos);
        appletSysStoreBoList.addAll(appletSysStoreBos);
        appletSysStoreBoList.addAll(sysStoreBos);
        appletRefreshtoInterfaceBo.setAppletSysStoreBos(appletSysStoreBoList);
        appletRefreshtoInterfaceBo.setResourcesPOS(resourcesPOS);
        appletRefreshtoInterfaceBo.setTotal(Long.valueOf(((PageInfo)storeListPage.getData()).getTotal()));
        appletRefreshtoInterfaceBo.setIsShowImg(Integer.valueOf(isShowImgFlag));
        logger.info("\u95e8\u5e97\u5bfc\u822a\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)appletRefreshtoInterfaceBo));
        responseData.setData((Object)appletRefreshtoInterfaceBo);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    @RequestMapping(value={"/getStoreStaffList"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<com.bizvane.utils.responseinfo.PageInfo<StaffVo>> getBrandByIdSysStoreList(Long sysStoreId, Long sysCompanyId, Long sysBrandId, PageFormUtil formUtil) {
        ResponseData responseData = new ResponseData();
        ResponseData sysStoreVoResponseData = this.storeServiceRpc.getSysStoreById(sysStoreId);
        SysStoreVo storeVo = (SysStoreVo)sysStoreVoResponseData.getData();
        ResponseData staffVOResult = this.staffServiceRpc.getStoreStaffListByStatus(storeVo.getSysStoreOfflineCode(), sysCompanyId, formUtil.getPageNumber(), formUtil.getPageSize());
        logger.info("\u67e5\u8be2\u5e97\u94fa\u4e0b\u7684\u5bfc\u8d2d={}", (Object)JSON.toJSONString((Object)staffVOResult));
        responseData.setData((Object)staffVOResult);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    @RequestMapping(value={"/getStorePrivilegeInfoById"}, method={RequestMethod.POST})
    public ResponseData<SysStorePrivilegePo> getStorePrivilegeInfoById(@RequestParam(value="sysStorePrivilegeId") Long sysStorePrivilegeId) {
        return this.storeServiceRpc.getStorePrivilegeInfoById(sysStorePrivilegeId);
    }

    @RequestMapping(value={"/getSysStoreById"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<SysStoreVo> getSysStoreById(@RequestParam(value="sysStoreId") Long sysStoreId) {
        return this.storeServiceRpc.getSysStoreById(sysStoreId);
    }

    @RequestMapping(value={"/getStoreById"}, method={RequestMethod.POST})
    public ResponseData<SysStorePo> getOfflineStoreById(Long sysStoreId) {
        return this.storeServiceRpc.getStoreById(sysStoreId);
    }
}

