/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.models.bo.MbrRechargeRecordBo;
import com.bizvane.appletservice.models.vo.RechargeReCordVo;
import com.bizvane.appletserviceimpl.utils.QRCodeUtil;
import com.bizvane.centerstageservice.models.po.MbrQuickRechargePo;
import com.bizvane.centerstageservice.models.po.MbrRechargeMenuPo;
import com.bizvane.centerstageservice.models.po.MbrRechargeRecordPo;
import com.bizvane.centerstageservice.rpc.MbrRechargeServiceRpc;
import com.bizvane.couponfacade.interfaces.UtilsServiceFeign;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.mktcenterservice.models.vo.MktActivityPayVo;
import com.bizvane.mktcenterservice.rpc.ActivityPayServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberRecharge"}, method={RequestMethod.POST})
public class MemberRechargeController {
    @Autowired
    private MbrRechargeServiceRpc mbrRechargeServiceRpc;
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    @Autowired
    private ActivityPayServiceRpc activityPayServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private UtilsServiceFeign utilsServiceFeign;

    @RequestMapping(value={"/menuQuery"}, method={RequestMethod.POST})
    public ResponseData menuQuery(MbrRechargeMenuPo mbrRechargeMenuPo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        logger.info("\u83dc\u5355\u67e5\u8be2={}", (Object)JSON.toJSONString((Object)mbrRechargeMenuPo));
        return this.mbrRechargeServiceRpc.getMbrRechargeMenu(mbrRechargeMenuPo);
    }

    @RequestMapping(value={"/getMbrQuickRecharge"}, method={RequestMethod.POST})
    public ResponseData getMbrQuickRecharge(MbrRechargeRecordBo mbrRechargeRecordBo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        if (mbrRechargeRecordBo.getMbrRechargeStoreId() == null) {
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(memberCode);
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
            mbrRechargeRecordBo.setMbrRechargeStoreId(member.getServiceStoreId());
        }
        logger.info("\u5145\u503c\u5feb\u6377\u67e5\u8be2\u5165\u53c2={}", (Object)JSON.toJSONString((Object)mbrRechargeRecordBo));
        return this.mbrRechargeServiceRpc.getMbrQuickRechargeByStoreId(mbrRechargeRecordBo.getSysBrandId(), mbrRechargeRecordBo.getMbrRechargeStoreId());
    }

    @RequestMapping(value={"/getBrandIdGiveMoney"}, method={RequestMethod.POST})
    public ResponseData getBrandIdGiveMoney(MbrRechargeRecordBo mbrRechargeRecordBo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        MbrQuickRechargePo mbrQuickRechargePo = new MbrQuickRechargePo();
        mbrQuickRechargePo.setSysBrandId(mbrRechargeRecordBo.getSysBrandId());
        mbrQuickRechargePo.setRechargeMoney(mbrRechargeRecordBo.getRechargeMoney());
        logger.info("\u6839\u636e\u91d1\u989d\u67e5\u8be2\u8d60\u9001\u91d1\u989d\u5165\u53c2={}", (Object)JSON.toJSONString((Object)mbrRechargeRecordBo));
        return this.mbrRechargeServiceRpc.getBrandIdGiveMoney(mbrQuickRechargePo);
    }

    @RequestMapping(value={"/getCardNoRechargeRecordList"}, method={RequestMethod.POST})
    public ResponseData getCardNoRechargeRecordList(MbrRechargeRecordBo mbrRechargeRecordBo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel data = (MemberCardLevelModel)modelResponseData.getData();
        String cardNo = data.getCardNo();
        MbrRechargeRecordPo mbrRechargeRecordPo = new MbrRechargeRecordPo();
        mbrRechargeRecordPo.setSysBrandId(mbrRechargeRecordBo.getSysBrandId());
        mbrRechargeRecordPo.setCardNo(cardNo);
        logger.info("\u6839\u636e\u4f1a\u5458\u5361\u53f7\u67e5\u8be2\u5145\u503c\u8bb0\u5f55\u5165\u53c2={}", (Object)JSON.toJSONString((Object)mbrRechargeRecordPo));
        ResponseData cardNoRechargeRecordList = this.mbrRechargeServiceRpc.getCardNoRechargeRecordList(mbrRechargeRecordPo);
        RechargeReCordVo rechargeReCordVo = new RechargeReCordVo();
        if (cardNoRechargeRecordList.getData() == null) {
            rechargeReCordVo.setBalance(Double.valueOf(0.0));
            rechargeReCordVo.setMbrRechargeRecordPos(null);
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)rechargeReCordVo);
            return responseData;
        }
        if (((List)cardNoRechargeRecordList.getData()).size() > 0) {
            Double balance = ((MbrRechargeRecordPo)((List)cardNoRechargeRecordList.getData()).get(0)).getBalance();
            List listData = (List)cardNoRechargeRecordList.getData();
            rechargeReCordVo.setBalance(balance);
            rechargeReCordVo.setMbrRechargeRecordPos(listData);
        } else {
            rechargeReCordVo.setBalance(Double.valueOf(0.0));
            rechargeReCordVo.setMbrRechargeRecordPos(null);
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)rechargeReCordVo);
        return responseData;
    }

    @RequestMapping(value={"/getRechargeStyle"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData getRechargeStyle(MbrRechargeRecordBo mbrRechargeRecordBo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        logger.info("\u4f1a\u5458\u5145\u503c\u5361\u6837\u5f0f\u5165\u53c2={}", (Object)JSON.toJSONString((Object)mbrRechargeRecordBo));
        return this.mbrRechargeServiceRpc.getRechargeStyle(mbrRechargeRecordBo.getSysBrandId());
    }

    @RequestMapping(value={"/selectActivityBrandList"}, method={RequestMethod.POST})
    public ResponseData selectActivityBrandList(MktActivityPayVo activityVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
        activityVO.setMemberCode(memberCode);
        activityVO.setMbrLevelCode(String.valueOf(member.getLevelId()));
        activityVO.setStoreLimitList(String.valueOf(member.getServiceStoreId()));
        logger.info("\u50a8\u503c\u793c\u5305\u5217\u8868\u5982\u5165\u53c2={}", (Object)JSON.toJSONString((Object)activityVO));
        return this.activityPayServiceRpc.selectActivityBrandList(activityVO);
    }

    @RequestMapping(value={"/getBalanceByMemberCode"}, method={RequestMethod.POST})
    public ResponseData getBalanceByMemberCode(Long brandId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData result = this.memberInfoApiService.getBalanceByMemberCode(memberCode, brandId);
        BigDecimal balance = (BigDecimal)result.getData();
        balance = balance != null ? balance.setScale(2, 1) : new BigDecimal(0).setScale(0);
        responseData.setData((Object)balance);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    @RequestMapping(value={"/getBarcode"}, method={RequestMethod.POST})
    public ResponseData getBarcode(String code) {
        return this.utilsServiceFeign.getBarcode(code);
    }

    @RequestMapping(value={"/getBarcode2"}, method={RequestMethod.POST})
    public ResponseData getBarcode2(String code) {
        ResponseData result = new ResponseData();
        String s = null;
        try {
            s = QRCodeUtil.crateQRCode((String)code, (int)200, (int)200);
        }
        catch (IOException e) {
            e.printStackTrace();
            result.setCode(SysResponseEnum.FAILED.getCode());
            result.setMessage("\u4e8c\u7ef4\u7801\u751f\u6210\u5f02\u5e38");
            result.setData((Object)s);
        }
        result.setCode(SysResponseEnum.SUCCESS.getCode());
        result.setMessage(SysResponseEnum.SUCCESS.getMessage());
        result.setData((Object)s.replaceAll("\\n", ""));
        return result;
    }
}

