/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.IntegrationShopService;
import com.bizvane.appletservice.interfaces.MemberOpenCardStoreService;
import com.bizvane.appletservice.models.vo.MemberOpenCard2StoreVo;
import com.bizvane.appletservice.models.vo.MemberOpenCardStoreVo;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import io.jsonwebtoken.lang.Collections;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberOpenCardStore"}, method={RequestMethod.POST})
public class MemberOpenCardStoreController {
    @Autowired
    private MemberOpenCardStoreService memberOpenCardStoreService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    @Autowired
    private IntegrationShopService integrationShopService;

    @RequestMapping(value={"/searchStores"}, method={RequestMethod.POST})
    public ResponseData searchStores(@RequestHeader(value="sysCompanyId") Long sysCompanyId, MemberOpenCardStoreVo memberOpenCardStoreVo, HttpServletRequest request) throws Exception {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        String isWhole = "1";
        memberOpenCardStoreVo.setIsWholeStore(Integer.valueOf(Integer.parseInt(isWhole)));
        memberOpenCardStoreVo.setMemberCode(memberCode);
        memberOpenCardStoreVo.setSysCompanyId(sysCompanyId);
        logger.info("\u67e5\u8be2\u95e8\u5e97memberOpenCardStoreVo={}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        return this.memberOpenCardStoreService.searchStores(memberOpenCardStoreVo);
    }

    @RequestMapping(value={"/searchStoresByMemberCode"}, method={RequestMethod.POST})
    public ResponseData searchStoresByMemberCode(@RequestBody MemberOpenCardStoreVo memberOpenCardStoreVo, HttpServletRequest request) {
        logger.info("\u67e5\u8be2\u95e8\u5e97memberOpenCardStoreVo={}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        return this.memberOpenCardStoreService.searchStores(memberOpenCardStoreVo);
    }

    @RequestMapping(value={"/choosingStore"}, method={RequestMethod.POST})
    public ResponseData choosingStore(Long storeId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        logger.info("\u66f4\u6539\u95e8\u5e97={}", (Object)JSON.toJSONString((Object)storeId));
        return this.memberOpenCardStoreService.choosingStore(storeId, memberCode);
    }

    @RequestMapping(value={"/searchStoresByRecordId"}, method={RequestMethod.POST})
    public ResponseData searchStoresByRecordId(MemberOpenCardStoreVo memberOpenCardStoreVo, HttpServletRequest request) {
        logger.info("searchStoresByRecordId memberOpenCardStoreVo:{}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        if (null == memberOpenCardStoreVo.getMktActivityPrizeRecordId()) {
            responseData.setMessage("\u4e2d\u5956\u8bb0\u5f55ID\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        memberOpenCardStoreVo.setMemberCode(memberCode);
        return this.memberOpenCardStoreService.searchStoresByRecordId(memberOpenCardStoreVo);
    }

    @RequestMapping(value={"/searchStoresByIds"}, method={RequestMethod.POST})
    public ResponseData searchStoresByIds(@RequestHeader(value="sysCompanyId") Long sysCompanyId, MemberOpenCard2StoreVo memberOpenCardStoreVo, HttpServletRequest request) throws Exception {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        String isWhole = "1";
        if (Collections.isEmpty((Collection)memberOpenCardStoreVo.getStoreIdList())) {
            isWhole = "1";
        }
        memberOpenCardStoreVo.setIsWholeStore(Integer.valueOf(Integer.parseInt(isWhole)));
        memberOpenCardStoreVo.setMemberCode(memberCode);
        memberOpenCardStoreVo.setSysCompanyId(sysCompanyId);
        logger.info("\u67e5\u8be2\u95e8\u5e97memberOpenCardStoreVo={}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        return this.memberOpenCardStoreService.searchStoresByIds(memberOpenCardStoreVo);
    }
}

