/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.FitmentService;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.models.vo.NorthOuBiRecordVO;
import com.bizvane.appletservice.models.vo.vg.VGSubscribeMsgAuthResponseVo;
import com.bizvane.appletservice.models.vo.vg.wrapper.AppletBrandIntroduceWrapperPO;
import com.bizvane.appletserviceimpl.impl.vg.VGCommonService;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.bo.MiniProgramPropertyVipCardShowBo;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.messagefacade.enums.vg.WechatSUbscribeMenuEnum;
import com.bizvane.unifiedreg.rpc.AppletServiceFeign;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateService;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fitment"})
public class FitmentController {
    @Autowired
    private FitmentService fitmentService;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private AppletServiceFeign appletServiceFeign;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private LoginService loginService;
    private DecimalFormat df = new DecimalFormat("###,###.00");
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    @Autowired
    private VGCommonService vgCommonService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private RedisTemplateService<String, String> redisTemplateService;

    @RequestMapping(value={"/selectBrandIntroduce"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData selectBrandIntroduce(Long sysBrandId) {
        String openId;
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = this.request.getHeader("bizvaneSessionId");
        ResponseData appletBrandIntroduceWrapperPO = this.fitmentService.selectBrandIntroduce(sysBrandId, Boolean.FALSE);
        List appletBrandIntroduceWrapperPOs = (List)appletBrandIntroduceWrapperPO.getData();
        if (StringUtils.isNotBlank((CharSequence)bizvaneSessionId) && CollectionUtils.isNotEmpty((Collection)appletBrandIntroduceWrapperPOs) && StringUtils.isNotBlank((CharSequence)(openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId))))) {
            VGSubscribeMsgAuthResponseVo vgSubscribeMsgAuthResponseVo = this.vgCommonService.queryBrandWechatAppletSubscribeDataRedis(sysBrandId, openId, WechatSUbscribeMenuEnum.FIELD_23);
            for (AppletBrandIntroduceWrapperPO appletBrandIntroducePO : appletBrandIntroduceWrapperPOs) {
                if (appletBrandIntroducePO == null) continue;
                appletBrandIntroducePO.setVgSubscribeMsgAuthResponseVo(vgSubscribeMsgAuthResponseVo);
                responseData.setData((Object)appletBrandIntroducePO);
                break;
            }
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    @RequestMapping(value={"/northOuBiRecord"})
    public ResponseData northOuBiRecord(NorthOuBiRecordVO northOuBiRecordVO, HttpServletRequest request) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(northOuBiRecordVO.getMemberCode());
        MemberInfoModel memberModel = (MemberInfoModel)this.memberInfoApiService.getMemberModel(memberInfoModel).getData();
        if (memberModel != null) {
            northOuBiRecordVO.setSysCompanyId(memberModel.getSysCompanyId());
        }
        return this.fitmentService.northOuBiRecord(northOuBiRecordVO);
    }

    @RequestMapping(value={"/getBaseAndExtendPropertyValueVipCardStyle"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData getBaseAndExtendPropertyValueVipCardStyle(Long brandId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String memberCode = this.loginService.getMemberCode(request);
        ResponseData miniProgramPropertyVipCardShow = this.appletServiceFeign.getMiniProgramPropertyVipCardShow(brandId, memberCode);
        List cardShowData = (List)miniProgramPropertyVipCardShow.getData();
        if (cardShowData == null) {
            return responseData;
        }
        for (MiniProgramPropertyVipCardShowBo miniProgramPropertyVipCardShowBo : cardShowData) {
            String propertyValue;
            if (miniProgramPropertyVipCardShowBo.getPropertyCode().indexOf("integral_") != -1) {
                propertyValue = miniProgramPropertyVipCardShowBo.getPropertyValue();
                logger.info("integral_+propertyValueString={}", (Object)propertyValue);
                Integer integer = Integer.valueOf(propertyValue);
                logger.info("integral_+propertyValueInteger={}", (Object)integer);
            }
            if (miniProgramPropertyVipCardShowBo.getPropertyCode().indexOf("extend_") != -1) {
                propertyValue = miniProgramPropertyVipCardShowBo.getPropertyValue();
                String propertyType = miniProgramPropertyVipCardShowBo.getPropertyType();
                if ("4".equals(propertyType) && StringUtils.isBlank((CharSequence)propertyValue)) {
                    miniProgramPropertyVipCardShowBo.setPropertyValue("0");
                }
            }
            if (miniProgramPropertyVipCardShowBo.getPropertyCode().indexOf("gender_") == -1 || !StringUtils.isNotBlank((CharSequence)(propertyValue = miniProgramPropertyVipCardShowBo.getPropertyValue())) || !"3".equals(propertyValue)) continue;
            miniProgramPropertyVipCardShowBo.setPropertyValue("");
        }
        responseData.setData((Object)cardShowData);
        return responseData;
    }

    @RequestMapping(value={"/getMiniProgramPropertyIntegralFromOffline"})
    public ResponseData getMiniProgramPropertyIntegralFromOffline(Long brandId, String memberCardNo, String memberCode) {
        logger.info("brandId={}", (Object)JSON.toJSONString((Object)brandId));
        logger.info("memberCode={}", (Object)JSON.toJSONString((Object)memberCode));
        logger.info("memberCardNo={}", (Object)JSON.toJSONString((Object)memberCardNo));
        ResponseData responseData = new ResponseData();
        if (brandId == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("brandId \u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        if (StringUtils.isEmpty((CharSequence)memberCardNo)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("memberCardNo \u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        ResponseData integral = this.wxAppletApiService.getMiniProgramPropertyIntegral(brandId, memberCardNo, memberCode);
        return integral;
    }
}

