package com.bizvane.analyze.facade.es.pojo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Data
@EqualsAndHashCode
@Document(indexName = "t_mbr_members", type = "doc")
public class MembersGroupAnalyzeLevelPojo implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	@Id
	private Long mbrMemberId;
	// 会员code
	private String memberCode;

	private String name;

	private String gender;

	private String phone;

	private Long levelId;

	private String cardNo;

    @JSONField(format="yyyy-MM-dd")
	private Date birthday;

    @JSONField(format="yyyy-MM-dd")
	private Date openCardTime;
	
	private String levelName;
	
	private Long openCardChannelId;
	
	private String openCardChannelName;

	private Integer groupNewMember;//是否为新会员: 1=新会员; 2=老会员

	private Integer memberLiveness;//会员活跃度: 1=活跃会员; 2=沉默会员; 3=濒临睡眠会员; 4=休眠会员; 5=流失会员 6=未消费会员

	private BigDecimal consumeAmountAll;//累计消费金额

	private String addresss;//地址

	private String province;//省

	private String city;//市

	private String county;//区

	private String ageName;//年龄段

	private BigDecimal balance;//余额
	
	
}
