package com.bizvane.alipayfacade.interfaces;

import com.bizvane.alipayfacade.models.po.AlipayPlatformPo;
import com.bizvane.alipayfacade.models.po.AlipayPublicPo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${feign.client.alipay.name}", path="${feign.client.alipay.path}/alipayPlatform")
@Api(value="支付宝生活号/小程序相关接口")
public interface AlipayPlatformServiceFeign {
    /**
     * 获取isv信息
     * @return
     */
    @ApiOperation(value = "获取isv信息")
    @PostMapping("/getAlipayPlatform")
    ResponseData<AlipayPlatformPo> getAlipayPlatform(@RequestParam("platformAppid") String platformAppid);

}
