/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.util;

import com.alibaba.schedulerx.common.domain.JSONResult;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.HttpResponse;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.JsonNode;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.Unirest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;

public class FileDownloader {
    private static final String DOWNLOADED_JAR_DIR = ConfigUtil.getWorkerConfig().getString("worker.jar.file.dir", "/tmp/jar/schedulerx/");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpDownload(String url) throws Exception {
        InputStream inStream = null;
        FileOutputStream outStream = null;
        String outFilePath = null;
        try {
            String fileName = url.substring(url.lastIndexOf("/") + 1);
            File dir = new File(DOWNLOADED_JAR_DIR);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (new File(outFilePath = DOWNLOADED_JAR_DIR + fileName).exists()) {
                String string2 = outFilePath;
                return string2;
            }
            String consoleDomain = ConfigUtil.getWorkerConfig().getString("domainName");
            String acquireDownloadSignatureUrl = "http://" + consoleDomain + "/job/getDownloadSignature.json?objName=" + fileName;
            HttpResponse<JsonNode> jsonResponse = Unirest.get(acquireDownloadSignatureUrl).asJson();
            JSONResult jsonResult = JsonUtil.fromJson(jsonResponse.getBody().toString(), JSONResult.class);
            String signedUrl = (String)((Map)jsonResult.getData()).get("signedUrl");
            URLConnection conn = new URL(signedUrl).openConnection();
            inStream = conn.getInputStream();
            outStream = new FileOutputStream(outFilePath);
            byte[] buffer = new byte[1024];
            int len2 = 0;
            while ((len2 = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len2);
            }
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
        return outFilePath;
    }
}

