/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master.handler;

import com.alibaba.schedulerx.common.domain.InstanceStatus;
import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.common.domain.LimitedQueue;
import com.alibaba.schedulerx.common.domain.ProgressHistory;
import com.alibaba.schedulerx.common.domain.SecondProgressDetail;
import com.alibaba.schedulerx.common.domain.TaskProgressCounter;
import com.alibaba.schedulerx.common.domain.WorkerProgressCounter;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.IdUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.CollectionUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.MapUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.discovery.ServerDiscoveryFactory;
import com.alibaba.schedulerx.worker.ha.HealthTimeHolder;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.logcollector.ClientLoggerMessage;
import com.alibaba.schedulerx.worker.logcollector.LogCollector;
import com.alibaba.schedulerx.worker.logcollector.LogCollectorFactory;
import com.alibaba.schedulerx.worker.master.BroadcastTaskMaster;
import com.alibaba.schedulerx.worker.master.MapTaskMaster;
import com.alibaba.schedulerx.worker.master.StandaloneTaskMaster;
import com.alibaba.schedulerx.worker.master.TaskMaster;
import com.alibaba.schedulerx.worker.master.handler.UpdateInstanceStatusHandler;
import com.alibaba.schedulerx.worker.processor.ProcessResult;
import com.alibaba.schedulerx.worker.util.ActorPathUtil;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SecondJobUpdateInstanceStatusHandler
extends UpdateInstanceStatusHandler {
    private LogCollector logCollector = LogCollectorFactory.get();
    private static final Logger LOGGER = LogFactory.getLogger(SecondJobUpdateInstanceStatusHandler.class);
    private static final int MISS_SERVER_KILL_TIME = 30;
    SecondProgressDetail secondProgressDetail;
    LimitedQueue<ProgressHistory> recentProgressHistory = new LimitedQueue(10);
    long cycleStartTime = System.currentTimeMillis();
    private boolean enableCycleIntervalMs = ConfigUtil.getWorkerConfig().getBoolean("second.delay.interval.ms.enable", false);

    SecondJobUpdateInstanceStatusHandler(TaskMaster taskMaster, JobInstanceInfo jobInstanceInfo) {
        super(taskMaster, jobInstanceInfo);
        this.secondProgressDetail = new SecondProgressDetail();
        this.init();
    }

    @Override
    public void handle(long serialNum, InstanceStatus instanceStatus, String result2) throws Exception {
        String cycleId = IdUtil.getUniqueId(this.jobInstanceInfo.getJobId(), this.jobInstanceInfo.getJobInstanceId(), this.taskMaster.getSerialNum());
        LOGGER.info("cycleId: {} instanceStatus={} cycle update status.", new Object[]{cycleId, instanceStatus});
        if (!this.taskMaster.isInited() && instanceStatus.isFinish() && !this.taskMaster.isKilled()) {
            this.taskMaster.killInstance("killed, because of worker init failed.");
            LOGGER.warn("Init failed need to kill self, cycleId={}", cycleId);
            return;
        }
        if (this.taskMaster.isKilled() && StringUtils.contains(result2, "killed")) {
            String progress;
            this.taskMaster.setInstanceStatus(InstanceStatus.FAILED);
            this.taskMaster.stop();
            this.masterPool.remove(this.jobInstanceInfo.getJobInstanceId());
            Worker.WorkerReportJobInstanceStatusRequest.Builder builder = Worker.WorkerReportJobInstanceStatusRequest.newBuilder().setJobId(this.jobInstanceInfo.getJobId()).setJobInstanceId(this.jobInstanceInfo.getJobInstanceId()).setStatus(instanceStatus.getValue()).setGroupId(this.jobInstanceInfo.getGroupId());
            if (result2 != null) {
                builder.setResult(result2);
            }
            if ((progress = this.getJobInstanceProgress()) != null) {
                builder.setProgress(progress);
            }
            SchedulerxWorker.AtLeastDeliveryRoutingActor.tell(builder.build(), null);
            LOGGER.info("report cycleId={}, status={} to AtLeastDeliveryRoutingActor", new Object[]{cycleId, instanceStatus});
        }
        if (instanceStatus.isFinish()) {
            this.triggerNextCycle(cycleId, serialNum, instanceStatus);
        }
    }

    private synchronized void triggerNextCycle(String cycleId, long serialNum, InstanceStatus instanceStatus) {
        if (serialNum != this.taskMaster.getSerialNum()) {
            LOGGER.info("triggerNextCycle={} ignore, current serialNum={}, but trigger serialNum={}, status={}, killed={}.", new Object[]{cycleId, this.taskMaster.getSerialNum(), serialNum, instanceStatus, this.taskMaster.isKilled()});
            return;
        }
        ProcessResult postResult = this.taskMaster.postFinish(this.jobInstanceInfo.getJobInstanceId());
        if (postResult != null) {
            LOGGER.info("cycleId: {} cycle post status, result={}.", new Object[]{cycleId, postResult.getStatus(), postResult.getResult()});
        }
        this.logCollector.collect(cycleId, ClientLoggerMessage.appendMessage("[TaskMaster-updateTaskStatus]instance finish status is ", instanceStatus.getEnDesc()));
        LOGGER.info("cycleId: {} cycle end.", cycleId);
        this.setHistory(this.taskMaster.getSerialNum(), this.cycleStartTime, instanceStatus);
        if (!this.taskMaster.isKilled()) {
            try {
                this.taskMaster.clear();
                long delayTime = 0L;
                delayTime = this.enableCycleIntervalMs ? Long.parseLong(this.jobInstanceInfo.getTimeExpression()) : Long.parseLong(this.jobInstanceInfo.getTimeExpression()) * 1000L;
                this.cycleStartTime = System.currentTimeMillis() + delayTime;
                Thread.sleep(delayTime);
                cycleId = IdUtil.getUniqueId(this.jobInstanceInfo.getJobId(), this.jobInstanceInfo.getJobInstanceId(), this.taskMaster.aquireSerialNum());
                LOGGER.info("cycleId: {} cycle begin.", cycleId);
                this.cycleStartTime = System.currentTimeMillis();
                JobInstanceInfo.newBuilder(this.jobInstanceInfo).setScheduleTime(DateTime.now());
                this.taskMaster.submitInstance(this.jobInstanceInfo);
            }
            catch (Throwable ex) {
                this.taskMaster.killInstance("killed, because of cycle submit failed.");
                LOGGER.error("cycleId: {} cycle submit failed, need to kill.", cycleId, ex);
            }
        } else {
            this.taskMaster.aquireSerialNum();
        }
    }

    void init() {
        final String jobIdAndInstanceId = IdUtil.getUniqueIdWithoutTask(this.jobInstanceInfo.getJobId(), this.jobInstanceInfo.getJobInstanceId());
        new Thread(new Runnable(){

            @Override
            public void run() {
                int intervalTimes = 0;
                try {
                    while (!SecondJobUpdateInstanceStatusHandler.this.taskMaster.isKilled()) {
                        Thread.sleep(1000L);
                        if (intervalTimes++ > 10) {
                            intervalTimes = 0;
                            Worker.WorkerReportJobInstanceProgressRequest request2 = Worker.WorkerReportJobInstanceProgressRequest.newBuilder().setJobId(SecondJobUpdateInstanceStatusHandler.this.jobInstanceInfo.getJobId()).setJobInstanceId(SecondJobUpdateInstanceStatusHandler.this.jobInstanceInfo.getJobInstanceId()).setProgress(SecondJobUpdateInstanceStatusHandler.this.getJobInstanceProgress()).build();
                            ServerDiscoveryFactory.getDiscovery(SecondJobUpdateInstanceStatusHandler.this.jobInstanceInfo.getGroupId()).getMapMasterRouter().tell(request2, null);
                        }
                        SecondJobUpdateInstanceStatusHandler.this.need2KillSelf();
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("report status error, jobIdAndInstanceId={}.", jobIdAndInstanceId, e);
                }
            }
        }, "Schedulerx-SecondTaskMaster-report-progress-thread-" + jobIdAndInstanceId).start();
    }

    private void need2KillSelf() {
        if (!this.taskMaster.isInited()) {
            return;
        }
        String jobIdAndInstanceId = IdUtil.getUniqueIdWithoutTask(this.jobInstanceInfo.getJobId(), this.jobInstanceInfo.getJobInstanceId());
        if (HealthTimeHolder.INSTANCE.isServerHeartbeatHealthTimeout(30)) {
            this.taskMaster.killInstance("killed, because of worker missed active server.");
            LOGGER.warn("Missed server timeout={}ms, kill jobIdAndInstanceId={}.", HealthTimeHolder.INSTANCE.getServerHeartbeatMsInterval(), jobIdAndInstanceId);
            return;
        }
        if (CollectionUtils.isEmpty(this.taskMaster.getAliveCheckWorkerSet()) && CollectionUtils.isEmpty(this.taskMaster.getJobInstanceInfo().getAllWorkers())) {
            LOGGER.warn("Missed useful worker list, kill jobIdAndInstanceId={}.", jobIdAndInstanceId);
            this.taskMaster.killInstance("killed, because of missed useful worker list.");
            return;
        }
    }

    protected String getJobInstanceProgress() {
        this.secondProgressDetail.setRunningProgress(this.taskMaster.getJobInstanceProgress());
        this.secondProgressDetail.setRunningStartTime(this.cycleStartTime);
        this.secondProgressDetail.setRecentProgressHistory(Lists.newArrayList(this.recentProgressHistory));
        String progressJson = JsonUtil.toJson(this.secondProgressDetail);
        this.secondProgressDetail.setRunningProgress(null);
        return progressJson;
    }

    private void setHistory(long serialNum, long loopStartTime, InstanceStatus status) {
        if (status == InstanceStatus.SUCCESS) {
            this.secondProgressDetail.getTodayProgressCounter().incrementSuccess();
        } else {
            this.secondProgressDetail.getTodayProgressCounter().incrementFailed();
        }
        if (!this.taskMaster.isKilled()) {
            this.secondProgressDetail.getTodayProgressCounter().incrementRunning();
            this.secondProgressDetail.getTodayProgressCounter().incrementTotal();
        }
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
        if (DateTime.now().dayOfMonth().get() != DateTime.parse((String)this.secondProgressDetail.getTodayBeginTime(), (DateTimeFormatter)formatter).dayOfMonth().get()) {
            this.secondProgressDetail.setYesterdayProgressCounter(this.secondProgressDetail.getTodayProgressCounter());
            this.secondProgressDetail.setTodayBeginTime(DateTime.now().toString("yyyy-MM-dd HH:mm:ss"));
            this.secondProgressDetail.setTodayProgressCounter(new TaskProgressCounter(this.secondProgressDetail.getTodayBeginTime()));
        }
        HashMap<String, TaskProgressCounter> taskProgressMap = null;
        String ipAndPort = ActorPathUtil.getIpAndPortFromAkkaPath(this.taskMaster.getLocalTaskRouterPath());
        if (this.taskMaster instanceof MapTaskMaster) {
            taskProgressMap = Maps.newHashMap(((MapTaskMaster)this.taskMaster).getTaskProgressMap());
        } else if (this.taskMaster instanceof BroadcastTaskMaster) {
            Map<String, WorkerProgressCounter> workerProgressCounterMap = ((BroadcastTaskMaster)this.taskMaster).getWorkerProgressMap();
            if (MapUtils.isEmpty(workerProgressCounterMap)) {
                return;
            }
            TaskProgressCounter counter = new TaskProgressCounter(ipAndPort);
            for (WorkerProgressCounter worker : workerProgressCounterMap.values()) {
                counter.incrementSuccess(worker.getSuccess());
                counter.incrementFailed(worker.getFailed());
                counter.incrementTotal(worker.getTotal());
            }
            taskProgressMap = Maps.newHashMap();
            taskProgressMap.put(ipAndPort, counter);
        } else if (this.taskMaster instanceof StandaloneTaskMaster) {
            taskProgressMap = Maps.newHashMap();
            TaskProgressCounter counter = new TaskProgressCounter(ipAndPort);
            taskProgressMap.put(ipAndPort, counter);
            counter.incrementTotal();
            if (status == InstanceStatus.SUCCESS) {
                counter.incrementSuccess();
            } else {
                counter.incrementFailed();
            }
        }
        if (MapUtils.isEmpty(taskProgressMap)) {
            return;
        }
        ProgressHistory history = new ProgressHistory();
        history.setSerialNum(serialNum);
        history.setStartTime(loopStartTime);
        history.setEndTime(System.currentTimeMillis());
        history.setCostTime(history.getEndTime() - history.getStartTime());
        history.setTaskProgressMap(taskProgressMap);
        history.setSuccess(status == InstanceStatus.SUCCESS);
        this.recentProgressHistory.offer(history);
    }
}

