/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master;

import akka.actor.ActorContext;
import com.alibaba.schedulerx.common.domain.InstanceStatus;
import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.common.domain.ShardingTaskProgress;
import com.alibaba.schedulerx.common.domain.ShardingTaskStatus;
import com.alibaba.schedulerx.common.domain.TaskProgressCounter;
import com.alibaba.schedulerx.common.domain.TaskStatus;
import com.alibaba.schedulerx.common.domain.WorkerProgressCounter;
import com.alibaba.schedulerx.common.util.ExceptionUtil;
import com.alibaba.schedulerx.common.util.HessianUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.shade.com.google.protobuf.ByteString;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.domain.ShardingTask;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.logcollector.LogCollector;
import com.alibaba.schedulerx.worker.logcollector.LogCollectorFactory;
import com.alibaba.schedulerx.worker.master.GridTaskMaster;
import com.alibaba.schedulerx.worker.processor.ProcessResult;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ShardingTaskMaster
extends GridTaskMaster {
    private Map<Long, ShardingTaskStatus> shardingTaskStatusMap = Maps.newConcurrentMap();
    private static final Logger LOGGER = LogFactory.getLogger(ShardingTaskMaster.class);
    private LogCollector logCollector = LogCollectorFactory.get();

    public ShardingTaskMaster(JobInstanceInfo jobInstanceInfo, ActorContext actorContext) throws Exception {
        super(jobInstanceInfo, actorContext);
    }

    @Override
    public void submitInstance(JobInstanceInfo info) {
        try {
            String shardingParameters;
            String string2 = shardingParameters = StringUtils.isNotEmpty(info.getInstanceParameters()) ? info.getInstanceParameters() : info.getParameters();
            if (StringUtils.isEmpty(shardingParameters)) {
                throw new InvalidParameterException("sharding parameters is empty");
            }
            String[] parameters = shardingParameters.split(",|\n|\r");
            int shardingNum = parameters.length;
            ArrayList<Worker.MasterStartContainerRequest> startContainerRequests = Lists.newArrayList();
            for (String para : parameters) {
                String[] tokens = para.split("=");
                if (tokens.length != 2) {
                    throw new InvalidParameterException("invalid sharding parameters, should be like 0=a,1=b,2=c");
                }
                long shardingId = Long.valueOf(tokens[0]);
                String taskName = tokens[0];
                String shardingParameter = tokens[1];
                if (this.taskProgressMap.containsKey(taskName)) {
                    throw new InvalidParameterException("shardingId={} is duplicated");
                }
                ShardingTask task = new ShardingTask(shardingId, shardingParameter);
                Worker.MasterStartContainerRequest.Builder builder = this.convert2StartContainerRequestBuilder(info, shardingId, taskName, ByteString.copyFrom(HessianUtil.toBytes(task)), false);
                builder.setShardingNum(shardingNum);
                Worker.MasterStartContainerRequest startContainerRequest = builder.build();
                startContainerRequests.add(startContainerRequest);
                TaskProgressCounter taskProgressCounter = new TaskProgressCounter(taskName);
                taskProgressCounter.incrementTotal();
                this.taskProgressMap.put(taskName, taskProgressCounter);
            }
            this.startBatchHandler();
            this.batchDispatchTasks(startContainerRequests);
            this.init();
        }
        catch (Throwable e) {
            String jobIdAndInstanceId = this.jobInstanceInfo.getJobId() + "_" + this.jobInstanceInfo.getJobInstanceId();
            LOGGER.error("", e);
            this.updateNewInstanceStatus(this.getSerialNum(), InstanceStatus.FAILED, ExceptionUtil.getMessage(e));
            this.logCollector.collect(jobIdAndInstanceId, "[MapTaskMaster-submitInstance]instance init fail.", e);
        }
    }

    @Override
    public void batchUpdateTaskStatues(List<Worker.ContainerReportTaskStatusRequest> requests) {
        super.batchUpdateTaskStatues(requests);
        for (Worker.ContainerReportTaskStatusRequest request2 : requests) {
            ShardingTaskStatus shardingTaskStatus;
            long taskId = request2.getTaskId();
            int taskStatus = request2.getStatus();
            String workerAddr = request2.getWorkerAddr();
            if (this.shardingTaskStatusMap.containsKey(taskId)) {
                shardingTaskStatus = this.shardingTaskStatusMap.get(taskId);
                shardingTaskStatus.setStatus(taskStatus);
                continue;
            }
            shardingTaskStatus = new ShardingTaskStatus(taskId, workerAddr, taskStatus);
            this.shardingTaskStatusMap.put(taskId, shardingTaskStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void batchHandlePulledProgress(List<Worker.MasterStartContainerRequest> masterStartContainerRequests, Map<String, List<Worker.MasterStartContainerRequest>> worker2ReqsWithNormal, Map<String, List<Worker.MasterStartContainerRequest>> worker2ReqsWithFailover, String remoteWorker) {
        for (Worker.MasterStartContainerRequest request2 : masterStartContainerRequests) {
            String workerIdAddr;
            String string2 = workerIdAddr = remoteWorker != null ? remoteWorker : this.selectWorker();
            if (workerIdAddr == null) {
                this.updateNewInstanceStatus(this.getSerialNum(), InstanceStatus.FAILED, "all worker is down!");
                break;
            }
            String workerAddr = workerIdAddr.split("@")[1];
            if (request2.getFailover()) {
                if (!worker2ReqsWithFailover.containsKey(workerIdAddr)) {
                    worker2ReqsWithFailover.put(workerIdAddr, Lists.newArrayList(request2));
                } else {
                    worker2ReqsWithFailover.get(workerIdAddr).add(request2);
                }
            } else if (!worker2ReqsWithNormal.containsKey(workerIdAddr)) {
                worker2ReqsWithNormal.put(workerIdAddr, Lists.newArrayList(request2));
            } else {
                worker2ReqsWithNormal.get(workerIdAddr).add(request2);
            }
            ((TaskProgressCounter)this.taskProgressMap.get(request2.getTaskName())).incrementPulled();
            if (workerAddr != null && !this.workerProgressMap.containsKey(workerAddr)) {
                ShardingTaskMaster shardingTaskMaster = this;
                synchronized (shardingTaskMaster) {
                    if (!this.workerProgressMap.containsKey(workerAddr)) {
                        WorkerProgressCounter workerProgressCounter = new WorkerProgressCounter(workerAddr);
                        this.workerProgressMap.put(workerAddr, workerProgressCounter);
                    }
                }
            }
            ((WorkerProgressCounter)this.workerProgressMap.get(workerAddr)).incrementTotal();
            ((WorkerProgressCounter)this.workerProgressMap.get(workerAddr)).incrementPulled();
            ShardingTaskStatus shardingTaskStatus = new ShardingTaskStatus(request2.getTaskId(), workerAddr, TaskStatus.INIT.getValue());
            this.shardingTaskStatusMap.put(request2.getTaskId(), shardingTaskStatus);
        }
    }

    @Override
    public String getJobInstanceProgress() {
        ShardingTaskProgress detail = new ShardingTaskProgress();
        detail.setShardingProgress(this.shardingTaskStatusMap.values());
        return JsonUtil.toJson(detail);
    }

    @Override
    protected void checkProcessor() throws Exception {
    }

    @Override
    public ProcessResult postFinish(long jobInstanceId) {
        try {
            this.taskPersistence.clearTasks(jobInstanceId);
        }
        catch (Throwable e) {
            LOGGER.error("", e);
        }
        return new ProcessResult(true);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.shardingTaskStatusMap != null) {
            this.shardingTaskStatusMap.clear();
        }
    }
}

