/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master;

import akka.actor.ActorContext;
import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.shade.com.google.protobuf.ByteString;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.CollectionUtils;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.master.GridTaskMaster;
import com.alibaba.schedulerx.worker.master.persistence.H2FilePersistence;
import com.alibaba.schedulerx.worker.util.SystemManagementUtil;
import java.io.IOException;
import java.util.List;

public class BatchTaskMaster
extends GridTaskMaster {
    private static final Logger LOGGER = LogFactory.getLogger(BatchTaskMaster.class);

    public BatchTaskMaster(JobInstanceInfo jobInstanceInfo, ActorContext actorContext) throws Exception {
        super(jobInstanceInfo, actorContext);
        this.taskPersistence = H2FilePersistence.getInstance();
        this.taskPersistence.initTable();
    }

    @Override
    public boolean map(List<ByteString> taskList, String taskName) throws Exception {
        if (CollectionUtils.isEmpty(taskList)) {
            LOGGER.warn("map taskList is empty, taskName:{}", taskName);
            return false;
        }
        LOGGER.info("map taskList, jobInstanceId={}, taskName:{}, taskList size:{}", this.jobInstanceInfo.getJobInstanceId(), taskName, taskList.size());
        float usedSpacePercent = SystemManagementUtil.getUserDiskSpacePercent();
        if (usedSpacePercent > 0.9f) {
            throw new IOException("used space beyond 90.0%!");
        }
        return super.map(taskList, taskName);
    }
}

