/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.container;

import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.worker.container.Container;
import com.alibaba.schedulerx.worker.container.ContainerPool;
import com.alibaba.schedulerx.worker.domain.JobContext;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadContainerPool
extends ContainerPool {
    private static ThreadContainerPool instance = new ThreadContainerPool();
    private Map<Long, ExecutorService> threadPoolMap = Maps.newConcurrentMap();
    private ThreadLocal<JobContext> contextThreadLocal = new ThreadLocal();
    private static boolean enableShareContainerPool = ConfigUtil.getWorkerConfig().getBoolean("share.container.pool", false);
    private static ThreadPoolExecutor SHARED_THREAD_POOL;

    private ThreadContainerPool() {
    }

    public static ThreadContainerPool getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(long jobId, final long jobInstanceId, long taskId, Container container, int consumerSize) {
        if (!enableShareContainerPool) {
            if (!this.threadPoolMap.containsKey(jobInstanceId)) {
                ThreadContainerPool threadContainerPool = this;
                synchronized (threadContainerPool) {
                    if (!this.threadPoolMap.containsKey(jobInstanceId)) {
                        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(consumerSize, consumerSize, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                            int index = 0;

                            @Override
                            public Thread newThread(Runnable runnable) {
                                return new Thread(runnable, "Schedulerx-Container-Thread-" + jobInstanceId + "-" + this.index++);
                            }
                        });
                        this.threadPoolMap.put(jobInstanceId, threadPool);
                        threadPool.allowCoreThreadTimeOut(true);
                    }
                }
            }
            this.threadPoolMap.get(jobInstanceId).execute((Runnable)((Object)container));
        } else {
            SHARED_THREAD_POOL.execute((Runnable)((Object)container));
        }
    }

    @Override
    public synchronized boolean destroyByInstance(long jobInstanceId) {
        if (this.threadPoolMap.containsKey(jobInstanceId)) {
            this.threadPoolMap.get(jobInstanceId).shutdownNow();
            this.threadPoolMap.remove(jobInstanceId);
        }
        return true;
    }

    @Override
    public void setContext(JobContext jobContext) {
        this.contextThreadLocal.set(jobContext);
    }

    @Override
    public JobContext getContext() {
        return this.contextThreadLocal.get();
    }

    @Override
    public void removeContext() {
        this.contextThreadLocal.remove();
    }

    static {
        if (enableShareContainerPool) {
            int poolSize = ConfigUtil.getWorkerConfig().getInt("share.pool.size", 64);
            SHARED_THREAD_POOL = new ThreadPoolExecutor(poolSize, poolSize, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10240), new ThreadFactory(){
                int index = 0;

                @Override
                public Thread newThread(Runnable runnable) {
                    return new Thread(runnable, "Schedulerx-Shared-Container-Thread-" + this.index++);
                }
            });
        }
    }
}

