/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.batch;

import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.worker.batch.ReqQueue;
import com.alibaba.schedulerx.worker.batch.TaskDispatchReqHandler;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.master.MapTaskMaster;
import java.util.List;

public class TaskPushReqHandler<T>
extends TaskDispatchReqHandler<T> {
    private int dispatchSize;
    private static final Logger LOGGER = LogFactory.getLogger(TaskPushReqHandler.class);

    public TaskPushReqHandler(long jobInstanceId, int coreBatchThreadNum, int maxBatchThreadNum, int batchSize, ReqQueue<T> queue2, int dispatchSize) {
        super(jobInstanceId, coreBatchThreadNum, maxBatchThreadNum, batchSize, queue2, "Schedulerx-Batch-Tasks-Dispatch-Thread-", "Schedulerx-Batch-Tasks-Retrieve-Thread-");
        this.defaultSleepMs = 100L;
        this.dispatchSize = dispatchSize;
    }

    @Override
    public void process(long jobInstanceId, List<T> reqs, String workerAddr) {
        this.batchProcessSvc.submit(new BatchTasksDispatchRunnable(jobInstanceId, reqs));
    }

    private class BatchTasksDispatchRunnable
    implements Runnable {
        private long jobInstanceId;
        private List<Worker.MasterStartContainerRequest> reqs;

        BatchTasksDispatchRunnable(long jobInstanceId, List<Worker.MasterStartContainerRequest> reqs) {
            this.jobInstanceId = jobInstanceId;
            this.reqs = reqs;
        }

        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                ((MapTaskMaster)TaskPushReqHandler.this.taskMasterPool.get(this.jobInstanceId)).batchDispatchTasks(this.reqs);
                LOGGER.info("jobInstance={}, batch dispatch cost:{} ms, dispatchSize:{}, size:{}", this.jobInstanceId, System.currentTimeMillis() - startTime, TaskPushReqHandler.this.dispatchSize, this.reqs.size());
            }
            catch (Throwable e) {
                LOGGER.error(e);
            }
            finally {
                TaskPushReqHandler.this.activeRunnableNum.decrementAndGet();
            }
        }
    }
}

