/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.handler.ipfilter;

import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelHandler;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelHandlerContext;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.ipfilter.IpFilterRule;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.ipfilter.IpFilteringHandlerImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelHandler.Sharable
public class IpFilterRuleHandler
extends IpFilteringHandlerImpl {
    private final CopyOnWriteArrayList<IpFilterRule> ipFilterRuleList = new CopyOnWriteArrayList();

    public IpFilterRuleHandler(List<IpFilterRule> newList) {
        if (newList != null) {
            this.ipFilterRuleList.addAll(newList);
        }
    }

    public IpFilterRuleHandler() {
    }

    public void add(IpFilterRule ipFilterRule) {
        if (ipFilterRule == null) {
            throw new NullPointerException("IpFilterRule can not be null");
        }
        this.ipFilterRuleList.add(ipFilterRule);
    }

    public void add(int index2, IpFilterRule ipFilterRule) {
        if (ipFilterRule == null) {
            throw new NullPointerException("IpFilterRule can not be null");
        }
        this.ipFilterRuleList.add(index2, ipFilterRule);
    }

    public void addAll(Collection<IpFilterRule> c) {
        if (c == null) {
            throw new NullPointerException("Collection can not be null");
        }
        this.ipFilterRuleList.addAll(c);
    }

    public void addAll(int index2, Collection<IpFilterRule> c) {
        if (c == null) {
            throw new NullPointerException("Collection can not be null");
        }
        this.ipFilterRuleList.addAll(index2, c);
    }

    public int addAllAbsent(Collection<IpFilterRule> c) {
        if (c == null) {
            throw new NullPointerException("Collection can not be null");
        }
        return this.ipFilterRuleList.addAllAbsent(c);
    }

    public boolean addIfAbsent(IpFilterRule ipFilterRule) {
        if (ipFilterRule == null) {
            throw new NullPointerException("IpFilterRule can not be null");
        }
        return this.ipFilterRuleList.addIfAbsent(ipFilterRule);
    }

    public void clear() {
        this.ipFilterRuleList.clear();
    }

    public boolean contains(IpFilterRule ipFilterRule) {
        if (ipFilterRule == null) {
            throw new NullPointerException("IpFilterRule can not be null");
        }
        return this.ipFilterRuleList.contains(ipFilterRule);
    }

    public boolean containsAll(Collection<IpFilterRule> c) {
        if (c == null) {
            throw new NullPointerException("Collection can not be null");
        }
        return this.ipFilterRuleList.containsAll(c);
    }

    public IpFilterRule get(int index2) {
        return this.ipFilterRuleList.get(index2);
    }

    public boolean isEmpty() {
        return this.ipFilterRuleList.isEmpty();
    }

    public void remove(IpFilterRule ipFilterRule) {
        if (ipFilterRule == null) {
            throw new NullPointerException("IpFilterRule can not be null");
        }
        this.ipFilterRuleList.remove(ipFilterRule);
    }

    public IpFilterRule remove(int index2) {
        return this.ipFilterRuleList.remove(index2);
    }

    public void removeAll(Collection<IpFilterRule> c) {
        if (c == null) {
            throw new NullPointerException("Collection can not be null");
        }
        this.ipFilterRuleList.removeAll(c);
    }

    public void retainAll(Collection<IpFilterRule> c) {
        if (c == null) {
            throw new NullPointerException("Collection can not be null");
        }
        this.ipFilterRuleList.retainAll(c);
    }

    public IpFilterRule set(int index2, IpFilterRule ipFilterRule) {
        if (ipFilterRule == null) {
            throw new NullPointerException("IpFilterRule can not be null");
        }
        return this.ipFilterRuleList.set(index2, ipFilterRule);
    }

    public int size() {
        return this.ipFilterRuleList.size();
    }

    @Override
    protected boolean accept(ChannelHandlerContext ctx, ChannelEvent e, InetSocketAddress inetSocketAddress) throws Exception {
        if (this.ipFilterRuleList.isEmpty()) {
            return true;
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        for (IpFilterRule ipFilterRule : this.ipFilterRuleList) {
            if (!ipFilterRule.contains(inetAddress)) continue;
            return ipFilterRule.isAllowRule();
        }
        return true;
    }
}

