/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.value;

import com.alibaba.schedulerx.shade.org.h2.engine.SysProperties;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.util.DateTimeUtils;
import com.alibaba.schedulerx.shade.org.h2.value.CompareMode;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;

public class ValueTime
extends Value {
    public static final int DEFAULT_PRECISION = 8;
    public static final int MAXIMUM_PRECISION = 18;
    static final int DEFAULT_SCALE = 0;
    public static final int MAXIMUM_SCALE = 9;
    private final long nanos;

    public static int getDisplaySize(int n) {
        return n == 0 ? 8 : 9 + n;
    }

    private ValueTime(long l) {
        this.nanos = l;
    }

    public static ValueTime fromNanos(long l) {
        if (!(SysProperties.UNLIMITED_TIME_RANGE || l >= 0L && l < 86400000000000L)) {
            StringBuilder stringBuilder = new StringBuilder();
            DateTimeUtils.appendTime(stringBuilder, l);
            throw DbException.get(22007, "TIME", stringBuilder.toString());
        }
        return (ValueTime)Value.cache(new ValueTime(l));
    }

    public static ValueTime get(Time time) {
        return ValueTime.fromNanos(DateTimeUtils.nanosFromDate(time.getTime()));
    }

    public static ValueTime fromMillis(long l) {
        return ValueTime.fromNanos(DateTimeUtils.nanosFromDate(l));
    }

    public static ValueTime parse(String string2) {
        try {
            return ValueTime.fromNanos(DateTimeUtils.parseTimeNanos(string2, 0, string2.length(), false));
        }
        catch (Exception exception) {
            throw DbException.get(22007, exception, "TIME", string2);
        }
    }

    public long getNanos() {
        return this.nanos;
    }

    @Override
    public Time getTime() {
        return DateTimeUtils.convertNanoToTime(this.nanos);
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(18);
        DateTimeUtils.appendTime(stringBuilder, this.nanos);
        return stringBuilder.toString();
    }

    @Override
    public String getSQL() {
        return "TIME '" + this.getString() + "'";
    }

    @Override
    public long getPrecision() {
        return 18L;
    }

    @Override
    public int getDisplaySize() {
        return 18;
    }

    @Override
    public boolean checkPrecision(long l) {
        return true;
    }

    @Override
    public Value convertScale(boolean bl, int n) {
        if (n >= 9) {
            return this;
        }
        if (n < 0) {
            throw DbException.getInvalidValueException("scale", n);
        }
        long l = this.nanos;
        long l2 = DateTimeUtils.convertScale(l, n);
        if (l2 == l) {
            return this;
        }
        if (l2 >= 86400000000000L) {
            l2 = 86399999999999L;
        }
        return ValueTime.fromNanos(l2);
    }

    @Override
    protected int compareSecure(Value value2, CompareMode compareMode) {
        return Long.compare(this.nanos, ((ValueTime)value2).nanos);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ValueTime && this.nanos == ((ValueTime)object).nanos;
    }

    @Override
    public int hashCode() {
        return (int)(this.nanos ^ this.nanos >>> 32);
    }

    @Override
    public Object getObject() {
        return this.getTime();
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setTime(n, this.getTime());
    }

    @Override
    public Value add(Value value2) {
        ValueTime valueTime = (ValueTime)value2.convertTo(9);
        return ValueTime.fromNanos(this.nanos + valueTime.getNanos());
    }

    @Override
    public Value subtract(Value value2) {
        ValueTime valueTime = (ValueTime)value2.convertTo(9);
        return ValueTime.fromNanos(this.nanos - valueTime.getNanos());
    }

    @Override
    public Value multiply(Value value2) {
        return ValueTime.fromNanos((long)((double)this.nanos * value2.getDouble()));
    }

    @Override
    public Value divide(Value value2) {
        return ValueTime.fromNanos((long)((double)this.nanos / value2.getDouble()));
    }

    @Override
    public int getSignum() {
        return Long.signum(this.nanos);
    }

    @Override
    public Value negate() {
        return ValueTime.fromNanos(-this.nanos);
    }
}

