/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.http.nio.protocol;

import com.alibaba.schedulerx.shade.org.apache.http.HttpEntity;
import com.alibaba.schedulerx.shade.org.apache.http.HttpResponse;
import com.alibaba.schedulerx.shade.org.apache.http.nio.ContentEncoder;
import com.alibaba.schedulerx.shade.org.apache.http.nio.IOControl;
import com.alibaba.schedulerx.shade.org.apache.http.nio.entity.EntityAsyncContentProducer;
import com.alibaba.schedulerx.shade.org.apache.http.nio.entity.HttpAsyncContentProducer;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.HttpContext;
import java.io.IOException;

class ErrorResponseProducer
implements HttpAsyncResponseProducer {
    private final HttpResponse response;
    private final HttpEntity entity;
    private final HttpAsyncContentProducer contentProducer;
    private final boolean keepAlive;

    ErrorResponseProducer(HttpResponse response, HttpEntity entity, boolean keepAlive2) {
        this.response = response;
        this.entity = entity;
        this.contentProducer = entity instanceof HttpAsyncContentProducer ? (HttpAsyncContentProducer)((Object)entity) : new EntityAsyncContentProducer(entity);
        this.keepAlive = keepAlive2;
    }

    public HttpResponse generateResponse() {
        if (this.keepAlive) {
            this.response.addHeader("Connection", "Keep-Alive");
        } else {
            this.response.addHeader("Connection", "Close");
        }
        this.response.setEntity(this.entity);
        return this.response;
    }

    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        this.contentProducer.produceContent(encoder, ioctrl);
    }

    public void responseCompleted(HttpContext context) {
    }

    public void failed(Exception ex) {
    }

    public void close() throws IOException {
        this.contentProducer.close();
    }
}

