/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.http.impl.nio.client;

import com.alibaba.schedulerx.shade.org.apache.commons.logging.Log;
import com.alibaba.schedulerx.shade.org.apache.commons.logging.LogFactory;
import com.alibaba.schedulerx.shade.org.apache.http.client.protocol.HttpClientContext;
import com.alibaba.schedulerx.shade.org.apache.http.client.protocol.RequestClientConnControl;
import com.alibaba.schedulerx.shade.org.apache.http.concurrent.BasicFuture;
import com.alibaba.schedulerx.shade.org.apache.http.concurrent.FutureCallback;
import com.alibaba.schedulerx.shade.org.apache.http.impl.DefaultConnectionReuseStrategy;
import com.alibaba.schedulerx.shade.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import com.alibaba.schedulerx.shade.org.apache.http.impl.nio.client.CloseableHttpAsyncClientBase;
import com.alibaba.schedulerx.shade.org.apache.http.impl.nio.client.DefaultClientExchangeHandlerImpl;
import com.alibaba.schedulerx.shade.org.apache.http.impl.nio.client.InternalClientExec;
import com.alibaba.schedulerx.shade.org.apache.http.impl.nio.client.MinimalClientExec;
import com.alibaba.schedulerx.shade.org.apache.http.nio.conn.NHttpClientConnectionManager;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.BasicHttpContext;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.HttpContext;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.ImmutableHttpProcessor;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.RequestContent;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.RequestTargetHost;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.RequestUserAgent;
import com.alibaba.schedulerx.shade.org.apache.http.util.Asserts;
import com.alibaba.schedulerx.shade.org.apache.http.util.VersionInfo;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MinimalHttpAsyncClient
extends CloseableHttpAsyncClientBase {
    private final Log log = LogFactory.getLog(this.getClass());
    private final NHttpClientConnectionManager connmgr;
    private final InternalClientExec execChain;

    public MinimalHttpAsyncClient(NHttpClientConnectionManager connmgr, ThreadFactory threadFactory) {
        super(connmgr, threadFactory);
        this.connmgr = connmgr;
        ImmutableHttpProcessor httpProcessor = new ImmutableHttpProcessor(new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(VersionInfo.getUserAgent("Apache-HttpAsyncClient", "com.alibaba.schedulerx.shade.org.apache.http.nio.client", this.getClass())));
        this.execChain = new MinimalClientExec(connmgr, httpProcessor, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
    }

    public MinimalHttpAsyncClient(NHttpClientConnectionManager connmgr) {
        this(connmgr, Executors.defaultThreadFactory());
    }

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        CloseableHttpAsyncClientBase.Status status = this.getStatus();
        Asserts.check(status == CloseableHttpAsyncClientBase.Status.ACTIVE, "Request cannot be executed; I/O reactor status: %s", new Object[]{status});
        BasicFuture<T> future2 = new BasicFuture<T>(callback);
        HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
        DefaultClientExchangeHandlerImpl<T> handler = new DefaultClientExchangeHandlerImpl<T>(this.log, requestProducer, responseConsumer, localcontext, future2, this.connmgr, this.execChain);
        try {
            handler.start();
        }
        catch (Exception ex) {
            handler.failed(ex);
        }
        return future2;
    }
}

