/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.beanutils.converters;

import com.alibaba.schedulerx.shade.org.apache.commons.beanutils.ConversionException;
import com.alibaba.schedulerx.shade.org.apache.commons.beanutils.converters.AbstractConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public abstract class NumberConverter
extends AbstractConverter {
    private static final Integer ZERO = new Integer(0);
    private static final Integer ONE = new Integer(1);
    private String pattern;
    private boolean allowDecimals;
    private boolean useLocaleFormat;
    private Locale locale;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;

    public NumberConverter(boolean allowDecimals) {
        this.allowDecimals = allowDecimals;
    }

    public NumberConverter(boolean allowDecimals, Object defaultValue) {
        this.allowDecimals = allowDecimals;
        this.setDefaultValue(defaultValue);
    }

    public boolean isAllowDecimals() {
        return this.allowDecimals;
    }

    public void setUseLocaleFormat(boolean useLocaleFormat) {
        this.useLocaleFormat = useLocaleFormat;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.setUseLocaleFormat(true);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setUseLocaleFormat(true);
    }

    protected String convertToString(Object value2) throws Throwable {
        String result2 = null;
        if (this.useLocaleFormat && value2 instanceof Number) {
            NumberFormat format2 = this.getFormat();
            format2.setGroupingUsed(false);
            result2 = format2.format(value2);
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Converted  to String using format '" + result2 + "'");
            }
        } else {
            result2 = value2.toString();
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Converted  to String using toString() '" + result2 + "'");
            }
        }
        return result2;
    }

    protected Object convertToType(Class targetType, Object value2) throws Throwable {
        Class<?> sourceType = value2.getClass();
        if (value2 instanceof Number) {
            return this.toNumber(sourceType, targetType, (Number)value2);
        }
        if (value2 instanceof Boolean) {
            return this.toNumber(sourceType, targetType, (Boolean)value2 != false ? ONE : ZERO);
        }
        if (value2 instanceof Date && (class$java$lang$Long == null ? (class$java$lang$Long = NumberConverter.class$("java.lang.Long")) : class$java$lang$Long).equals(targetType)) {
            return new Long(((Date)value2).getTime());
        }
        if (value2 instanceof Calendar && (class$java$lang$Long == null ? (class$java$lang$Long = NumberConverter.class$("java.lang.Long")) : class$java$lang$Long).equals(targetType)) {
            return new Long(((Calendar)value2).getTime().getTime());
        }
        String stringValue = value2.toString().trim();
        if (stringValue.length() == 0) {
            return this.handleMissing(targetType);
        }
        Number number2 = null;
        if (this.useLocaleFormat) {
            NumberFormat format2 = this.getFormat();
            number2 = this.parse(sourceType, targetType, stringValue, format2);
        } else {
            if (this.log().isDebugEnabled()) {
                this.log().debug("    No NumberFormat, using default conversion");
            }
            number2 = this.toNumber(sourceType, targetType, stringValue);
        }
        return this.toNumber(sourceType, targetType, number2);
    }

    private Number toNumber(Class sourceType, Class targetType, Number value2) {
        if (targetType.equals(value2.getClass())) {
            return value2;
        }
        if (targetType.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = NumberConverter.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            long longValue = value2.longValue();
            if (longValue > 127L) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value2 + "' is too large for " + this.toString(targetType));
            }
            if (longValue < -128L) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value2 + "' is too small " + this.toString(targetType));
            }
            return new Byte(value2.byteValue());
        }
        if (targetType.equals(class$java$lang$Short == null ? (class$java$lang$Short = NumberConverter.class$("java.lang.Short")) : class$java$lang$Short)) {
            long longValue = value2.longValue();
            if (longValue > 32767L) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value2 + "' is too large for " + this.toString(targetType));
            }
            if (longValue < -32768L) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value2 + "' is too small " + this.toString(targetType));
            }
            return new Short(value2.shortValue());
        }
        if (targetType.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = NumberConverter.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            long longValue = value2.longValue();
            if (longValue > Integer.MAX_VALUE) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value2 + "' is too large for " + this.toString(targetType));
            }
            if (longValue < Integer.MIN_VALUE) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value2 + "' is too small " + this.toString(targetType));
            }
            return new Integer(value2.intValue());
        }
        if (targetType.equals(class$java$lang$Long == null ? (class$java$lang$Long = NumberConverter.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(value2.longValue());
        }
        if (targetType.equals(class$java$lang$Float == null ? (class$java$lang$Float = NumberConverter.class$("java.lang.Float")) : class$java$lang$Float)) {
            if (value2.doubleValue() > 3.4028234663852886E38) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value2 + "' is too large for " + this.toString(targetType));
            }
            return new Float(value2.floatValue());
        }
        if (targetType.equals(class$java$lang$Double == null ? (class$java$lang$Double = NumberConverter.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(value2.doubleValue());
        }
        if (targetType.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberConverter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            if (value2 instanceof Float || value2 instanceof Double) {
                return new BigDecimal(value2.toString());
            }
            if (value2 instanceof BigInteger) {
                return new BigDecimal((BigInteger)value2);
            }
            return BigDecimal.valueOf(value2.longValue());
        }
        if (targetType.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumberConverter.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            if (value2 instanceof BigDecimal) {
                return ((BigDecimal)value2).toBigInteger();
            }
            return BigInteger.valueOf(value2.longValue());
        }
        String msg = this.toString(this.getClass()) + " cannot handle conversion to '" + this.toString(targetType) + "'";
        if (this.log().isWarnEnabled()) {
            this.log().warn("    " + msg);
        }
        throw new ConversionException(msg);
    }

    private Number toNumber(Class sourceType, Class targetType, String value2) {
        if (targetType.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = NumberConverter.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte(value2);
        }
        if (targetType.equals(class$java$lang$Short == null ? (class$java$lang$Short = NumberConverter.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short(value2);
        }
        if (targetType.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = NumberConverter.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer(value2);
        }
        if (targetType.equals(class$java$lang$Long == null ? (class$java$lang$Long = NumberConverter.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(value2);
        }
        if (targetType.equals(class$java$lang$Float == null ? (class$java$lang$Float = NumberConverter.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(value2);
        }
        if (targetType.equals(class$java$lang$Double == null ? (class$java$lang$Double = NumberConverter.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(value2);
        }
        if (targetType.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberConverter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return new BigDecimal(value2);
        }
        if (targetType.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumberConverter.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return new BigInteger(value2);
        }
        String msg = this.toString(this.getClass()) + " cannot handle conversion from '" + this.toString(sourceType) + "' to '" + this.toString(targetType) + "'";
        if (this.log().isWarnEnabled()) {
            this.log().warn("    " + msg);
        }
        throw new ConversionException(msg);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toString(this.getClass()));
        buffer.append("[UseDefault=");
        buffer.append(this.isUseDefault());
        buffer.append(", UseLocaleFormat=");
        buffer.append(this.useLocaleFormat);
        if (this.pattern != null) {
            buffer.append(", Pattern=");
            buffer.append(this.pattern);
        }
        if (this.locale != null) {
            buffer.append(", Locale=");
            buffer.append(this.locale);
        }
        buffer.append(']');
        return buffer.toString();
    }

    private NumberFormat getFormat() {
        NumberFormat format2 = null;
        if (this.pattern != null) {
            if (this.locale == null) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("    Using pattern '" + this.pattern + "'");
                }
                format2 = new DecimalFormat(this.pattern);
            } else {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("    Using pattern '" + this.pattern + "'" + " with Locale[" + this.locale + "]");
                }
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(this.locale);
                format2 = new DecimalFormat(this.pattern, symbols);
            }
        } else if (this.locale == null) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Using default Locale format");
            }
            format2 = NumberFormat.getInstance();
        } else {
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Using Locale[" + this.locale + "] format");
            }
            format2 = NumberFormat.getInstance(this.locale);
        }
        if (!this.allowDecimals) {
            format2.setParseIntegerOnly(true);
        }
        return format2;
    }

    private Number parse(Class sourceType, Class targetType, String value2, NumberFormat format2) {
        ParsePosition pos = new ParsePosition(0);
        Number parsedNumber = format2.parse(value2, pos);
        if (pos.getErrorIndex() >= 0 || pos.getIndex() != value2.length() || parsedNumber == null) {
            String msg = "Error converting from '" + this.toString(sourceType) + "' to '" + this.toString(targetType) + "'";
            if (format2 instanceof DecimalFormat) {
                msg = msg + " using pattern '" + ((DecimalFormat)format2).toPattern() + "'";
            }
            if (this.locale != null) {
                msg = msg + " for locale=[" + this.locale + "]";
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("    " + msg);
            }
            throw new ConversionException(msg);
        }
        return parsedNumber;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

