/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.javassist.tools.rmi;

import com.alibaba.schedulerx.shade.javassist.CannotCompileException;
import com.alibaba.schedulerx.shade.javassist.ClassPool;
import com.alibaba.schedulerx.shade.javassist.NotFoundException;
import com.alibaba.schedulerx.shade.javassist.tools.rmi.ExportedObject;
import com.alibaba.schedulerx.shade.javassist.tools.rmi.RemoteRef;
import com.alibaba.schedulerx.shade.javassist.tools.rmi.StubGenerator;
import com.alibaba.schedulerx.shade.javassist.tools.web.BadHttpRequest;
import com.alibaba.schedulerx.shade.javassist.tools.web.Webserver;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public class AppletServer
extends Webserver {
    private StubGenerator stubGen;
    private Hashtable exportedNames = new Hashtable();
    private Vector exportedObjects = new Vector();
    private static final byte[] okHeader = "HTTP/1.0 200 OK\r\n\r\n".getBytes();

    public AppletServer(String port) throws IOException, NotFoundException, CannotCompileException {
        this(Integer.parseInt(port));
    }

    public AppletServer(int port) throws IOException, NotFoundException, CannotCompileException {
        this(ClassPool.getDefault(), new StubGenerator(), port);
    }

    public AppletServer(int port, ClassPool src) throws IOException, NotFoundException, CannotCompileException {
        this(new ClassPool(src), new StubGenerator(), port);
    }

    private AppletServer(ClassPool loader, StubGenerator gen, int port) throws IOException, NotFoundException, CannotCompileException {
        super(port);
        this.stubGen = gen;
        this.addTranslator(loader, gen);
    }

    @Override
    public void run() {
        super.run();
    }

    public synchronized int exportObject(String name, Object obj) throws CannotCompileException {
        Class<?> clazz = obj.getClass();
        ExportedObject eo = new ExportedObject();
        eo.object = obj;
        eo.methods = clazz.getMethods();
        this.exportedObjects.addElement(eo);
        eo.identifier = this.exportedObjects.size() - 1;
        if (name != null) {
            this.exportedNames.put(name, eo);
        }
        try {
            this.stubGen.makeProxyClass(clazz);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        return eo.identifier;
    }

    @Override
    public void doReply(InputStream in2, OutputStream out, String cmd) throws IOException, BadHttpRequest {
        if (cmd.startsWith("POST /rmi ")) {
            this.processRMI(in2, out);
        } else if (cmd.startsWith("POST /lookup ")) {
            this.lookupName(cmd, in2, out);
        } else {
            super.doReply(in2, out, cmd);
        }
    }

    private void processRMI(InputStream ins2, OutputStream outs2) throws IOException {
        ObjectInputStream in2 = new ObjectInputStream(ins2);
        int objectId = in2.readInt();
        int methodId = in2.readInt();
        Exception err2 = null;
        Object rvalue = null;
        try {
            ExportedObject eo = (ExportedObject)this.exportedObjects.elementAt(objectId);
            Object[] args = this.readParameters(in2);
            rvalue = this.convertRvalue(eo.methods[methodId].invoke(eo.object, args));
        }
        catch (Exception e) {
            err2 = e;
            this.logging2(e.toString());
        }
        outs2.write(okHeader);
        ObjectOutputStream out = new ObjectOutputStream(outs2);
        if (err2 != null) {
            out.writeBoolean(false);
            out.writeUTF(err2.toString());
        } else {
            try {
                out.writeBoolean(true);
                out.writeObject(rvalue);
            }
            catch (NotSerializableException e) {
                this.logging2(e.toString());
            }
            catch (InvalidClassException e) {
                this.logging2(e.toString());
            }
        }
        out.flush();
        out.close();
        in2.close();
    }

    private Object[] readParameters(ObjectInputStream in2) throws IOException, ClassNotFoundException {
        int n = in2.readInt();
        Object[] args = new Object[n];
        for (int i = 0; i < n; ++i) {
            Object a = in2.readObject();
            if (a instanceof RemoteRef) {
                RemoteRef ref = (RemoteRef)a;
                ExportedObject eo = (ExportedObject)this.exportedObjects.elementAt(ref.oid);
                a = eo.object;
            }
            args[i] = a;
        }
        return args;
    }

    private Object convertRvalue(Object rvalue) throws CannotCompileException {
        if (rvalue == null) {
            return null;
        }
        String classname = rvalue.getClass().getName();
        if (this.stubGen.isProxyClass(classname)) {
            return new RemoteRef(this.exportObject(null, rvalue), classname);
        }
        return rvalue;
    }

    private void lookupName(String cmd, InputStream ins2, OutputStream outs2) throws IOException {
        ObjectInputStream in2 = new ObjectInputStream(ins2);
        String name = DataInputStream.readUTF(in2);
        ExportedObject found = (ExportedObject)this.exportedNames.get(name);
        outs2.write(okHeader);
        ObjectOutputStream out = new ObjectOutputStream(outs2);
        if (found == null) {
            this.logging2(name + "not found.");
            out.writeInt(-1);
            out.writeUTF("error");
        } else {
            this.logging2(name);
            out.writeInt(found.identifier);
            out.writeUTF(found.object.getClass().getName());
        }
        out.flush();
        out.close();
        in2.close();
    }
}

