/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.google.gson.internal.bind;

import com.alibaba.schedulerx.shade.com.google.gson.Gson;
import com.alibaba.schedulerx.shade.com.google.gson.TypeAdapter;
import com.alibaba.schedulerx.shade.com.google.gson.TypeAdapterFactory;
import com.alibaba.schedulerx.shade.com.google.gson.internal.$Gson$Types;
import com.alibaba.schedulerx.shade.com.google.gson.internal.ConstructorConstructor;
import com.alibaba.schedulerx.shade.com.google.gson.internal.ObjectConstructor;
import com.alibaba.schedulerx.shade.com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.alibaba.schedulerx.shade.com.google.gson.reflect.TypeToken;
import com.alibaba.schedulerx.shade.com.google.gson.stream.JsonReader;
import com.alibaba.schedulerx.shade.com.google.gson.stream.JsonToken;
import com.alibaba.schedulerx.shade.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;

public final class CollectionTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;

    public CollectionTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.constructorConstructor = constructorConstructor;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        Class<T> rawType = typeToken.getRawType();
        if (!Collection.class.isAssignableFrom(rawType)) {
            return null;
        }
        Type elementType = $Gson$Types.getCollectionElementType(type, rawType);
        TypeAdapter<?> elementTypeAdapter = gson.getAdapter(TypeToken.get(elementType));
        ObjectConstructor<T> constructor = this.constructorConstructor.get(typeToken);
        Adapter result2 = new Adapter(gson, elementType, elementTypeAdapter, constructor);
        return result2;
    }

    private static final class Adapter<E>
    extends TypeAdapter<Collection<E>> {
        private final TypeAdapter<E> elementTypeAdapter;
        private final ObjectConstructor<? extends Collection<E>> constructor;

        public Adapter(Gson context, Type elementType, TypeAdapter<E> elementTypeAdapter, ObjectConstructor<? extends Collection<E>> constructor) {
            this.elementTypeAdapter = new TypeAdapterRuntimeTypeWrapper<E>(context, elementTypeAdapter, elementType);
            this.constructor = constructor;
        }

        @Override
        public Collection<E> read(JsonReader in2) throws IOException {
            if (in2.peek() == JsonToken.NULL) {
                in2.nextNull();
                return null;
            }
            Collection<E> collection = this.constructor.construct();
            in2.beginArray();
            while (in2.hasNext()) {
                E instance = this.elementTypeAdapter.read(in2);
                collection.add(instance);
            }
            in2.endArray();
            return collection;
        }

        @Override
        public void write(JsonWriter out, Collection<E> collection) throws IOException {
            if (collection == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (E element : collection) {
                this.elementTypeAdapter.write(out, element);
            }
            out.endArray();
        }
    }
}

