/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util.Utils;
import com.alibaba.schedulerx.shade.org.apache.commons.codec.binary.Base64;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class DigestUtils {
    private DigestUtils() {
    }

    public static String md5Crypt(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            String res = new BigInteger(1, md.digest(bytes)).toString(16).toUpperCase();
            StringBuilder zeros = new StringBuilder();
            int i = 0;
            while (i + res.length() < 32) {
                zeros.append("0");
                ++i;
            }
            return zeros.toString() + res;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Not Supported signature method MD5", e);
        }
    }

    public static void addSignature(String accessKeyId, String accessKey, String verb, Map<String, String> headers, String resourceUri, Map<String, String> urlParams) {
        StringBuilder builder = new StringBuilder();
        builder.append(verb).append("\n");
        builder.append(Utils.getOrEmpty(headers, "Content-MD5")).append("\n");
        builder.append(Utils.getOrEmpty(headers, "Content-Type")).append("\n");
        builder.append(Utils.getOrEmpty(headers, "Date")).append("\n");
        builder.append(DigestUtils.headersToString(headers)).append("\n");
        builder.append(resourceUri);
        if (!urlParams.isEmpty()) {
            builder.append("?");
            builder.append(DigestUtils.urlParametersToString(urlParams));
        }
        String signature = DigestUtils.encode(accessKey, builder.toString());
        headers.put("Authorization", "LOG " + accessKeyId + ":" + signature);
    }

    private static String urlParametersToString(Map<String, String> paras) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(paras);
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : treeMap.entrySet()) {
            if (builder.length() > 0) {
                builder.append("&");
            }
            builder.append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
        return builder.toString();
    }

    private static String headersToString(Map<String, String> headers) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(headers);
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : treeMap.entrySet()) {
            if (!((String)entry.getKey()).startsWith("x-log-") && !((String)entry.getKey()).startsWith("x-acs-")) continue;
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append((String)entry.getKey()).append(":").append((String)entry.getValue());
        }
        return builder.toString();
    }

    private static String encode(String accessKey, String data) {
        try {
            byte[] keyBytes = accessKey.getBytes("UTF-8");
            byte[] dataBytes = data.getBytes("UTF-8");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(keyBytes, "HmacSHA1"));
            return new String(Base64.encodeBase64(mac.doFinal(dataBytes)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Not supported encoding method UTF-8", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Not supported signature method hmac-sha1", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Failed to calculate the signature", e);
        }
    }
}

