/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.sdk.request;

import com.alibaba.schedulerx.common.domain.enums.ResponseCodeEnum;
import com.alibaba.schedulerx.common.exception.RequestCheckException;
import com.alibaba.schedulerx.common.sdk.common.HttpJobConfig;
import com.alibaba.schedulerx.common.sdk.common.ParamValidate;
import com.alibaba.schedulerx.common.sdk.request.BaseRequest;
import com.alibaba.schedulerx.common.sdk.response.CreateJobResponse;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;

public class CreateHttpJobRequest
extends BaseRequest<CreateJobResponse> {
    private HttpJobConfig httpJobConfig;

    public CreateHttpJobRequest(HttpJobConfig httpJobConfig) {
        this.httpJobConfig = httpJobConfig;
        super.getParameterMap().putAll(httpJobConfig.getParamMap());
    }

    @Override
    public Class<CreateJobResponse> getResponseClass() {
        return CreateJobResponse.class;
    }

    @Override
    public String getUrlPath() {
        return "/openapi/v1/job/create";
    }

    @Override
    public void preRun() throws RequestCheckException {
        if (this.httpJobConfig != null) {
            ParamValidate.doValidator(this.httpJobConfig);
            if ((this.httpJobConfig.getTimeConfig().getTimeType() == 1 || this.httpJobConfig.getTimeConfig().getTimeType() == 3) && StringUtils.isBlank(this.httpJobConfig.getTimeConfig().getTimeExpression())) {
                throw new RequestCheckException(ResponseCodeEnum.PARAM_CHECK_ERROR.getCode(), "cron or fix_rate timeType must set timeExpression");
            }
        } else {
            throw new RequestCheckException(ResponseCodeEnum.PARAM_CHECK_ERROR.getCode(), "httpJobConfig is null");
        }
    }
}

