/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.sdk.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.schedulerx.common.domain.AppGroupAlarmModel;
import com.alibaba.schedulerx.common.domain.ContactInfo;
import com.alibaba.schedulerx.common.domain.MetricsThresholdModel;
import com.alibaba.schedulerx.common.exception.RequestCheckException;
import com.alibaba.schedulerx.common.sdk.common.MonitorConfig;
import com.alibaba.schedulerx.common.sdk.request.BaseRequest;
import com.alibaba.schedulerx.common.sdk.response.CreateAppGroupResponse;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import java.util.List;

public class CreateAppGroupRequest
extends BaseRequest<CreateAppGroupResponse> {
    private String appName;
    private String description;
    private Integer maxJobs;
    private String groupId;
    private String alarmJson;
    private String metricsThresholdJson;
    private String namespaceName;
    private List<ContactInfo> contacts;
    private MonitorConfig monitorConfig;
    private Integer maxConcurrency;

    public Integer getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public void setMaxConcurrency(Integer maxConcurrency) {
        super.getParameterMap().put("maxConcurrency", maxConcurrency);
        this.maxConcurrency = maxConcurrency;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        super.getParameterMap().put("appName", appName);
        this.appName = appName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        super.getParameterMap().put("desc", description);
        this.description = description;
    }

    public Integer getMaxJobs() {
        return this.maxJobs;
    }

    public void setMaxJobs(Integer maxJobs) {
        super.getParameterMap().put("maxJobs", maxJobs);
        this.maxJobs = maxJobs;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public void setGroupId(String groupId) {
        super.getParameterMap().put("groupId", groupId);
        this.groupId = groupId;
    }

    public String getAlarmJson() {
        return this.alarmJson;
    }

    public void setAlarmJson(String alarmJson) {
        super.getParameterMap().put("alarmJson", StringUtils.isBlank(alarmJson) ? JSON.toJSONString((Object)new AppGroupAlarmModel()) : alarmJson);
        this.alarmJson = alarmJson;
    }

    public String getMetricsThresholdJson() {
        return this.metricsThresholdJson;
    }

    public void setMetricsThresholdJson(String metricsThresholdJson) {
        super.getParameterMap().put("metricsThresholdJson", StringUtils.isBlank(metricsThresholdJson) ? JSON.toJSONString((Object)MetricsThresholdModel.DEFAULT) : metricsThresholdJson);
        this.metricsThresholdJson = metricsThresholdJson;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public void setNamespaceName(String namespaceName) {
        this.namespaceName = namespaceName;
    }

    @Override
    public Class<CreateAppGroupResponse> getResponseClass() {
        return CreateAppGroupResponse.class;
    }

    @Override
    public String getUrlPath() {
        return "/openapi/v1/group/create";
    }

    public List<ContactInfo> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<ContactInfo> contacts) {
        super.getParameterMap().put("contacts", JsonUtil.toJson(contacts));
        this.contacts = contacts;
    }

    public MonitorConfig getMonitorConfig() {
        return this.monitorConfig;
    }

    public void setMonitorConfig(MonitorConfig monitorConfig) {
        super.getParameterMap().put("monitorConfig", monitorConfig);
        this.monitorConfig = monitorConfig;
    }

    @Override
    public void preRun() throws RequestCheckException {
        if (this.getAlarmJson() == null) {
            this.setAlarmJson(null);
        }
        if (this.getMetricsThresholdJson() == null) {
            this.setMetricsThresholdJson(null);
        }
    }
}

