/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.annotation.JSONField;
import com.aliyun.openservices.log.common.HttpNotification;
import com.aliyun.openservices.log.common.NotificationType;
import com.aliyun.openservices.log.http.client.HttpMethod;
import com.aliyun.openservices.log.util.JsonUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class WebhookNotification
extends HttpNotification {
    @JSONField
    private Map<String, String> headers;
    @JSONField
    private HttpMethod method;

    public WebhookNotification() {
        super(NotificationType.WEBHOOK);
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    private static Map<String, String> parseHeaders(JSONObject object) {
        if (!object.has("headers")) {
            return Collections.emptyMap();
        }
        JSONObject value = object.getJSONObject("headers");
        if (value.isNullObject()) {
            return Collections.emptyMap();
        }
        JSONArray names = value.names();
        HashMap<String, String> headers = new HashMap<String, String>(names.size());
        for (int i = 0; i < names.size(); ++i) {
            String header = names.getString(i);
            headers.put(header, value.getString(header));
        }
        return headers;
    }

    @Override
    public void deserialize(JSONObject value) {
        super.deserialize(value);
        String method = JsonUtils.readOptionalString(value, "method");
        if (method != null) {
            this.setMethod(HttpMethod.fromString(method));
        }
        this.setHeaders(WebhookNotification.parseHeaders(value));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebhookNotification that = (WebhookNotification)o;
        if (this.getMethod() != that.getMethod()) {
            return false;
        }
        return this.getHeaders() != null ? this.getHeaders().equals(that.getHeaders()) : that.getHeaders() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getMethod() != null ? this.getMethod().hashCode() : 0);
        result = 31 * result + (this.getHeaders() != null ? this.getHeaders().hashCode() : 0);
        return result;
    }
}

