/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch;

import com.aliyun.opensearch.OpenSearchClient;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.base.Joiner;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.base.Preconditions;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.collect.Maps;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.Header;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.params.BasicHttpParams;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchClientException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchException;
import com.aliyun.opensearch.sdk.generated.search.OpenSearchSearcherService;
import com.aliyun.opensearch.sdk.generated.search.SearchParams;
import com.aliyun.opensearch.sdk.generated.search.general.SearchResult;
import com.aliyun.opensearch.search.SearchParamsBuilder;
import com.aliyun.opensearch.search.SearchResultDebug;
import com.aliyun.opensearch.search.UrlParamsBuilder;
import com.aliyun.opensearch.util.HttpResult;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SearcherClient
implements OpenSearchSearcherService.Iface {
    private OpenSearchClient serviceClient;
    private static final String SEARCH_API_PATH = "/apps/{app_name}/search";
    private static final String SUGGEST_API_PATH = "/suggests/{app_name}/{suggest_name}/search";

    public SearcherClient(OpenSearchClient serviceClient) {
        this.serviceClient = serviceClient;
    }

    public SearchResult execute(SearchParamsBuilder searchParamsBuilder) throws OpenSearchException, OpenSearchClientException {
        return this.execute(searchParamsBuilder.build());
    }

    @Override
    public SearchResult execute(SearchParams searchParams) throws OpenSearchException, OpenSearchClientException {
        UrlParamsBuilder urlParamsBuilder = new UrlParamsBuilder(searchParams);
        Map<String, String> params = SearcherClient.toMap(urlParamsBuilder.getHttpParams());
        String requestPath = SearcherClient.parseApiPathTemplate(searchParams);
        String response = this.serviceClient.call(requestPath, params, "GET");
        return new SearchResult(response);
    }

    public SearchResultDebug executeDebug(SearchParams searchParams) throws OpenSearchException, OpenSearchClientException {
        URL requestUrl;
        UrlParamsBuilder urlParamsBuilder = new UrlParamsBuilder(searchParams);
        Map<String, String> params = SearcherClient.toMap(urlParamsBuilder.getHttpParams());
        String requestPath = SearcherClient.parseApiPathTemplate(searchParams);
        HttpResult httpResult = this.serviceClient.authAndCall(requestPath, params, "GET");
        SearchResult searchResult = new SearchResult(httpResult.getResult());
        try {
            requestUrl = httpResult.getRequestUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new OpenSearchClientException(e);
        }
        List<Header> requestHeaders = httpResult.getRequestHeaders();
        List<Header> responseHeaders = httpResult.getResponseHeaders();
        return new SearchResultDebug(searchResult, requestUrl, requestHeaders, responseHeaders, httpResult.getCode(), httpResult.getReason());
    }

    private static Map<String, String> toMap(BasicHttpParams httpParams) {
        LinkedHashMap<String, String> map = Maps.newLinkedHashMap();
        Set<String> names = httpParams.getNames();
        for (String name : names) {
            map.put(name, httpParams.getParameter(name).toString());
        }
        return map;
    }

    private static String parseApiPathTemplate(SearchParams searchParams) {
        String path;
        List<String> appNames = searchParams.getConfig().getAppNames();
        Preconditions.checkArgument(!appNames.isEmpty(), "at least one app name or id should be specified.");
        Preconditions.checkNotNull(appNames);
        Preconditions.checkArgument(appNames.size() >= 1);
        String app_name = Joiner.on(',').join(appNames);
        if (searchParams.isSetSuggest()) {
            String suggestName = searchParams.getSuggest().getSuggestName();
            path = SUGGEST_API_PATH.replaceAll("\\{app_name\\}", app_name).replaceAll("\\{suggest_name\\}", suggestName);
        } else {
            path = SEARCH_API_PATH.replaceAll("\\{app_name\\}", app_name);
        }
        return path;
    }
}

