/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch;

import com.aliyun.opensearch.OpenSearchClient;
import com.aliyun.opensearch.client.ResourceClient;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONArray;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONObject;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchClientException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchResult;
import com.aliyun.opensearch.sdk.generated.data_collection.Command;
import com.aliyun.opensearch.sdk.generated.data_collection.DataCollectionService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DataCollectionClient
implements DataCollectionService.Iface {
    private static final String DATA_COLLECTION_SDK_TYPE = "opensearch_sdk";
    private ResourceClient resourceClient;
    private JSONArray docBuffer = new JSONArray();

    public DataCollectionClient(OpenSearchClient client) {
        this.resourceClient = new ResourceClient("/app-groups", client);
    }

    public void add(Map<String, Object> fields) {
        JSONObject record = new JSONObject();
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            record.put(entry.getKey(), entry.getValue());
        }
        Map<String, Object> internalFields = this.getInternalFields();
        for (Map.Entry<String, Object> entry : internalFields.entrySet()) {
            record.put(entry.getKey(), entry.getValue());
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("fields", record);
        jSONObject.put("cmd", Command.ADD);
        this.docBuffer.put(jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSearchResult commit(String searchAppName, String dataCollectionName, String dataCollectionType) throws OpenSearchException, OpenSearchClientException {
        OpenSearchResult result;
        try {
            result = this.doPush(this.docBuffer.toString(), searchAppName, dataCollectionName, dataCollectionType);
        }
        finally {
            this.docBuffer = new JSONArray();
        }
        return result;
    }

    @Override
    public OpenSearchResult push(String docJson, String searchAppName, String dataCollectionName, String dataCollectionType) throws OpenSearchException, OpenSearchClientException {
        JSONArray docJsonArray = new JSONArray(docJson);
        int length = docJsonArray.length();
        Map<String, Object> internalFields = this.getInternalFields();
        for (int i = 0; i < length; ++i) {
            JSONObject fields = docJsonArray.getJSONObject(i).getJSONObject("fields");
            for (Map.Entry<String, Object> entry : internalFields.entrySet()) {
                fields.put(entry.getKey(), entry.getValue());
            }
        }
        return this.doPush(docJsonArray.toString(), searchAppName, dataCollectionName, dataCollectionType);
    }

    private OpenSearchResult doPush(String docJson, String searchAppName, String dataCollectionName, String dataCollectionType) throws OpenSearchException, OpenSearchClientException {
        return this.resourceClient.post(this.createPushPath(searchAppName, dataCollectionName, dataCollectionType), docJson);
    }

    private String createPushPath(String searchAppName, String dataCollectionName, String dataCollectionType) {
        return String.format("/%s/data-collections/%s/data-collection-type/%s/actions/bulk", searchAppName, dataCollectionName, dataCollectionType);
    }

    private Map<String, Object> getInternalFields() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        HashMap<String, Object> internalFields = new HashMap<String, Object>();
        internalFields.put("sdk_type", DATA_COLLECTION_SDK_TYPE);
        internalFields.put("sdk_version", "3.4.1");
        internalFields.put("reach_time", sdf.format(new Date()));
        return internalFields;
    }
}

