/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.handler.cluster;

import com.alibaba.csp.sentinel.cluster.ClusterStateManager;
import com.alibaba.csp.sentinel.cluster.client.TokenClientProvider;
import com.alibaba.csp.sentinel.cluster.server.EmbeddedClusterTokenServerProvider;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.log.RecordLog;

@CommandMapping(name="setClusterMode", desc="set cluster mode, accept param: mode={0|1} 0:client mode 1:server mode")
public class ModifyClusterModeCommandHandler
implements CommandHandler<String> {
    @Override
    public CommandResponse<String> handle(CommandRequest request) {
        try {
            int mode = Integer.valueOf(request.getParam("mode"));
            if (mode == 0 && !TokenClientProvider.isClientSpiAvailable()) {
                return CommandResponse.ofFailure(new IllegalStateException("token client mode not available: no SPI found"));
            }
            if (mode == 1 && !this.isClusterServerSpiAvailable()) {
                return CommandResponse.ofFailure(new IllegalStateException("token server mode not available: no SPI found"));
            }
            RecordLog.info((String)("[ModifyClusterModeCommandHandler] Modifying cluster mode to: " + mode), (Object[])new Object[0]);
            ClusterStateManager.applyState((Integer)mode);
            return CommandResponse.ofSuccess("success");
        }
        catch (NumberFormatException ex) {
            return CommandResponse.ofFailure(new IllegalArgumentException("invalid parameter"));
        }
        catch (Exception ex) {
            return CommandResponse.ofFailure(ex);
        }
    }

    private boolean isClusterServerSpiAvailable() {
        return EmbeddedClusterTokenServerProvider.isServerSpiAvailable();
    }
}

