/*
 * Decompiled with CFR 0.152.
 */
package cn.springcloud.feign;

import cn.springcloud.feign.VenusRequestInterceptor;
import cn.springcloud.feign.VenusSpringMvcContract;
import feign.Feign;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.method.annotation.AbstractNamedValueMethodArgumentResolver;
import org.springframework.web.method.annotation.RequestHeaderMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.PathVariableMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;
import org.springframework.web.servlet.mvc.method.annotation.ServletCookieValueMethodArgumentResolver;

@Configuration
@ConditionalOnClass(value={Feign.class})
public class VenusFeignAutoConfig {
    @Autowired
    private RequestMappingHandlerAdapter adapter;
    @Autowired
    private ConfigurableBeanFactory beanFactory;

    @Bean
    public VenusRequestInterceptor feignRequestInterceptor() {
        return new VenusRequestInterceptor();
    }

    @Bean
    public VenusSpringMvcContract feignSpringMvcContract(@Autowired(required=false) List<AnnotatedParameterProcessor> parameterProcessors, ConversionService conversionService) {
        if (null == parameterProcessors) {
            parameterProcessors = new ArrayList<AnnotatedParameterProcessor>();
        }
        return new VenusSpringMvcContract(parameterProcessors, conversionService);
    }

    public static MethodParameter interfaceMethodParameter(MethodParameter parameter, Class annotationType) {
        if (!parameter.hasParameterAnnotation(annotationType)) {
            for (Class<?> itf : parameter.getDeclaringClass().getInterfaces()) {
                try {
                    Method method = itf.getMethod(parameter.getMethod().getName(), parameter.getMethod().getParameterTypes());
                    MethodParameter itfParameter = new MethodParameter(method, parameter.getParameterIndex());
                    if (itfParameter.hasParameterAnnotation(annotationType)) {
                        return itfParameter;
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
        }
        return parameter;
    }

    @PostConstruct
    public void modifyArgumentResolvers() {
        ArrayList<Object> list = new ArrayList<Object>(this.adapter.getArgumentResolvers());
        list.add(0, new PathVariableMethodArgumentResolver(){

            public boolean supportsParameter(MethodParameter parameter) {
                return super.supportsParameter(VenusFeignAutoConfig.interfaceMethodParameter(parameter, PathVariable.class));
            }

            protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
                return super.createNamedValueInfo(VenusFeignAutoConfig.interfaceMethodParameter(parameter, PathVariable.class));
            }
        });
        list.add(0, new RequestHeaderMethodArgumentResolver(this.beanFactory){

            public boolean supportsParameter(MethodParameter parameter) {
                return super.supportsParameter(VenusFeignAutoConfig.interfaceMethodParameter(parameter, RequestHeader.class));
            }

            protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
                return super.createNamedValueInfo(VenusFeignAutoConfig.interfaceMethodParameter(parameter, RequestHeader.class));
            }
        });
        list.add(0, new ServletCookieValueMethodArgumentResolver(this.beanFactory){

            public boolean supportsParameter(MethodParameter parameter) {
                return super.supportsParameter(VenusFeignAutoConfig.interfaceMethodParameter(parameter, CookieValue.class));
            }

            protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
                return super.createNamedValueInfo(VenusFeignAutoConfig.interfaceMethodParameter(parameter, CookieValue.class));
            }
        });
        list.add(0, new RequestResponseBodyMethodProcessor(this.adapter.getMessageConverters()){

            public boolean supportsParameter(MethodParameter parameter) {
                return super.supportsParameter(VenusFeignAutoConfig.interfaceMethodParameter(parameter, RequestBody.class));
            }

            protected void validateIfApplicable(WebDataBinder binder, MethodParameter methodParam) {
                super.validateIfApplicable(binder, VenusFeignAutoConfig.interfaceMethodParameter(methodParam, Valid.class));
            }
        });
        this.adapter.setArgumentResolvers(list);
    }
}

