/*
 * Decompiled with CFR 0.152.
 */
package cn.bizvane.rocketmq.spring.core.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.autoconfigure.RocketMQProperties;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumeMode;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerBean;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import cn.bizvane.rocketmq.spring.exception.ConsumerRegisterException;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.client.consumer.rebalance.AllocateMessageQueueAveragelyByCircle;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ConsumerAnnotationBean
implements InitializingBean,
ConsumerBean {
    private static final Logger log = LoggerFactory.getLogger(ConsumerAnnotationBean.class);
    List<DefaultMQPushConsumer> consumerList = new ArrayList<DefaultMQPushConsumer>();
    private RocketMQProperties properties;
    private ApplicationContext ctx;
    private MessageListenerOrderly listenerOrderly;
    private MessageListenerConcurrently listenerConcurrently;
    private boolean running;
    final String SUBSCRIBE_SPLITTER = " || ";

    public ConsumerAnnotationBean(RocketMQProperties properties, ApplicationContext ctx, MessageListenerOrderly listenerOrderly, MessageListenerConcurrently listenerConcurrently) {
        this.properties = properties;
        this.ctx = ctx;
        this.listenerOrderly = listenerOrderly;
        this.listenerConcurrently = listenerConcurrently;
    }

    private void initConsumer() {
        HashMap topicAll = Maps.newHashMap();
        RocketMQProperties.Consumer consumerProperty = this.properties.getConsumer();
        Map beansOfType = this.ctx.getBeansOfType(RocketMQListener.class);
        for (Map.Entry entry : beansOfType.entrySet()) {
            RocketMQMessageListener annotationMessageListener;
            String consumerGroup = consumerProperty.getGroupName();
            if (!StringUtils.hasText((String)consumerGroup)) {
                throw new ConsumerRegisterException("consumerGroup empty.");
            }
            RocketMQListener listener = (RocketMQListener)entry.getValue();
            Class cls = listener.getClass();
            if (AopUtils.isAopProxy((Object)listener)) {
                cls = AopProxyUtils.ultimateTargetClass((Object)listener);
            }
            if ((annotationMessageListener = cls.getAnnotation(RocketMQMessageListener.class)) == null) {
                throw new ConsumerRegisterException(String.format("class:%s \u6ca1\u6709\u6ce8\u89e3 @RocketMQMessageListener", cls.getName()));
            }
            String topic = annotationMessageListener.topic();
            if (!StringUtils.hasText((String)topic)) {
                throw new ConsumerRegisterException("topic empty.");
            }
            String groupName = annotationMessageListener.groupName();
            groupName = StringUtils.isEmpty((Object)groupName) ? consumerGroup : consumerGroup + "-" + groupName;
            ArrayList<String> topicList = (ArrayList<String>)topicAll.get(groupName);
            if (topicList == null) {
                topicList = new ArrayList<String>();
            }
            topicList.add(topic);
            topicAll.put(groupName, topicList);
            Map tagMQListenerMap = (Map)SUBSCRIPTION_TABLE.get(topic);
            if (tagMQListenerMap == null) {
                tagMQListenerMap = Maps.newHashMap();
                SUBSCRIPTION_TABLE.put(topic, tagMQListenerMap);
            }
            for (String tag : annotationMessageListener.tags()) {
                if (tagMQListenerMap.containsKey(tag)) {
                    throw new ConsumerRegisterException(String.format("\u91cd\u590d\u7684tag\u76d1\u542c, %s:%s", topic, tag));
                }
                tagMQListenerMap.put(tag, listener);
            }
        }
        for (Map.Entry entry : topicAll.entrySet()) {
            String groupName = (String)entry.getKey();
            DefaultMQPushConsumer consumer = new DefaultMQPushConsumer(StringUtils.hasText((String)this.properties.getAccessKey()) && StringUtils.hasText((String)this.properties.getSecretKey()) ? new AclClientRPCHook(new SessionCredentials(this.properties.getAccessKey(), this.properties.getSecretKey())) : null);
            if (this.properties.isNamespaceEnable()) {
                consumer.setNamespace(this.properties.getNamespace().toString());
            }
            consumer.setNamesrvAddr(this.properties.getNameServer());
            consumer.setConsumerGroup(groupName);
            consumer.setMaxReconsumeTimes(consumerProperty.getMaxRetryCount());
            consumer.setConsumeTimeout(consumerProperty.getTimeout());
            consumer.setConsumeFromWhere(consumerProperty.getConsumeFromWhere());
            consumer.setUnitMode(true);
            consumer.setUnitName(groupName);
            consumer.setConsumeMessageBatchMaxSize(1);
            if (consumerProperty.getConsumeMode() == ConsumeMode.CONCURRENTLY) {
                consumer.setMessageListener((MessageListener)this.listenerConcurrently);
                consumer.setConsumeThreadMin(consumerProperty.getMaxThread());
                consumer.setConsumeThreadMax(consumerProperty.getMaxThread());
            } else {
                consumer.setMessageListener((MessageListener)this.listenerOrderly);
                consumer.setSuspendCurrentQueueTimeMillis((long)consumerProperty.getSuspendCurrentQueueTimeMillis());
            }
            if (consumerProperty.getPullBatchSize() > 0) {
                consumer.setPullBatchSize(consumerProperty.getPullBatchSize());
            }
            if (consumerProperty.getQueueCacheCount() > 0) {
                consumer.setPullThresholdForQueue(consumerProperty.getQueueCacheCount());
            }
            if (consumerProperty.getTopicCacheCount() > 0) {
                consumer.setPullThresholdForTopic(consumerProperty.getTopicCacheCount());
            }
            if (consumerProperty.getConsumeFromWhere() == ConsumeFromWhere.CONSUME_FROM_TIMESTAMP) {
                if (StringUtils.hasText((String)consumerProperty.getConsumeTimestamp()) && consumerProperty.getConsumeTimestamp().length() != 14) {
                    throw new ConsumerRegisterException("consumeTimestamp \u683c\u5f0f\u4e0d\u6b63\u786e.");
                }
                consumer.setConsumeTimestamp(consumerProperty.getConsumeTimestamp());
            }
            consumer.setAllocateMessageQueueStrategy((AllocateMessageQueueStrategy)new AllocateMessageQueueAveragelyByCircle());
            log.info("\u6d88\u8d39\u8005\u7b56\u7565\u5e73\u8861\u673a\u5236\u6539\u6210\u73af\u5f62\u5e73\u5747");
            List topicList = (List)entry.getValue();
            for (String topic : topicList) {
                String tags = Joiner.on((String)" || ").join(this.getSubscriptionTable().get(topic).keySet());
                try {
                    consumer.subscribe(topic, tags.contains("*") ? "*" : tags);
                    log.info("ConsumerGroup:{} \u8ba2\u9605 topic: {} tags: {} ", new Object[]{groupName, topic, tags});
                }
                catch (MQClientException e) {
                    log.error("ConsumerGroup:{} \u8ba2\u9605topic: {}, tags: {} \u5931\u8d25", new Object[]{groupName, topic, tags});
                }
            }
            this.consumerList.add(consumer);
        }
    }

    @Override
    public void start() {
        if (!CollectionUtils.isEmpty(this.consumerList) && this.isClosed()) {
            for (DefaultMQPushConsumer consumer : this.consumerList) {
                try {
                    log.info("Consumer in the start ....");
                    consumer.start();
                    log.info("Consumer start finish....");
                    this.running = true;
                }
                catch (MQClientException e) {
                    throw new IllegalStateException("Failed to start RocketMQ push consumer", e);
                }
            }
        }
    }

    @Override
    public void shutdown() {
        if (!CollectionUtils.isEmpty(this.consumerList) && this.isStarted()) {
            for (DefaultMQPushConsumer consumer : this.consumerList) {
                log.info("Consumer in the shutdown ....");
                consumer.shutdown();
                log.info("Consumer shutdown finish ....");
                this.running = false;
            }
        }
    }

    @Override
    public boolean isStarted() {
        return this.running;
    }

    @Override
    public boolean isClosed() {
        return !this.running;
    }

    @Override
    public Map<String, Map<String, RocketMQListener>> getSubscriptionTable() {
        return SUBSCRIPTION_TABLE;
    }

    public void afterPropertiesSet() throws Exception {
        this.initConsumer();
    }
}

