package cn.bizvane.rocketmq.spring.core.producer.stat;


import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.stat.RocketMQSendStats;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;

import java.util.Observable;
import java.util.Observer;
import java.util.Optional;

/**
 * @author wang.zeyan
 * 2019/10/29
 */
public class RocketMQSendStatsMetrics implements MeterBinder, Observer {


    private RocketMQSendStats rocketMQSendStats;

    private MeterRegistry registry;

    public RocketMQSendStatsMetrics(RocketMQSendStats rocketMQSendStats) {
        this.rocketMQSendStats = rocketMQSendStats;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        this.registry = registry;
        rocketMQSendStats.addObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {

        if(arg !=null && arg instanceof Destination) {
            Destination destination = (Destination) arg;
            Gauge.builder("rocketmq.producer.stats.total", () -> {
                return rocketMQSendStats.getTotal(destination);
            }).tag("tag", Optional.ofNullable(destination.getTag()).orElseGet(() -> "*")).tag("topic", Optional.ofNullable(destination.getTopic()).orElseGet(() -> "Empty")).register(registry);

            Gauge.builder("rocketmq.producer.stats.success", () -> {
                return rocketMQSendStats.getSuccess(destination);
            }).tag("tag", Optional.ofNullable(destination.getTag()).orElseGet(() -> "*")).tag("topic", Optional.ofNullable(destination.getTopic()).orElseGet(() -> "Empty")).register(registry);

            Gauge.builder("rocketmq.producer.stats.fail", () -> {
                return rocketMQSendStats.getFail(destination);
            }).tag("tag", Optional.ofNullable(destination.getTag()).orElseGet(() -> "*")).tag("topic", Optional.ofNullable(destination.getTopic()).orElseGet(() -> "Empty")).register(registry);
        }
    }
}
