package cn.bizvane.rocketmq.spring.core.producer;

import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;

import java.util.List;
import java.util.Random;

/**
 * @author wang.zeyan
 * @date 2019/08/20
 * 隔离负载队列选择器
 */
public class SelectMessageQueueByIsolatedLB implements MessageQueueSelector {

    /** 默认负载    */
    private static int defaultLoadBalance = 4;

    /** 最大负载    */
    private int maxLoadBalance = defaultLoadBalance;

    private Random random = new Random(maxLoadBalance);

    public SelectMessageQueueByIsolatedLB(){
    }

    public SelectMessageQueueByIsolatedLB(int maxLB) {
        this.maxLoadBalance = Math.abs(maxLB);
        this.random = new Random(maxLoadBalance);
    }

    @Override
    public MessageQueue select(List<MessageQueue> mqs, Message msg, Object arg) {

        int value = arg.hashCode();
        if (value < 0) {
            value = Math.abs(value);
        }

        if (mqs.size() > maxLoadBalance) {
            // 根据最大负载， 创造伪分区， 得出每一个伪分区队列数
            int partitionQueue = mqs.size() / maxLoadBalance;
            // 随机获得一个伪分区
            int randomPartition = random.nextInt(maxLoadBalance);
            // 得到基于伪分区队列的 hash余
            value = value % partitionQueue;
            // 随机伪分区位置 * 伪分区队列数 + hash余
            return mqs.get(randomPartition * partitionQueue + value);
        } else {
            return mqs.get(value % mqs.size());
        }
    }
}
