package cn.bizvane.rocketmq.spring.core.consumer;

import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;

import java.util.List;
import java.util.Optional;

/**
 * @author wang.zeyan
 * @date 2019/08/20
 */
@Slf4j
public class MessageListenerConcurrentlyImpl extends AbstractMessageListener implements MessageListenerConcurrently {
    @Override
    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
        final MessageExt messageExt = msgs.get(0);
        try {
            abstractConsumer.accept(messageExt);
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        } catch (Exception e) {
            log.error("消费异常", e);
            return ConsumeConcurrentlyStatus.RECONSUME_LATER;
        } finally {
            //Optional.ofNullable(messageExt).ifPresent(messageDiff);
        }
    }
}
