package cn.bizvane.rocketmq.spring.core;

import lombok.Data;

/**
 * @author wang.zeyan
 * @date 2019/09/16
 */
public enum MessageDelayLevel {

    /**
     * 消息延迟等级
     */
    _1s(1),
    _5s(2),
    _10s(3),
    _30s(4),
    _1m(5),
    _2m(6),
    _3m(7),
    _4m(8),
    _5m(9),
    _6m(10),
    _7m(11),
    _8m(12),
    _9m(13),
    _10m(14),
    _20m(15),
    _30m(16),
    _1h(17),
    _2h(18);

    MessageDelayLevel(int level) {
        this.level = level;
    }

    private int level;

    public int getLevel() {
        return this.level;
    }
}
