package cn.bizvane.rocketmq.zipkin.autoconfigure;

import brave.ErrorParser;
import brave.Tracer;
import cn.bizvane.rocketmq.spring.autoconfigure.RocketMQAutoConfiguration;
import cn.bizvane.rocketmq.zipkin.aspect.TraceMqConsumerAspect;
import cn.bizvane.rocketmq.zipkin.aspect.TraceMqProducerAspect;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.producer.MQProducer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.autoconfig.zipkin2.ZipkinAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

/**
 * @author wang.zeyan
 * @date 2019/08/23
 */
@Configuration
@EnableAspectJAutoProxy
@ConditionalOnBean({Tracer.class, ErrorParser.class})
@AutoConfigureAfter({ZipkinAutoConfiguration.class, RocketMQAutoConfiguration.class})
@Slf4j
public class ZipkinAspectAutoConfiguration {
	
	@Bean
	@ConditionalOnMissingBean
	@ConditionalOnBean(MQProducer.class)
	public TraceMqProducerAspect traceMqProducerAspect(Tracer tracer, ErrorParser errorParser){
		if(log.isDebugEnabled()) {
			log.debug("创建RocketMq Producer Aspect");
		}
		return new TraceMqProducerAspect(tracer, errorParser);
	}
	
	@Bean
	@ConditionalOnMissingBean
	@ConditionalOnBean(MessageListener.class)
	public TraceMqConsumerAspect traceMqConsumerAspect(Tracer tracer, ErrorParser errorParser){
		if(log.isDebugEnabled()) {
			log.debug("创建RocketMq Consumer Aspect");
		}
		return new TraceMqConsumerAspect(tracer, errorParser);
	}
}
