/*
 * Decompiled with CFR 0.152.
 */
package cn.bizvane.rocketmq.zipkin.aspect;

import brave.ErrorParser;
import brave.Span;
import brave.Tracer;
import brave.propagation.B3SingleFormat;
import brave.propagation.TraceContext;
import cn.bizvane.rocketmq.zipkin.RocketMQZipkin;
import cn.bizvane.rocketmq.zipkin.aspect.AbstractTraceAspect;
import org.apache.rocketmq.common.message.Message;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Aspect
public class TraceMqProducerAspect
extends AbstractTraceAspect
implements RocketMQZipkin {
    private static final Logger log = LoggerFactory.getLogger(TraceMqProducerAspect.class);

    public TraceMqProducerAspect(Tracer tracer, ErrorParser errorParser) {
        super(tracer, errorParser);
    }

    @Around(value="execution(* org.apache.rocketmq.client.producer.MQProducer.send(..)) && args(message,..)")
    public Object around(ProceedingJoinPoint pjp, Message message) throws Throwable {
        Span span = null;
        try {
            String spanName = String.format("rocketmq-producer[%s][%s]", message.getTopic(), message.getTags());
            this.tracer.startScopedSpan(spanName);
            span = this.tracer.currentSpan();
            span.kind(Span.Kind.PRODUCER);
            if (!StringUtils.hasText((String)message.getKeys())) {
                message.setKeys(span.context().spanIdString());
            }
            span.tag("topic", message.getTopic());
            span.tag("keys", message.getKeys());
            span.tag("tags", message.getTags());
            log.info("{}", (Object)span);
            message.putUserProperty("B3", B3SingleFormat.writeB3SingleFormat((TraceContext)span.context()));
            Object object = pjp.proceed();
            return object;
        }
        catch (Exception e) {
            span.error((Throwable)e);
            throw e;
        }
        finally {
            span.finish(2000L);
        }
    }
}

