package cn.bizvane.rocketmq.zipkin.aspect;

import brave.ErrorParser;
import brave.Span;
import brave.Tracer;
import brave.propagation.B3SingleFormat;
import brave.propagation.TraceContextOrSamplingFlags;
import cn.bizvane.rocketmq.zipkin.RocketMQZipkin;
import org.apache.rocketmq.common.message.MessageExt;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;

import java.util.List;


/**
 * @author wang.zeyan
 * 2019/08/23
 */
@Aspect
public class TraceMqConsumerAspect extends AbstractTraceAspect implements RocketMQZipkin {

	public TraceMqConsumerAspect(Tracer tracer, ErrorParser errorParser) {
		super(tracer, errorParser);
	}

	final static String ORDER_MESSAGE_ASPECT = "execution(* org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly.consumeMessage(..))";
	final static String CONCURRENT_MESSAGE_ASPECT = "execution(* org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently.consumeMessage(..))";
	final static String ASPECT = "(" + ORDER_MESSAGE_ASPECT + " || " + CONCURRENT_MESSAGE_ASPECT + ") && args(msgs,..)";

	@Around(ASPECT)
	public Object around(final ProceedingJoinPoint pjp, List<MessageExt> msgs) throws Throwable {
	    MessageExt message = msgs.get(0);
		Span span = null;
		try {
			TraceContextOrSamplingFlags extracted = null;

            String b3 = message.getUserProperty(B3);
			if (b3 == null) {
				extracted = TraceContextOrSamplingFlags.EMPTY;
			} else {
				extracted = B3SingleFormat.parseB3SingleFormat(String.valueOf(b3));
				if(extracted == null) {
					extracted = TraceContextOrSamplingFlags.EMPTY;
				}
			}
			String name = String.format("rocketmq-consumer[%s][%s][%s]", message.getTopic(), message.getTags(), message.getReconsumeTimes());
			tracer.startScopedSpanWithParent(name, extracted.context());
			span = tracer.currentSpan();
			span.tag("topic", message.getTopic());
			span.tag("keys", message.getKeys());
			span.tag("tags", message.getTags());
			span.tag("reconsumeCount", String.valueOf(message.getReconsumeTimes()));
			
			span.kind(Span.Kind.CONSUMER);
            return pjp.proceed();
		} catch (Exception e) {
			span.error(e);
			throw e;
		} finally {
			span.finish();
		}
	}

}
