/*
 * Decompiled with CFR 0.152.
 */
package cn.bizvane.rocketmq.zipkin.aspect;

import brave.ErrorParser;
import brave.Span;
import brave.Tracer;
import brave.propagation.B3SingleFormat;
import brave.propagation.TraceContextOrSamplingFlags;
import cn.bizvane.rocketmq.zipkin.RocketMQZipkin;
import cn.bizvane.rocketmq.zipkin.aspect.AbstractTraceAspect;
import java.util.List;
import org.apache.rocketmq.common.message.MessageExt;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class TraceMqConsumerAspect
extends AbstractTraceAspect
implements RocketMQZipkin {
    static final String ORDER_MESSAGE_ASPECT = "execution(* org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly.consumeMessage(..))";
    static final String CONCURRENT_MESSAGE_ASPECT = "execution(* org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently.consumeMessage(..))";
    static final String ASPECT = "(execution(* org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly.consumeMessage(..)) || execution(* org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently.consumeMessage(..))) && args(msgs,..)";

    public TraceMqConsumerAspect(Tracer tracer, ErrorParser errorParser) {
        super(tracer, errorParser);
    }

    @Around(value="(execution(* org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly.consumeMessage(..)) || execution(* org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently.consumeMessage(..))) && args(msgs,..)")
    public Object around(ProceedingJoinPoint pjp, List<MessageExt> msgs) throws Throwable {
        MessageExt message = msgs.get(0);
        Span span = null;
        try {
            TraceContextOrSamplingFlags extracted = null;
            String b3 = message.getUserProperty("B3");
            if (b3 == null) {
                extracted = TraceContextOrSamplingFlags.EMPTY;
            } else {
                extracted = B3SingleFormat.parseB3SingleFormat((CharSequence)String.valueOf(b3));
                if (extracted == null) {
                    extracted = TraceContextOrSamplingFlags.EMPTY;
                }
            }
            String name = String.format("rocketmq-consumer[%s][%s][%s]", message.getTopic(), message.getTags(), message.getReconsumeTimes());
            this.tracer.startScopedSpanWithParent(name, extracted.context());
            span = this.tracer.currentSpan();
            span.tag("topic", message.getTopic());
            span.tag("keys", message.getKeys());
            span.tag("tags", message.getTags());
            span.tag("reconsumeCount", String.valueOf(message.getReconsumeTimes()));
            span.kind(Span.Kind.CONSUMER);
            Object object = pjp.proceed();
            return object;
        }
        catch (Exception e) {
            span.error((Throwable)e);
            throw e;
        }
        finally {
            span.finish();
        }
    }
}

