/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel.imports.sax.parse;

import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelCollectionParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelImportEntity;
import cn.afterturn.easypoi.excel.entity.sax.SaxReadCellEntity;
import cn.afterturn.easypoi.excel.imports.CellValueService;
import cn.afterturn.easypoi.excel.imports.base.ImportBaseService;
import cn.afterturn.easypoi.excel.imports.sax.parse.ISaxRowRead;
import cn.afterturn.easypoi.exception.excel.ExcelImportException;
import cn.afterturn.easypoi.handler.inter.IExcelReadRowHandler;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import cn.afterturn.easypoi.util.PoiReflectorUtil;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaxRowRead
extends ImportBaseService
implements ISaxRowRead {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaxRowRead.class);
    private List list;
    private Class<?> pojoClass;
    private ImportParams params;
    private Map<Integer, String> titlemap = new HashMap<Integer, String>();
    private Object object = null;
    private Map<String, ExcelImportEntity> excelParams = new HashMap<String, ExcelImportEntity>();
    private List<ExcelCollectionParams> excelCollection = new ArrayList<ExcelCollectionParams>();
    private String targetId;
    private CellValueService cellValueServer;
    private IExcelReadRowHandler hanlder;

    public SaxRowRead(Class<?> pojoClass, ImportParams params, IExcelReadRowHandler hanlder) {
        this.list = Lists.newArrayList();
        this.params = params;
        this.pojoClass = pojoClass;
        this.cellValueServer = new CellValueService();
        this.hanlder = hanlder;
        this.initParams(pojoClass, params);
    }

    private void initParams(Class<?> pojoClass, ImportParams params) {
        try {
            Field[] fileds = PoiPublicUtil.getClassFields(pojoClass);
            ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
            if (etarget != null) {
                this.targetId = etarget.value();
            }
            this.getAllExcelField(this.targetId, fileds, this.excelParams, this.excelCollection, pojoClass, null, null);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelImportException(e.getMessage());
        }
    }

    @Override
    public <T> List<T> getList() {
        return this.list;
    }

    @Override
    public void parse(int index, List<SaxReadCellEntity> datas) {
        try {
            if (datas == null || datas.size() == 0) {
                return;
            }
            if (index < this.params.getTitleRows()) {
                return;
            }
            if (index < this.params.getTitleRows() + this.params.getHeadRows()) {
                this.addHeadData(datas);
            } else {
                this.addListData(datas);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelImportException(e.getMessage());
        }
    }

    private void addListData(List<SaxReadCellEntity> datas) throws Exception {
        if (this.params.getKeyIndex() != null && (datas.get(this.params.getKeyIndex()) == null || StringUtils.isEmpty((CharSequence)String.valueOf(datas.get(this.params.getKeyIndex()).getValue()))) && this.object != null) {
            for (ExcelCollectionParams param : this.excelCollection) {
                this.addListContinue(this.object, param, datas, this.titlemap, this.targetId, this.params);
            }
        } else {
            if (this.object != null && this.hanlder != null) {
                this.hanlder.handler(this.object);
            }
            this.object = PoiPublicUtil.createObject(this.pojoClass, this.targetId);
            int le = datas.size();
            for (int i = 0; i < le; ++i) {
                SaxReadCellEntity entity = datas.get(i);
                String titleString = this.titlemap.get(i);
                if (!this.excelParams.containsKey(titleString)) continue;
                this.saveFieldValue(this.params, this.object, entity, this.excelParams, titleString);
            }
            for (ExcelCollectionParams param : this.excelCollection) {
                this.addListContinue(this.object, param, datas, this.titlemap, this.targetId, this.params);
            }
            if (this.hanlder == null) {
                this.list.add(this.object);
            }
        }
    }

    private void addListContinue(Object object, ExcelCollectionParams param, List<SaxReadCellEntity> datas, Map<Integer, String> titlemap, String targetId, ImportParams params) throws Exception {
        Collection collection = (Collection)PoiReflectorUtil.fromCache(this.pojoClass).getValue(object, param.getName());
        Object entity = PoiPublicUtil.createObject(param.getType(), targetId);
        boolean isUsed = false;
        for (int i = 0; i < datas.size(); ++i) {
            String titleString = titlemap.get(i);
            if (!param.getExcelParams().containsKey(titleString)) continue;
            this.saveFieldValue(params, entity, datas.get(i), param.getExcelParams(), titleString);
            isUsed = true;
        }
        if (isUsed) {
            collection.add(entity);
        }
    }

    private void saveFieldValue(ImportParams params, Object object, SaxReadCellEntity entity, Map<String, ExcelImportEntity> excelParams, String titleString) throws Exception {
        Object value = this.cellValueServer.getValue(params.getDataHandler(), object, entity, excelParams, titleString);
        this.setValues(excelParams.get(titleString), object, value);
    }

    private void addHeadData(List<SaxReadCellEntity> datas) {
        for (int i = 0; i < datas.size(); ++i) {
            if (!StringUtils.isNotEmpty((CharSequence)String.valueOf(datas.get(i).getValue()))) continue;
            this.titlemap.put(i, String.valueOf(datas.get(i).getValue()));
        }
    }
}

