/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel.export;

import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.export.ExcelExportService;
import cn.afterturn.easypoi.excel.export.styler.IExcelExportStyler;
import cn.afterturn.easypoi.exception.excel.ExcelExportException;
import cn.afterturn.easypoi.exception.excel.enums.ExcelExportEnum;
import cn.afterturn.easypoi.util.PoiExcelGraphDataUtil;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelBatchExportService
extends ExcelExportService {
    private static ThreadLocal<ExcelBatchExportService> THREAD_LOCAL = new ThreadLocal();
    private Workbook workbook;
    private Sheet sheet;
    private List<ExcelExportEntity> excelParams;
    private ExportParams entity;
    private int titleHeight;
    private Drawing patriarch;
    private short rowHeight;
    private int index;

    public void init(ExportParams entity, Class<?> pojoClass) {
        List<ExcelExportEntity> excelParams = this.createExcelExportEntityList(entity, pojoClass);
        this.init(entity, excelParams);
    }

    public void init(ExportParams entity, List<ExcelExportEntity> excelParams) {
        LOGGER.debug("ExcelBatchExportServer only support SXSSFWorkbook");
        entity.setType(ExcelType.XSSF);
        this.workbook = new SXSSFWorkbook();
        this.entity = entity;
        this.excelParams = excelParams;
        this.type = entity.getType();
        this.createSheet(this.workbook, entity, excelParams);
        if (entity.getMaxNum() == 0) {
            entity.setMaxNum(1000000);
        }
        this.insertDataToSheet(this.workbook, entity, excelParams, null, this.sheet);
    }

    public List<ExcelExportEntity> createExcelExportEntityList(ExportParams entity, Class<?> pojoClass) {
        try {
            ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
            if (entity.isAddIndex()) {
                excelParams.add(this.indexExcelEntity(entity));
            }
            Field[] fileds = PoiPublicUtil.getClassFields(pojoClass);
            ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
            String targetId = etarget == null ? null : etarget.value();
            this.getAllExcelField(entity.getExclusions(), targetId, fileds, excelParams, pojoClass, null, null);
            this.sortAllParams(excelParams);
            return excelParams;
        }
        catch (Exception e) {
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, (Throwable)e);
        }
    }

    public void createSheet(Workbook workbook, ExportParams entity, List<ExcelExportEntity> excelParams) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Excel export start ,List<ExcelExportEntity> is {}", excelParams);
            LOGGER.debug("Excel version is {}", (Object)(entity.getType().equals((Object)ExcelType.HSSF) ? "03" : "07"));
        }
        if (workbook == null || entity == null || excelParams == null) {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
        try {
            try {
                this.sheet = workbook.createSheet(entity.getSheetName());
            }
            catch (Exception e) {
                this.sheet = workbook.createSheet();
            }
        }
        catch (Exception e) {
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, (Throwable)e);
        }
    }

    public Workbook appendData(Collection<?> dataSet) {
        if (this.sheet.getLastRowNum() + dataSet.size() > this.entity.getMaxNum()) {
            this.sheet = this.workbook.createSheet();
            this.index = 0;
        }
        for (Object t : dataSet) {
            try {
                this.index += this.createCells(this.patriarch, this.index, t, this.excelParams, this.sheet, this.workbook, this.rowHeight, 0)[0];
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, (Throwable)e);
            }
        }
        return this.workbook;
    }

    @Override
    protected void insertDataToSheet(Workbook workbook, ExportParams entity, List<ExcelExportEntity> entityList, Collection<?> dataSet, Sheet sheet) {
        try {
            this.dataHandler = entity.getDataHandler();
            if (this.dataHandler != null && this.dataHandler.getNeedHandlerFields() != null) {
                this.needHandlerList = Arrays.asList(this.dataHandler.getNeedHandlerFields());
            }
            this.setExcelExportStyler((IExcelExportStyler)entity.getStyle().getConstructor(Workbook.class).newInstance(workbook));
            this.patriarch = PoiExcelGraphDataUtil.getDrawingPatriarch(sheet);
            ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
            if (entity.isAddIndex()) {
                excelParams.add(this.indexExcelEntity(entity));
            }
            excelParams.addAll(entityList);
            this.sortAllParams(excelParams);
            this.titleHeight = this.index = entity.isCreateHeadRows() ? this.createHeaderAndTitle(entity, sheet, workbook, excelParams) : 0;
            this.setCellWith(excelParams, sheet);
            this.rowHeight = this.getRowHeight(excelParams);
            this.setCurrentIndex(1);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, e.getCause());
        }
    }

    public static ExcelBatchExportService getExcelBatchExportService(ExportParams entity, Class<?> pojoClass) {
        if (THREAD_LOCAL.get() == null) {
            ExcelBatchExportService batchServer = new ExcelBatchExportService();
            batchServer.init(entity, pojoClass);
            THREAD_LOCAL.set(batchServer);
        }
        return THREAD_LOCAL.get();
    }

    public static ExcelBatchExportService getExcelBatchExportService(ExportParams entity, List<ExcelExportEntity> excelParams) {
        if (THREAD_LOCAL.get() == null) {
            ExcelBatchExportService batchServer = new ExcelBatchExportService();
            batchServer.init(entity, excelParams);
            THREAD_LOCAL.set(batchServer);
        }
        return THREAD_LOCAL.get();
    }

    public static ExcelBatchExportService getCurrentExcelBatchExportService() {
        return THREAD_LOCAL.get();
    }

    public void closeExportBigExcel() {
        if (this.entity.getFreezeCol() != 0) {
            this.sheet.createFreezePane(this.entity.getFreezeCol(), 0, this.entity.getFreezeCol(), 0);
        }
        this.mergeCells(this.sheet, this.excelParams, this.titleHeight);
        this.addStatisticsRow(this.getExcelExportStyler().getStyles(true, null), this.sheet);
        THREAD_LOCAL.remove();
    }
}

