/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.Advisor;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.IntroductionInterceptor;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.TargetSource;
import org.springframework.aop.ThrowsAdvice;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupportListener;
import org.springframework.aop.framework.AdvisorChainFactory;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.HashMapCachingAdvisorChainFactory;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.util.StringUtils;

public class AdvisedSupport
extends ProxyConfig
implements Advised {
    public static final TargetSource EMPTY_TARGET_SOURCE = new TargetSource(){

        public Class getTargetClass() {
            return null;
        }

        public boolean isStatic() {
            return true;
        }

        public Object getTarget() {
            return null;
        }

        public void releaseTarget(Object target) {
        }
    };
    private final List listeners = new LinkedList();
    TargetSource targetSource = EMPTY_TARGET_SOURCE;
    AdvisorChainFactory advisorChainFactory;
    private List advisors = new LinkedList();
    private Advisor[] advisorsArray = new Advisor[0];
    private Set interfaces = new HashSet();
    private boolean isActive;

    public AdvisedSupport() {
        this.setAdvisorChainFactory(new HashMapCachingAdvisorChainFactory());
    }

    public AdvisedSupport(Class[] interfaces) {
        this();
        this.setInterfaces(interfaces);
    }

    public void addListener(AdvisedSupportListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(AdvisedSupportListener listener) {
        this.listeners.remove(listener);
    }

    public void setTarget(Object target) {
        this.setTargetSource(new SingletonTargetSource(target));
    }

    public void setTargetSource(TargetSource targetSource) {
        if (this.isActive() && this.getOptimize()) {
            throw new AopConfigException("Can't change target with an optimized CGLIB proxy: it has it's own target");
        }
        this.targetSource = targetSource;
    }

    public TargetSource getTargetSource() {
        return this.targetSource;
    }

    public void setAdvisorChainFactory(AdvisorChainFactory advisorChainFactory) {
        this.advisorChainFactory = advisorChainFactory;
        this.addListener(advisorChainFactory);
    }

    public AdvisorChainFactory getAdvisorChainFactory() {
        return this.advisorChainFactory;
    }

    protected void copyConfigurationFrom(AdvisedSupport other) {
        this.copyFrom(other);
        this.targetSource = other.targetSource;
        this.setInterfaces(other.interfaces.toArray(new Class[other.interfaces.size()]));
        this.advisors = new LinkedList();
        for (int i = 0; i < other.advisors.size(); ++i) {
            Advisor advice = (Advisor)other.advisors.get(i);
            this.addAdvisor(advice);
        }
    }

    public void setInterfaces(Class[] interfaces) {
        this.interfaces.clear();
        for (int i = 0; i < interfaces.length; ++i) {
            this.addInterface(interfaces[i]);
        }
    }

    public void addInterface(Class newInterface) {
        this.interfaces.add(newInterface);
        this.adviceChanged();
        this.logger.debug((Object)("Added new aspect interface: " + newInterface));
    }

    public Class[] getProxiedInterfaces() {
        return this.interfaces.toArray(new Class[this.interfaces.size()]);
    }

    public boolean removeInterface(Class intf) {
        return this.interfaces.remove(intf);
    }

    public void addInterceptor(Interceptor interceptor) throws AopConfigException {
        int pos = this.advisors != null ? this.advisors.size() : 0;
        this.addInterceptor(pos, interceptor);
    }

    public boolean isInterfaceProxied(Class intf) {
        Iterator it = this.interfaces.iterator();
        while (it.hasNext()) {
            Class proxyIntf = (Class)it.next();
            if (!intf.isAssignableFrom(proxyIntf)) continue;
            return true;
        }
        return false;
    }

    public void addInterceptor(int pos, Interceptor interceptor) throws AopConfigException {
        if (!(interceptor instanceof MethodInterceptor)) {
            throw new AopConfigException(this.getClass().getName() + " only handles MethodInterceptors");
        }
        if (interceptor instanceof IntroductionInterceptor) {
            throw new AopConfigException("IntroductionInterceptors may only be added as part of IntroductionAdvice");
        }
        this.addAdvisor(pos, new DefaultPointcutAdvisor((Advice)interceptor));
    }

    public final boolean removeInterceptor(Interceptor interceptor) throws AopConfigException {
        int index = this.indexOf(interceptor);
        if (index == -1) {
            return false;
        }
        this.removeAdvisor(index);
        return true;
    }

    public void addAfterReturningAdvice(AfterReturningAdvice ara) throws AopConfigException {
        this.addAdvisor(new DefaultPointcutAdvisor(Pointcut.TRUE, ara));
    }

    public void addBeforeAdvice(MethodBeforeAdvice ba) throws AopConfigException {
        this.addAdvisor(new DefaultPointcutAdvisor(Pointcut.TRUE, ba));
    }

    public void addThrowsAdvice(ThrowsAdvice throwsAdvice) throws AopConfigException {
        this.addAdvisor(new DefaultPointcutAdvisor(throwsAdvice));
    }

    public int indexOf(Interceptor interceptor) {
        for (int i = 0; i < this.advisors.size(); ++i) {
            Advisor advisor = (Advisor)this.advisors.get(i);
            if (advisor.getAdvice() != interceptor) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(Advisor advisor) {
        return this.advisors.indexOf(advisor);
    }

    public final boolean removeAdvisor(Advisor advisor) {
        int index = this.indexOf(advisor);
        if (index == -1) {
            return false;
        }
        this.removeAdvisor(index);
        return true;
    }

    public void removeAdvisor(int index) throws AopConfigException {
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot remove Advisor: config is frozen");
        }
        if (index < 0 || index > this.advisors.size() - 1) {
            throw new AopConfigException("Advisor index " + index + " is out of bounds: " + "Only have " + this.advisors.size() + " advisors");
        }
        Advisor advisor = (Advisor)this.advisors.get(index);
        if (advisor instanceof IntroductionAdvisor) {
            IntroductionAdvisor ia = (IntroductionAdvisor)advisor;
            for (int j = 0; j < ia.getInterfaces().length; ++j) {
                this.removeInterface(ia.getInterfaces()[j]);
            }
        }
        this.advisors.remove(index);
        this.updateAdvisorsArray();
        this.adviceChanged();
    }

    private void addAdvisorInternal(int pos, Advisor advice) throws AopConfigException {
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot add advisor: config is frozen");
        }
        this.advisors.add(pos, advice);
        this.updateAdvisorsArray();
        this.adviceChanged();
    }

    public void addAdvisor(int pos, IntroductionAdvisor advisor) throws AopConfigException {
        advisor.validateInterfaces();
        for (int i = 0; i < advisor.getInterfaces().length; ++i) {
            this.addInterface(advisor.getInterfaces()[i]);
        }
        this.addAdvisorInternal(pos, advisor);
    }

    public void addAdvisor(int pos, Advisor advisor) throws AopConfigException {
        if (advisor instanceof IntroductionAdvisor) {
            this.addAdvisor(pos, (IntroductionAdvisor)advisor);
        } else {
            this.addAdvisorInternal(pos, advisor);
        }
    }

    public void addAdvisor(Advisor advice) {
        int pos = this.advisors.size();
        this.addAdvisor(pos, advice);
    }

    private void updateAdvisorsArray() {
        this.advisorsArray = this.advisors.toArray(new Advisor[this.advisors.size()]);
    }

    public final Advisor[] getAdvisors() {
        return this.advisorsArray;
    }

    public final boolean replaceAdvisor(Advisor a, Advisor b) throws AopConfigException {
        int index = this.indexOf(a);
        if (index == -1 || b == null) {
            return false;
        }
        this.removeAdvisor(index);
        this.addAdvisor(index, b);
        return true;
    }

    public final boolean interceptorIncluded(Interceptor mi) {
        if (this.advisors.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.advisors.size(); ++i) {
            Advisor advice = (Advisor)this.advisors.get(i);
            if (advice.getAdvice() != mi) continue;
            return true;
        }
        return false;
    }

    public final int countInterceptorsOfType(Class interceptorClass) {
        if (this.advisors.size() == 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.advisors.size(); ++i) {
            Advisor advisor = (Advisor)this.advisors.get(i);
            if (!interceptorClass.isAssignableFrom(advisor.getAdvice().getClass())) continue;
            ++count;
        }
        return count;
    }

    private synchronized void adviceChanged() {
        if (this.isActive) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((AdvisedSupportListener)this.listeners.get(i)).adviceChanged(this);
            }
        }
    }

    private void activate() {
        this.isActive = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((AdvisedSupportListener)this.listeners.get(i)).activated(this);
        }
    }

    protected synchronized AopProxy createAopProxy() {
        if (!this.isActive) {
            this.activate();
        }
        return this.getAopProxyFactory().createAopProxy(this);
    }

    protected final boolean isActive() {
        return this.isActive;
    }

    public String toProxyConfigString() {
        return this.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + ": ");
        sb.append(this.interfaces.size()).append(" interfaces=[");
        sb.append(StringUtils.collectionToCommaDelimitedString((Collection)this.interfaces)).append("]; ");
        sb.append(this.advisors.size()).append(" pointcuts=[");
        sb.append(StringUtils.collectionToCommaDelimitedString((Collection)this.advisors)).append("]; ");
        sb.append("targetSource=[").append(this.targetSource).append("]; ");
        sb.append("advisorChainFactory=").append(this.advisorChainFactory);
        sb.append(super.toString());
        return sb.toString();
    }
}

